/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Duel;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;
import javolution.util.FastList;

public class DuelManager {
    private static final Logger _log = Logger.getLogger(DuelManager.class.getName());
    private FastList<Duel> _duels;
    private int _currentDuelId = 144;

    public static final DuelManager getInstance() {
        return SingletonHolder._instance;
    }

    private DuelManager() {
        _log.info("Initializing DuelManager");
        this._duels = new FastList();
    }

    private int getNextDuelId() {
        if (++this._currentDuelId >= 0x7FFFFFF8) {
            this._currentDuelId = 1;
        }
        return this._currentDuelId;
    }

    public Duel getDuel(int duelId) {
        FastList.Node e = this._duels.head();
        FastList.Node end = this._duels.tail();
        while ((e = e.getNext()) != end) {
            if (((Duel)e.getValue()).getId() != duelId) continue;
            return (Duel)e.getValue();
        }
        return null;
    }

    public void addDuel(L2PcInstance playerA, L2PcInstance playerB, int partyDuel) {
        if (playerA == null || playerB == null) {
            return;
        }
        String engagedInPvP = "The duel was canceled because a duelist engaged in PvP combat.";
        if (partyDuel == 1) {
            boolean playerInPvP = false;
            for (L2PcInstance temp : playerA.getParty().getPartyMembers()) {
                if (temp.getPvpFlag() == 0) continue;
                playerInPvP = true;
                break;
            }
            if (!playerInPvP) {
                for (L2PcInstance temp : playerB.getParty().getPartyMembers()) {
                    if (temp.getPvpFlag() == 0) continue;
                    playerInPvP = true;
                    break;
                }
            }
            if (playerInPvP) {
                for (L2PcInstance temp : playerA.getParty().getPartyMembers()) {
                    temp.sendMessage(engagedInPvP);
                }
                for (L2PcInstance temp : playerB.getParty().getPartyMembers()) {
                    temp.sendMessage(engagedInPvP);
                }
                return;
            }
        } else if (playerA.getPvpFlag() != 0 || playerB.getPvpFlag() != 0) {
            playerA.sendMessage(engagedInPvP);
            playerB.sendMessage(engagedInPvP);
            return;
        }
        Duel duel = new Duel(playerA, playerB, partyDuel, this.getNextDuelId());
        this._duels.add((Object)duel);
    }

    public void removeDuel(Duel duel) {
        this._duels.remove((Object)duel);
    }

    public void doSurrender(L2PcInstance player) {
        if (player == null || !player.isInDuel()) {
            return;
        }
        Duel duel = this.getDuel(player.getDuelId());
        duel.doSurrender(player);
    }

    public void onPlayerDefeat(L2PcInstance player) {
        if (player == null || !player.isInDuel()) {
            return;
        }
        Duel duel = this.getDuel(player.getDuelId());
        if (duel != null) {
            duel.onPlayerDefeat(player);
        }
    }

    public void onBuff(L2PcInstance player, L2Effect buff) {
        if (player == null || !player.isInDuel() || buff == null) {
            return;
        }
        Duel duel = this.getDuel(player.getDuelId());
        if (duel != null) {
            duel.onBuff(player, buff);
        }
    }

    public void onRemoveFromParty(L2PcInstance player) {
        if (player == null || !player.isInDuel()) {
            return;
        }
        Duel duel = this.getDuel(player.getDuelId());
        if (duel != null) {
            duel.onRemoveFromParty(player);
        }
    }

    public void broadcastToOppositTeam(L2PcInstance player, L2GameServerPacket packet) {
        if (player == null || !player.isInDuel()) {
            return;
        }
        Duel duel = this.getDuel(player.getDuelId());
        if (duel == null) {
            return;
        }
        if (duel.getPlayerA() == null || duel.getPlayerB() == null) {
            return;
        }
        if (duel.getPlayerA() == player) {
            duel.broadcastToTeam2(packet);
        } else if (duel.getPlayerB() == player) {
            duel.broadcastToTeam1(packet);
        } else if (duel.isPartyDuel()) {
            if (duel.getPlayerA().getParty() != null && duel.getPlayerA().getParty().getPartyMembers().contains((Object)player)) {
                duel.broadcastToTeam2(packet);
            } else if (duel.getPlayerB().getParty() != null && duel.getPlayerB().getParty().getPartyMembers().contains((Object)player)) {
                duel.broadcastToTeam1(packet);
            }
        }
    }

    private static class SingletonHolder {
        protected static final DuelManager _instance = new DuelManager();

        private SingletonHolder() {
        }
    }
}

