/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class GlobalVariablesManager {
    private static final Logger _log = Logger.getLogger(GlobalVariablesManager.class.getName());
    private static final String LOAD_VAR = "SELECT var,value FROM global_variables";
    private static final String SAVE_VAR = "INSERT INTO global_variables (var,value) VALUES (?,?) ON DUPLICATE KEY UPDATE value=?";
    private final Map<String, String> _variablesMap = new FastMap();

    private GlobalVariablesManager() {
        this.loadVars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadVars() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(LOAD_VAR);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                String var = rset.getString(1);
                String value = rset.getString(2);
                this._variablesMap.put(var, value);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("GlobalVariablesManager: problem while loading variables: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveVars() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(SAVE_VAR);
            for (String var : this._variablesMap.keySet()) {
                statement.setString(1, var);
                statement.setString(2, this._variablesMap.get(var));
                statement.setString(3, this._variablesMap.get(var));
                statement.execute();
            }
            statement.close();
            _log.info("GlobalVariablesManager: Database updated.");
        }
        catch (Exception e) {
            _log.warning("GlobalVariablesManager: problem while saving variables: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void storeVariable(String var, String value) {
        this._variablesMap.put(var, value);
    }

    public boolean isVariableStored(String var) {
        return this._variablesMap.containsKey(var);
    }

    public String getStoredVariable(String var) {
        return this._variablesMap.get(var);
    }

    public static final GlobalVariablesManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GlobalVariablesManager _instance = new GlobalVariablesManager();

        private SingletonHolder() {
        }
    }
}

