/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExShowDominionRegistry;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class L2CastleChamberlainInstance
extends L2MerchantInstance {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;
    private int _preDay;
    private int _preHour;

    public L2CastleChamberlainInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2CastleChamberlainInstance);
    }

    private void sendHtmlMessage(L2PcInstance player, NpcHtmlMessage html) {
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getNpcId());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            return;
        }
        if (condition == 1) {
            return;
        }
        if (condition == 2) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("banish_foreigner")) {
                if (!this.validatePrivileges(player, 0x100000)) {
                    return;
                }
                if (this.siegeBlocksFunction(player)) {
                    return;
                }
                this.getCastle().banishForeigners();
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-banishafter.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("banish_foreigner_show")) {
                if (!this.validatePrivileges(player, 0x100000)) {
                    return;
                }
                if (this.siegeBlocksFunction(player)) {
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-banishfore.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("list_siege_clans")) {
                if ((player.getClanPrivileges() & 0x40000) == 262144) {
                    this.getCastle().getSiege().listRegisterClan(player);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("list_territory_clans")) {
                if ((player.getClanPrivileges() & 0x40000) == 262144) {
                    player.sendPacket(new ExShowDominionRegistry(this.getCastle().getCastleId(), player));
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("receive_report")) {
                if (player.isClanLeader()) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-report.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    L2Clan clan = ClanTable.getInstance().getClan(this.getCastle().getOwnerId());
                    html.replace((CharSequence)"%clanname%", clan.getName());
                    html.replace((CharSequence)"%clanleadername%", clan.getLeaderName());
                    html.replace((CharSequence)"%castlename%", this.getCastle().getCastleNameHtm());
                    html.replace((CharSequence)"%ss_event%", SevenSigns.getInstance().getCurrentPeriodName());
                    html.replace((CharSequence)"%ss_avarice%", SevenSigns.getCabalNameJA(SevenSigns.getInstance().getSealOwner(1)));
                    html.replace((CharSequence)"%ss_gnosis%", SevenSigns.getCabalNameJA(SevenSigns.getInstance().getSealOwner(2)));
                    html.replace((CharSequence)"%ss_strife%", SevenSigns.getCabalNameJA(SevenSigns.getInstance().getSealOwner(3)));
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("items")) {
                if ((player.getClanPrivileges() & 0x80000) == 524288) {
                    if (val.isEmpty()) {
                        return;
                    }
                    player.tempInventoryDisable();
                    if (Config.DEBUG) {
                        _log.fine("Showing chamberlain buylist");
                    }
                    this.showBuyWindow(player, Integer.parseInt(val + "1"));
                    player.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_siege_defender")) {
                if ((player.getClanPrivileges() & 0x40000) == 262144) {
                    this.getCastle().getSiege().listRegisterClan(player);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_vault")) {
                if ((player.getClanPrivileges() & 0x200000) == 0x200000) {
                    String filename = "data/html/chamberlain/chamberlain-vault.htm";
                    long amount = 0L;
                    if (val.equalsIgnoreCase("deposit")) {
                        try {
                            amount = Long.parseLong(st.nextToken());
                        }
                        catch (NoSuchElementException e) {
                            // empty catch block
                        }
                        if (amount > 0L && this.getCastle().getTreasury() + amount < 99900000000L) {
                            if (player.reduceAdena("Castle", amount, this, true)) {
                                this.getCastle().addToTreasuryNoTax(amount);
                            } else {
                                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
                            }
                        }
                    } else if (val.equalsIgnoreCase("withdraw")) {
                        try {
                            amount = Long.parseLong(st.nextToken());
                        }
                        catch (NoSuchElementException e) {
                            // empty catch block
                        }
                        if (amount > 0L) {
                            if (this.getCastle().getTreasury() < amount) {
                                filename = "data/html/chamberlain/chamberlain-vault-no.htm";
                            } else if (this.getCastle().addToTreasuryNoTax(-1L * amount)) {
                                player.addAdena("Castle", amount, this, true);
                            }
                        }
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    html.replace((CharSequence)"%npcname%", this.getName());
                    html.replace((CharSequence)"%tax_income%", com.l2jserver.gameserver.util.Util.formatAdena(this.getCastle().getTreasury()));
                    html.replace((CharSequence)"%withdraw_amount%", com.l2jserver.gameserver.util.Util.formatAdena(amount));
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("operate_door")) {
                if ((player.getClanPrivileges() & 0x10000) == 65536) {
                    if (!val.isEmpty()) {
                        boolean open;
                        boolean bl = open = Integer.parseInt(val) == 1;
                        while (st.hasMoreTokens()) {
                            this.getCastle().openCloseDoor(player, Integer.parseInt(st.nextToken()), open);
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        String file = "data/html/chamberlain/doors-close.htm";
                        if (open) {
                            file = "data/html/chamberlain/doors-open.htm";
                        }
                        html.setFile(player.getHtmlPrefix(), file);
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        return;
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/" + this.getTemplate().npcId + "-d.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    html.replace((CharSequence)"%npcname%", this.getName());
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("tax_set")) {
                if ((player.getClanPrivileges() & 0x200000) == 0x200000) {
                    if (!val.isEmpty()) {
                        this.getCastle().setTaxPercent(player, Integer.parseInt(val));
                    }
                    String msg = StringUtil.concat("<html><body>", this.getName(), ":<br>Current tax rate: ", String.valueOf(this.getCastle().getTaxPercent()), "%<br><table><tr><td>Change tax rate to:</td><td><edit var=\"value\" width=40><br><button value=\"Adjust\" action=\"bypass -h npc_%objectId%_tax_set $value\" width=80 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table></center></body></html>");
                    this.sendHtmlMessage(player, msg);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-tax.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                html.replace((CharSequence)"%tax%", this.getCastle().getTaxPercent());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_functions")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-manage.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("products")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-products.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                html.replace((CharSequence)"%npcId%", this.getNpcId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("functions")) {
                if (val.equalsIgnoreCase("tele")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    if (this.getCastle().getFunction(1) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/" + this.getNpcId() + "-t" + this.getCastle().getFunction(1).getLvl() + ".htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("support")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    if (this.getCastle().getFunction(5) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/support" + this.getCastle().getFunction(5).getLvl() + ".htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("back")) {
                    this.showChatWindow(player);
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-functions.htm");
                    if (this.getCastle().getFunction(4) != null) {
                        html.replace((CharSequence)"%xp_regen%", this.getCastle().getFunction(4).getLvl());
                    } else {
                        html.replace((CharSequence)"%xp_regen%", "0");
                    }
                    if (this.getCastle().getFunction(2) != null) {
                        html.replace((CharSequence)"%hp_regen%", this.getCastle().getFunction(2).getLvl());
                    } else {
                        html.replace((CharSequence)"%hp_regen%", "0");
                    }
                    if (this.getCastle().getFunction(3) != null) {
                        html.replace((CharSequence)"%mp_regen%", this.getCastle().getFunction(3).getLvl());
                    } else {
                        html.replace((CharSequence)"%mp_regen%", "0");
                    }
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage")) {
                if ((player.getClanPrivileges() & 0x800000) == 0x800000) {
                    if (val.equalsIgnoreCase("recovery")) {
                        if (st.countTokens() >= 1) {
                            if (this.getCastle().getOwnerId() == 0) {
                                player.sendMessage("This castle have no owner, you cannot change configuration");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("hp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery hp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("mp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery mp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("exp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery exp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_hp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Fireplace (HP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 80: {
                                        cost = Config.CS_HPREG1_FEE;
                                        break;
                                    }
                                    case 120: {
                                        cost = Config.CS_HPREG2_FEE;
                                        break;
                                    }
                                    case 180: {
                                        cost = Config.CS_HPREG3_FEE;
                                        break;
                                    }
                                    case 240: {
                                        cost = Config.CS_HPREG4_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CS_HPREG5_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.CS_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Provides additional HP recovery for clan members in the castle.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery hp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_mp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Carpet (MP Recovery)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 5: {
                                        cost = Config.CS_MPREG1_FEE;
                                        break;
                                    }
                                    case 15: {
                                        cost = Config.CS_MPREG2_FEE;
                                        break;
                                    }
                                    case 30: {
                                        cost = Config.CS_MPREG3_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CS_MPREG4_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.CS_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Provides additional MP recovery for clan members in the castle.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery mp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_exp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Chandelier (EXP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 15: {
                                        cost = Config.CS_EXPREG1_FEE;
                                        break;
                                    }
                                    case 25: {
                                        cost = Config.CS_EXPREG2_FEE;
                                        break;
                                    }
                                    case 35: {
                                        cost = Config.CS_EXPREG3_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CS_EXPREG4_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.CS_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Restores the Exp of any clan member who is resurrected in the castle.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery exp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("hp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Hp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply_confirmed.htm");
                                    if (this.getCastle().getFunction(2) != null && this.getCastle().getFunction(2).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 80: {
                                            fee = Config.CS_HPREG1_FEE;
                                            break;
                                        }
                                        case 120: {
                                            fee = Config.CS_HPREG2_FEE;
                                            break;
                                        }
                                        case 180: {
                                            fee = Config.CS_HPREG3_FEE;
                                            break;
                                        }
                                        case 240: {
                                            fee = Config.CS_HPREG4_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CS_HPREG5_FEE;
                                        }
                                    }
                                    if (!this.getCastle().updateFunctions(player, 2, percent, fee, Config.CS_HPREG_FEE_RATIO, this.getCastle().getFunction(2) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("mp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply_confirmed.htm");
                                    if (this.getCastle().getFunction(3) != null && this.getCastle().getFunction(3).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 5: {
                                            fee = Config.CS_MPREG1_FEE;
                                            break;
                                        }
                                        case 15: {
                                            fee = Config.CS_MPREG2_FEE;
                                            break;
                                        }
                                        case 30: {
                                            fee = Config.CS_MPREG3_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CS_MPREG4_FEE;
                                        }
                                    }
                                    if (!this.getCastle().updateFunctions(player, 3, percent, fee, Config.CS_MPREG_FEE_RATIO, this.getCastle().getFunction(3) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("exp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Exp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply_confirmed.htm");
                                    if (this.getCastle().getFunction(4) != null && this.getCastle().getFunction(4).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 15: {
                                            fee = Config.CS_EXPREG1_FEE;
                                            break;
                                        }
                                        case 25: {
                                            fee = Config.CS_EXPREG2_FEE;
                                            break;
                                        }
                                        case 35: {
                                            fee = Config.CS_EXPREG3_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CS_EXPREG4_FEE;
                                        }
                                    }
                                    if (!this.getCastle().updateFunctions(player, 4, percent, fee, Config.CS_EXPREG_FEE_RATIO, this.getCastle().getFunction(4) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/edit_recovery.htm");
                        String hp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 80\">80%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 120\">120%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 180\">180%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 240\">240%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 300\">300%</a>]";
                        String exp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 35\">35%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 50\">50%</a>]";
                        String mp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 30\">30%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 40\">40%</a>]";
                        if (this.getCastle().getFunction(2) != null) {
                            html.replace((CharSequence)"%hp_recovery%", this.getCastle().getFunction(2).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getCastle().getFunction(2).getLease() + "</font>Adena /" + Config.CS_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%hp_period%", "Withdraw the fee for the next time at " + format.format(this.getCastle().getFunction(2).getEndTime()));
                            html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp);
                        } else {
                            html.replace((CharSequence)"%hp_recovery%", "none");
                            html.replace((CharSequence)"%hp_period%", "none");
                            html.replace((CharSequence)"%change_hp%", hp);
                        }
                        if (this.getCastle().getFunction(4) != null) {
                            html.replace((CharSequence)"%exp_recovery%", this.getCastle().getFunction(4).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getCastle().getFunction(4).getLease() + "</font>Adena /" + Config.CS_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%exp_period%", "Withdraw the fee for the next time at " + format.format(this.getCastle().getFunction(4).getEndTime()));
                            html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp);
                        } else {
                            html.replace((CharSequence)"%exp_recovery%", "none");
                            html.replace((CharSequence)"%exp_period%", "none");
                            html.replace((CharSequence)"%change_exp%", exp);
                        }
                        if (this.getCastle().getFunction(3) != null) {
                            html.replace((CharSequence)"%mp_recovery%", this.getCastle().getFunction(3).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getCastle().getFunction(3).getLease() + "</font>Adena /" + Config.CS_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%mp_period%", "Withdraw the fee for the next time at " + format.format(this.getCastle().getFunction(3).getEndTime()));
                            html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp);
                        } else {
                            html.replace((CharSequence)"%mp_recovery%", "none");
                            html.replace((CharSequence)"%mp_period%", "none");
                            html.replace((CharSequence)"%change_mp%", mp);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("other")) {
                        if (st.countTokens() >= 1) {
                            if (this.getCastle().getOwnerId() == 0) {
                                player.sendMessage("This castle have no owner, you cannot change configuration");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("tele_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other tele 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("support_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other support 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_support")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Insignia (Supplementary Magic)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CS_SUPPORT1_FEE;
                                        break;
                                    }
                                    case 2: {
                                        cost = Config.CS_SUPPORT2_FEE;
                                        break;
                                    }
                                    case 3: {
                                        cost = Config.CS_SUPPORT3_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CS_SUPPORT4_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.CS_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Enables the use of supplementary magic.");
                                html.replace((CharSequence)"%apply%", "other support " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_tele")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Mirror (Teleportation Device)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CS_TELE1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CS_TELE2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.CS_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Teleports clan members in a castle to the target <font color=\"00FFFF\">Stage " + stage + "</font> staging area");
                                html.replace((CharSequence)"%apply%", "other tele " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("tele")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Tele editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply_confirmed.htm");
                                    if (this.getCastle().getFunction(1) != null && this.getCastle().getFunction(1).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-used.htm");
                                        html.replace((CharSequence)"%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CS_TELE1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CS_TELE2_FEE;
                                        }
                                    }
                                    if (!this.getCastle().updateFunctions(player, 1, lvl, fee, Config.CS_TELE_FEE_RATIO, this.getCastle().getFunction(1) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("support")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Support editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-apply_confirmed.htm");
                                    if (this.getCastle().getFunction(5) != null && this.getCastle().getFunction(5).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-used.htm");
                                        html.replace((CharSequence)"%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CS_SUPPORT1_FEE;
                                            break;
                                        }
                                        case 2: {
                                            fee = Config.CS_SUPPORT2_FEE;
                                            break;
                                        }
                                        case 3: {
                                            fee = Config.CS_SUPPORT3_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CS_SUPPORT4_FEE;
                                        }
                                    }
                                    if (!this.getCastle().updateFunctions(player, 5, lvl, fee, Config.CS_SUPPORT_FEE_RATIO, this.getCastle().getFunction(5) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.sendHtmlMessage(player, html);
                                    }
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/edit_other.htm");
                        String tele = "[<a action=\"bypass -h npc_%objectId%_manage other edit_tele 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_tele 2\">Level 2</a>]";
                        String support = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">Level 2</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 3\">Level 3</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 4\">Level 4</a>]";
                        if (this.getCastle().getFunction(1) != null) {
                            html.replace((CharSequence)"%tele%", "Stage " + this.getCastle().getFunction(1).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getCastle().getFunction(1).getLease() + "</font>Adena /" + Config.CS_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%tele_period%", "Withdraw the fee for the next time at " + format.format(this.getCastle().getFunction(1).getEndTime()));
                            html.replace((CharSequence)"%change_tele%", "[<a action=\"bypass -h npc_%objectId%_manage other tele_cancel\">Deactivate</a>]" + tele);
                        } else {
                            html.replace((CharSequence)"%tele%", "none");
                            html.replace((CharSequence)"%tele_period%", "none");
                            html.replace((CharSequence)"%change_tele%", tele);
                        }
                        if (this.getCastle().getFunction(5) != null) {
                            html.replace((CharSequence)"%support%", "Stage " + this.getCastle().getFunction(5).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getCastle().getFunction(5).getLease() + "</font>Adena /" + Config.CS_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%support_period%", "Withdraw the fee for the next time at " + format.format(this.getCastle().getFunction(5).getEndTime()));
                            html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support);
                        } else {
                            html.replace((CharSequence)"%support%", "none");
                            html.replace((CharSequence)"%support_period%", "none");
                            html.replace((CharSequence)"%change_support%", support);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("back")) {
                        this.showChatWindow(player);
                    } else {
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/manage.htm");
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support")) {
                this.setTarget(player);
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int skill_id = Integer.parseInt(val);
                    try {
                        L2Skill skill;
                        if (this.getCastle().getFunction(5) == null) {
                            return;
                        }
                        if (this.getCastle().getFunction(5).getLvl() == 0) {
                            return;
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        int skill_lvl = 0;
                        if (st.countTokens() >= 1) {
                            skill_lvl = Integer.parseInt(st.nextToken());
                        }
                        if ((skill = SkillTable.getInstance().getInfo(skill_id, skill_lvl)).getSkillType() == L2SkillType.SUMMON) {
                            player.doSimultaneousCast(skill);
                        } else if (!((double)(skill.getMpConsume() + skill.getMpInitialConsume()) > this.getCurrentMp())) {
                            this.doCast(skill);
                        } else {
                            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/support-no_mana.htm");
                            html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                            this.sendHtmlMessage(player, html);
                            return;
                        }
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/support-done.htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                        this.sendHtmlMessage(player, html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid skill level, contact your admin!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid skill level, contact your admin!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                if (this.getCastle().getFunction(5).getLvl() == 0) {
                    return;
                }
                html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/support" + this.getCastle().getFunction(5).getLvl() + ".htm");
                html.replace((CharSequence)"%mp%", (int)this.getStatus().getCurrentMp());
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("goto")) {
                int whereTo = Integer.parseInt(val);
                this.doTeleport(player, whereTo);
                return;
            }
            if (actualCommand.equalsIgnoreCase("siege_change")) {
                if (Config.CL_SET_SIEGE_TIME_LIST.isEmpty()) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noadmin.htm");
                    this.sendHtmlMessage(player, html);
                } else if (player.isClanLeader()) {
                    if (this.getCastle().getSiege().getTimeRegistrationOverDate().getTimeInMillis() < Calendar.getInstance().getTimeInMillis()) {
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/siegetime1.htm");
                        this.sendHtmlMessage(player, html);
                    } else if (this.getCastle().getSiege().getIsTimeRegistrationOver()) {
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/siegetime2.htm");
                        this.sendHtmlMessage(player, html);
                    } else {
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/siegetime3.htm");
                        html.replace((CharSequence)"%time%", Util.dateFormat(this.getCastle().getSiegeDate().getTime()));
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("siege_time_set")) {
                boolean isAfternoon = Config.SIEGE_HOUR_LIST_MORNING.isEmpty();
                switch (Integer.parseInt(val)) {
                    case 0: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this._preDay = Integer.parseInt(st.nextToken());
                        break;
                    }
                    case 2: {
                        isAfternoon = Boolean.parseBoolean(st.nextToken());
                        break;
                    }
                    case 3: {
                        this._preHour = Integer.parseInt(st.nextToken());
                        break;
                    }
                }
                NpcHtmlMessage html = this.getNextSiegeTimePage(player.getHtmlPrefix(), Integer.parseInt(val), isAfternoon);
                if (html == null) {
                    if (Config.CL_SET_SIEGE_TIME_LIST.contains("day")) {
                        this.getCastle().getSiegeDate().set(7, this._preDay);
                    } else {
                        this.getCastle().getSiegeDate().set(7, 1);
                    }
                    if (Config.CL_SET_SIEGE_TIME_LIST.contains("hour")) {
                        this.getCastle().getSiegeDate().set(11, this._preHour);
                    }
                    if (Config.CL_SET_SIEGE_TIME_LIST.contains("minute")) {
                        this.getCastle().getSiegeDate().set(12, Integer.parseInt(st.nextToken()));
                    }
                    this.getCastle().getSiege().endTimeRegistration(false);
                    html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/siegetime8.htm");
                    html.replace((CharSequence)"%time%", Util.dateFormat(this.getCastle().getSiegeDate().getTime()));
                }
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equals("give_crown")) {
                if (this.siegeBlocksFunction(player)) {
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.isClanLeader()) {
                    if (player.getInventory().getItemByItemId(6841) == null) {
                        L2ItemInstance crown = player.getInventory().addItem("Castle Crown", 6841, 1L, player, this);
                        SystemMessage ms = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                        ms.addItemName(crown);
                        player.sendPacket(ms);
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-gavecrown.htm");
                        html.replace((CharSequence)"%CharName%", player.getName());
                        html.replace((CharSequence)"%FeudName%", this.getCastle().getName());
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-hascrown.htm");
                    }
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
                }
                player.sendPacket(html);
                return;
            }
            super.onBypassFeedback(player, command);
        }
    }

    private NpcHtmlMessage getNextSiegeTimePage(String htmlPrefix, int now, boolean isAfternoon) {
        NpcHtmlMessage ret = new NpcHtmlMessage(1);
        if (now == 0 && Config.CL_SET_SIEGE_TIME_LIST.contains("day")) {
            ret.setFile(htmlPrefix, "data/html/chamberlain/siegetime4.htm");
            return ret;
        }
        if (now < 3 && Config.CL_SET_SIEGE_TIME_LIST.contains("hour")) {
            switch (now) {
                case 0: 
                case 1: {
                    if (!Config.SIEGE_HOUR_LIST_MORNING.isEmpty() && !Config.SIEGE_HOUR_LIST_AFTERNOON.isEmpty()) {
                        ret.setFile(htmlPrefix, "data/html/chamberlain/siegetime5.htm");
                        return ret;
                    }
                }
                case 2: {
                    List<Integer> list;
                    ret.setFile(htmlPrefix, "data/html/chamberlain/siegetime6.htm");
                    int inc = 0;
                    String ampm = "";
                    if (!isAfternoon) {
                        if (Config.SIEGE_HOUR_LIST_AFTERNOON.isEmpty()) {
                            ampm = "AM";
                        }
                        list = Config.SIEGE_HOUR_LIST_MORNING;
                    } else {
                        if (Config.SIEGE_HOUR_LIST_MORNING.isEmpty()) {
                            ampm = "PM";
                        }
                        inc = 12;
                        list = Config.SIEGE_HOUR_LIST_AFTERNOON;
                    }
                    StringBuilder tList = new StringBuilder(list.size() * 50);
                    for (Integer hour : list) {
                        if (hour == 0) {
                            StringUtil.append(tList, "<a action=\"bypass -h npc_%objectId%_siege_time_set 3 ", String.valueOf(hour + inc), "\">", String.valueOf(hour + 12), ":00 ", ampm, "</a><br>");
                            continue;
                        }
                        StringUtil.append(tList, "<a action=\"bypass -h npc_%objectId%_siege_time_set 3 ", String.valueOf(hour + inc), "\">", String.valueOf(hour), ":00 ", ampm, "</a><br>");
                    }
                    ret.replace((CharSequence)"%links%", tList.toString());
                }
            }
            return ret;
        }
        if (now < 4 && Config.CL_SET_SIEGE_TIME_LIST.contains("minute")) {
            ret.setFile(htmlPrefix, "data/html/chamberlain/siegetime7.htm");
            return ret;
        }
        return null;
    }

    private void sendHtmlMessage(L2PcInstance player, String htmlMessage) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setHtml(htmlMessage);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/chamberlain/", npcId, val);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/chamberlain/chamberlain-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/chamberlain/chamberlain-busy.htm";
            } else if (condition == 2) {
                filename = "data/html/chamberlain/chamberlain.htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list;
        if (Config.DEBUG) {
            _log.warning("doTeleport(L2PcInstance player, int val) is called");
        }
        if ((list = TeleportLocationTable.getInstance().getTemplate(val)) != null) {
            if (player.destroyItemByItemId("Teleport", list.getItemId(), list.getPrice(), this, true)) {
                if (Config.DEBUG) {
                    _log.warning("Teleporting player " + player.getName() + " for Castle to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ());
            }
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected int validateCondition(L2PcInstance player) {
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getZone().isActive()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }

    private boolean validatePrivileges(L2PcInstance player, int privilege) {
        if ((player.getClanPrivileges() & privilege) != privilege) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-noprivs.htm");
            player.sendPacket(html);
            return false;
        }
        return true;
    }

    private boolean siegeBlocksFunction(L2PcInstance player) {
        if (this.getCastle().getSiege().getIsInProgress()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/chamberlain/chamberlain-busy.htm");
            html.replace((CharSequence)"%npcname%", this.getName());
            player.sendPacket(html);
            return true;
        }
        return false;
    }
}

