/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Point3D;
import java.util.logging.Logger;

public final class RequestExMagicSkillUseGround
extends L2GameClientPacket {
    private static final String _C__D0_2F_REQUESTEXMAGICSKILLUSEGROUND = "[C] D0:2F RequestExMagicSkillUseGround";
    private static Logger _log = Logger.getLogger(RequestExMagicSkillUseGround.class.getName());
    private int _x;
    private int _y;
    private int _z;
    private int _skillId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
        this._skillId = this.readD();
        this._ctrlPressed = this.readD() != 0;
        this._shiftPressed = this.readC() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int level = activeChar.getSkillLevel(this._skillId);
        if (level <= 0) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._skillId, level);
        if (skill != null) {
            activeChar.setCurrentSkillWorldPosition(new Point3D(this._x, this._y, this._z));
            activeChar.setHeading(Util.calculateHeadingFrom(activeChar.getX(), activeChar.getY(), this._x, this._y));
            activeChar.broadcastPacket(new ValidateLocation(activeChar));
            activeChar.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        } else {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            _log.warning("No skill found with id " + this._skillId + " and level " + level + " !!");
        }
    }

    @Override
    public String getType() {
        return _C__D0_2F_REQUESTEXMAGICSKILLUSEGROUND;
    }
}

