/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.epic.core.util.PerlExecutor;
import org.epic.core.util.XMLUtilities;

public class PerlProject
extends PlatformObject {
    private final IProject project;

    PerlProject(IProject project) {
        this.project = project;
    }

    public List getEffectiveIncPath() throws CoreException {
        PerlExecutor executor = new PerlExecutor();
        try {
            List lines = executor.execute(this, Collections.EMPTY_LIST, "foreach $i(@INC) { print \"$i\n\"; }\n").getStdoutLines();
            List list = this.makeAbsIncPath(lines.toArray(new String[lines.size()]));
            return list;
        }
        finally {
            executor.dispose();
        }
    }

    public List getIncPath() {
        XMLUtilities xmlUtil = new XMLUtilities();
        return this.makeAbsIncPath(xmlUtil.getIncludeEntries(this.project, true));
    }

    public List getRawIncPath() {
        XMLUtilities xmlUtil = new XMLUtilities();
        return Arrays.asList(xmlUtil.getIncludeEntries(this.project, true));
    }

    public IProject getProject() {
        return this.project;
    }

    public File getProjectDir() {
        return this.project.getFile((IPath)new Path("x")).getRawLocation().toFile().getParentFile();
    }

    private List makeAbsIncPath(String[] relIncPath) {
        ArrayList<File> dirs = new ArrayList<File>();
        File projectDir = this.getProjectDir();
        int i = 0;
        while (i < relIncPath.length) {
            File f = new File(relIncPath[i]);
            if (!f.isAbsolute()) {
                f = new File(projectDir, relIncPath[i]);
            }
            dirs.add(f);
            ++i;
        }
        return Collections.unmodifiableList(dirs);
    }
}

