/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.templates.ui.LinkedPositionListener;
import org.epic.perleditor.templates.ui.LinkedPositionManager;
import org.epic.perleditor.templates.ui.LinkedPositionMessages;

public class LinkedPositionUI
implements LinkedPositionListener,
ITextInputListener,
ITextListener,
ModifyListener,
VerifyListener,
VerifyKeyListener,
PaintListener,
IPropertyChangeListener,
ShellListener {
    private static final int UNINSTALL = 1;
    public static final int COMMIT = 2;
    private static final int DOCUMENT_CHANGED = 4;
    public static final int UPDATE_CARET = 8;
    private static final String CARET_POSITION = "LinkedPositionUI.caret.position";
    private static final IPositionUpdater fgUpdater = new DefaultPositionUpdater("LinkedPositionUI.caret.position");
    private static final IPreferenceStore fgStore = PerlEditorPlugin.getDefault().getPreferenceStore();
    private final ITextViewer fViewer;
    private final LinkedPositionManager fManager;
    private Color fFrameColor;
    private int fFinalCaretOffset = -1;
    private Position fFramePosition;
    private int fInitialOffset = -1;
    private int fCaretOffset;
    private ExitPolicy fExitPolicy;
    private ExitListener fExitListener;
    private boolean fNeedRedraw;
    private String fContentType;

    public LinkedPositionUI(ITextViewer viewer, LinkedPositionManager manager) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)manager);
        this.fViewer = viewer;
        this.fManager = manager;
        this.fManager.setLinkedPositionListener(this);
        this.initializeHighlightColor(viewer);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("linkedPositionColor")) {
            this.initializeHighlightColor(this.fViewer);
            this.redrawRegion();
        }
    }

    private void initializeHighlightColor(ITextViewer viewer) {
        StyledText text;
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
        }
        if ((text = viewer.getTextWidget()) != null) {
            Display display = text.getDisplay();
            this.fFrameColor = this.createColor(fgStore, "linkedPositionColor", display);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void setInitialOffset(int offset) {
        this.fInitialOffset = offset;
    }

    public void setFinalCaretOffset(int offset) {
        this.fFinalCaretOffset = offset;
    }

    public void setCancelListener(ExitListener listener) {
        this.fExitListener = listener;
    }

    public void setExitPolicy(ExitPolicy policy) {
        this.fExitPolicy = policy;
    }

    @Override
    public void setCurrentPosition(Position position, int caretOffset) {
        if (!this.fFramePosition.equals((Object)position)) {
            this.fNeedRedraw = true;
            this.fFramePosition = position;
        }
        this.fCaretOffset = caretOffset;
    }

    public void enter() {
        IDocument document = this.fViewer.getDocument();
        document.addPositionCategory(CARET_POSITION);
        document.addPositionUpdater(fgUpdater);
        try {
            if (this.fFinalCaretOffset != -1) {
                document.addPosition(CARET_POSITION, new Position(this.fFinalCaretOffset));
            }
        }
        catch (BadLocationException e) {
            LinkedPositionUI.handleException(this.fViewer.getTextWidget().getShell(), (Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
            Assert.isTrue((boolean)false);
        }
        this.fViewer.addTextInputListener((ITextInputListener)this);
        this.fViewer.addTextListener((ITextListener)this);
        ITextViewerExtension extension = (ITextViewerExtension)this.fViewer;
        extension.prependVerifyKeyListener((VerifyKeyListener)this);
        StyledText text = this.fViewer.getTextWidget();
        text.addVerifyListener((VerifyListener)this);
        text.addModifyListener((ModifyListener)this);
        text.addPaintListener((PaintListener)this);
        text.showSelection();
        Shell shell = text.getShell();
        shell.addShellListener((ShellListener)this);
        Position position = this.fFramePosition = this.fInitialOffset == -1 ? this.fManager.getFirstPosition() : this.fManager.getPosition(this.fInitialOffset);
        if (this.fFramePosition == null) {
            this.leave(11);
            return;
        }
        fgStore.addPropertyChangeListener((IPropertyChangeListener)this);
        try {
            this.fContentType = PartitionTypes.getPerlPartition(document, this.fFramePosition.offset).getType();
            if (this.fViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)this.fViewer).prependAutoEditStrategy((IAutoEditStrategy)this.fManager, this.fContentType);
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        catch (BadLocationException e) {
            LinkedPositionUI.handleException(this.fViewer.getTextWidget().getShell(), (Exception)((Object)e));
        }
    }

    @Override
    public void exit(boolean success) {
        this.leave((success ? 2 : 0) | 8);
    }

    public IRegion getSelectedRegion() {
        if (this.fFramePosition == null) {
            return new Region(this.fFinalCaretOffset, 0);
        }
        return new Region(this.fFramePosition.getOffset(), this.fFramePosition.getLength());
    }

    private void leave(int flags) {
        this.fInitialOffset = -1;
        if ((flags & 1) != 0) {
            this.fManager.uninstall((flags & 2) != 0);
        }
        fgStore.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
            this.fFrameColor = null;
        }
        StyledText text = this.fViewer.getTextWidget();
        text.removePaintListener((PaintListener)this);
        text.removeModifyListener((ModifyListener)this);
        text.removeVerifyListener((VerifyListener)this);
        Shell shell = text.getShell();
        shell.removeShellListener((ShellListener)this);
        ITextViewerExtension extension = (ITextViewerExtension)this.fViewer;
        extension.removeVerifyKeyListener((VerifyKeyListener)this);
        if (this.fViewer instanceof ITextViewerExtension2 && this.fContentType != null) {
            ((ITextViewerExtension2)this.fViewer).removeAutoEditStrategy((IAutoEditStrategy)this.fManager, this.fContentType);
        }
        this.fContentType = null;
        this.fViewer.removeTextListener((ITextListener)this);
        this.fViewer.removeTextInputListener((ITextInputListener)this);
        try {
            Position[] positions;
            IDocument document = this.fViewer.getDocument();
            if ((flags & 2) != 0 && (flags & 4) == 0 && (flags & 8) != 0 && (positions = document.getPositions(CARET_POSITION)) != null && positions.length != 0) {
                if (this.fViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension3 = (ITextViewerExtension5)this.fViewer;
                    int widgetOffset = extension3.modelOffset2WidgetOffset(positions[0].getOffset());
                    if (widgetOffset >= 0) {
                        text.setSelection(widgetOffset, widgetOffset);
                    }
                } else {
                    IRegion region = this.fViewer.getVisibleRegion();
                    int offset = positions[0].getOffset() - region.getOffset();
                    if (offset >= 0 && offset <= region.getLength()) {
                        text.setSelection(offset, offset);
                    }
                }
            }
            document.removePositionUpdater(fgUpdater);
            document.removePositionCategory(CARET_POSITION);
            if (this.fExitListener != null) {
                this.fExitListener.exit((flags & 2) != 0 || (flags & 4) != 0);
            }
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
            Assert.isTrue((boolean)false);
        }
        if ((flags & 4) == 0) {
            text.redraw();
        }
    }

    private void next() {
        this.redrawRegion();
        this.fFramePosition = this.fManager.getNextPosition(this.fFramePosition.getOffset());
        if (this.fFramePosition == null) {
            this.leave(11);
        } else {
            this.selectRegion();
            this.redrawRegion();
        }
    }

    private void previous() {
        this.redrawRegion();
        Position position = this.fManager.getPreviousPosition(this.fFramePosition.getOffset());
        if (position == null) {
            this.fViewer.getTextWidget().getDisplay().beep();
        } else {
            this.fFramePosition = position;
            this.selectRegion();
            this.redrawRegion();
        }
    }

    public void verifyKey(VerifyEvent event) {
        ExitFlags exitFlags;
        if (!event.doit) {
            return;
        }
        Point selection = this.fViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        ExitFlags exitFlags2 = exitFlags = this.fExitPolicy == null ? null : this.fExitPolicy.doExit(this.fManager, event, offset, length);
        if (exitFlags != null) {
            this.leave(1 | exitFlags.flags);
            event.doit = exitFlags.doit;
            return;
        }
        switch (event.character) {
            case '\t': {
                if (!LinkedPositionManager.includes(this.fFramePosition, offset, length)) {
                    this.leave(3);
                    return;
                }
                if (event.stateMask == 131072) {
                    this.previous();
                } else {
                    this.next();
                }
                event.doit = false;
                break;
            }
            case '\r': {
                this.leave(11);
                event.doit = false;
                break;
            }
            case '\u001b': {
                this.leave(3);
                event.doit = false;
            }
        }
    }

    public void verifyText(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            IRegion modelRange = extension.widgetRange2ModelRange((IRegion)new Region(event.start, event.end - event.start));
            if (modelRange == null) {
                return;
            }
            offset = modelRange.getOffset();
            length = modelRange.getLength();
        } else {
            IRegion visibleRegion = this.fViewer.getVisibleRegion();
            offset = event.start + visibleRegion.getOffset();
            length = event.end - event.start;
        }
        if (!this.fManager.anyPositionIncludes(offset, length)) {
            this.leave(3);
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.fFramePosition == null) {
            return;
        }
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            this.leave(7);
            return;
        }
        int offset = widgetRange.getOffset();
        int length = widgetRange.getLength();
        StyledText text = this.fViewer.getTextWidget();
        Point minLocation = LinkedPositionUI.getMinimumLocation(text, offset, length);
        Point maxLocation = LinkedPositionUI.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        gc.setForeground(this.fFrameColor);
        gc.drawLine(x1, y, x2, y);
    }

    protected IRegion asWidgetRange(Position position) {
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            return extension.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()));
        }
        IRegion region = this.fViewer.getVisibleRegion();
        if (LinkedPositionUI.includes(region, position)) {
            return new Region(position.getOffset() - region.getOffset(), position.getLength());
        }
        return null;
    }

    private static Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private static Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    private void redrawRegion() {
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            this.leave(7);
            return;
        }
        StyledText text = this.fViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.redrawRange(widgetRange.getOffset(), widgetRange.getLength(), true);
        }
    }

    private void selectRegion() {
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            this.leave(7);
            return;
        }
        StyledText text = this.fViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            int start = widgetRange.getOffset();
            int end = widgetRange.getLength() + start;
            text.setSelection(start, end);
        }
    }

    private void updateCaret() {
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            this.leave(7);
            return;
        }
        int offset = widgetRange.getOffset() + this.fCaretOffset;
        StyledText text = this.fViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCaretOffset(offset);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.redrawRegion();
        this.updateCaret();
    }

    private static void handleException(Shell shell, Exception e) {
        String title = LinkedPositionMessages.getString("LinkedPositionUI.error.title");
        MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        e.printStackTrace();
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        int flags = 3 | (oldInput.equals(newInput) ? 0 : 4);
        this.leave(flags);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
    }

    private static boolean includes(IRegion region, Position position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    public void textChanged(TextEvent event) {
        if (!this.fNeedRedraw) {
            return;
        }
        this.redrawRegion();
        this.fNeedRedraw = false;
    }

    public void shellActivated(ShellEvent event) {
    }

    public void shellClosed(ShellEvent event) {
        this.leave(7);
    }

    public void shellDeactivated(ShellEvent event) {
        this.leave(7);
    }

    public void shellDeiconified(ShellEvent event) {
    }

    public void shellIconified(ShellEvent event) {
        this.leave(7);
    }

    public static class ExitFlags {
        public int flags;
        public boolean doit;

        public ExitFlags(int flags, boolean doit) {
            this.flags = flags;
            this.doit = doit;
        }
    }

    public static interface ExitListener {
        public void exit(boolean var1);
    }

    public static interface ExitPolicy {
        public ExitFlags doExit(LinkedPositionManager var1, VerifyEvent var2, int var3, int var4);
    }
}

