/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.preference.Messages;

public class SQLFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    public static final String P_USE_FORMATTER_TYPE = "SQLFormatPreferencePage.UseFormatterType";
    public static final String P_FORMAT_PATCH = "SQLEditorPreferencePage.FormatPatch";
    public static final String P_FORMAT_OPTION_TABSIZE = "SQLEditorPreferencePage.FormatTabSize";
    public static final String P_FORMAT_OPTION_DECODE = "SQLEditorPreferencePage.FormatOptionDecode";
    public static final String P_FORMAT_OPTION_IN = "SQLEditorPreferencePage.FormatOptionIn";
    public static final String P_MAX_SQL_COUNT = "SQLEditorPreferencePage.MaxSqlCount";
    public static final int TYPE_DBVIEWER = 0;
    public static final int TYPE_BLANCO = 1;
    private Button formatterTypeBlanco;
    private Button formatterTypeKry;
    private Button formatterPatchForBlanco;
    private Label label;
    private Text maxText = null;
    private Button tabSize2;
    private Button tabSize4;
    private Button specialFormatDecode;
    private Button specialFormatIn;

    public void init(IWorkbench workbench) {
    }

    public SQLFormatPreferencePage() {
        super.setPreferenceStore(DbPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(1808));
        this.addCommon(base);
        this.addTypeOption(base);
        this.addOption3(base);
        this.addOption4(base);
        this.updateCurrentSetting();
        return parent;
    }

    private void addCommon(Composite parent) {
        Group group = new Group(parent, 0);
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        group.setLayout((Layout)layout);
        group.setText("Common Option");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite grp = new Composite((Composite)group, 0);
        grp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(grp, 0);
        label.setText("Format Max SQL:");
        this.maxText = new Text(grp, 2048);
        this.maxText.setTextLimit(5);
        this.maxText.addModifyListener((ModifyListener)this);
        gd = new GridData();
        gd.widthHint = 100;
        this.maxText.setLayoutData((Object)gd);
    }

    private void addTypeOption(Composite parent) {
        Group group = new Group(parent, 0);
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("SQLFormatPreferencePage.2"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite grp = new Composite((Composite)group, 0);
        grp.setLayout((Layout)new GridLayout(2, false));
        this.formatterTypeKry = new Button(grp, 16);
        this.formatterTypeKry.setText(Messages.getString("SQLFormatPreferencePage.0"));
        this.formatterTypeKry.setSelection(true);
        this.formatterTypeKry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFormatPreferencePage.this.setEnableForDBV(true);
                SQLFormatPreferencePage.this.setEnableForBlanco(false);
            }
        });
        this.formatterTypeBlanco = new Button(grp, 16);
        this.formatterTypeBlanco.setText(Messages.getString("SQLFormatPreferencePage.1"));
        this.formatterTypeBlanco.setSelection(false);
        this.formatterTypeBlanco.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFormatPreferencePage.this.setEnableForDBV(false);
                SQLFormatPreferencePage.this.setEnableForBlanco(true);
            }
        });
    }

    private void addOption3(Composite parent) {
        Group group = new Group(parent, 0);
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        group.setLayout((Layout)layout);
        group.setText("BlancoFormatter Option");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite grp = new Composite((Composite)group, 0);
        grp.setLayout((Layout)new GridLayout(1, false));
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("SQLEditorPreferencePage.36"));
        this.formatterPatchForBlanco = new Button(grp, 32);
        this.formatterPatchForBlanco.setText(sb.toString());
        this.formatterPatchForBlanco.setEnabled(false);
        this.formatterPatchForBlanco.setLayoutData((Object)new GridData(3));
        this.label = new Label(grp, 0);
        this.label.setText(Messages.getString("SQLEditorPreferencePage.35"));
        this.label.setEnabled(false);
        this.label.setLayoutData((Object)new GridData(3));
    }

    private void addOption4(Composite parent) {
        Group group = new Group(parent, 0);
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        group.setLayout((Layout)layout);
        group.setText("DBViewer SQL Formatter Option");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite grp = new Composite((Composite)group, 0);
        grp.setLayout((Layout)new GridLayout(2, false));
        this.tabSize2 = new Button(grp, 16);
        this.tabSize2.setText(Messages.getString("SQLFormatPreferencePage.3"));
        this.tabSize2.setLayoutData((Object)new GridData(768));
        this.tabSize4 = new Button(grp, 16);
        this.tabSize4.setText(Messages.getString("SQLFormatPreferencePage.4"));
        this.tabSize4.setLayoutData((Object)new GridData(768));
        this.specialFormatDecode = new Button(grp, 32);
        this.specialFormatDecode.setText(Messages.getString("SQLFormatPreferencePage.5"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.specialFormatDecode.setLayoutData((Object)gd);
        this.specialFormatIn = new Button(grp, 32);
        this.specialFormatIn.setText(Messages.getString("SQLFormatPreferencePage.6"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.specialFormatIn.setLayoutData((Object)gd);
    }

    private void setEnableForDBV(boolean b) {
        this.tabSize2.setEnabled(b);
        this.tabSize4.setEnabled(b);
        this.specialFormatDecode.setEnabled(b);
        this.specialFormatIn.setEnabled(b);
    }

    private void setEnableForBlanco(boolean b) {
        this.formatterPatchForBlanco.setEnabled(b);
        this.label.setEnabled(b);
    }

    private void updateCurrentSetting() {
        String maxCount = this.getPreferenceStore().getString(P_MAX_SQL_COUNT);
        int type = this.getPreferenceStore().getInt(P_USE_FORMATTER_TYPE);
        boolean onPatch = this.getPreferenceStore().getBoolean(P_FORMAT_PATCH);
        int tabSize = this.getPreferenceStore().getInt(P_FORMAT_OPTION_TABSIZE);
        boolean optionDecode = this.getPreferenceStore().getBoolean(P_FORMAT_OPTION_DECODE);
        boolean optionIn = this.getPreferenceStore().getBoolean(P_FORMAT_OPTION_IN);
        this.maxText.setText(maxCount);
        switch (type) {
            case 0: {
                this.formatterTypeKry.setSelection(true);
                this.setEnableForDBV(true);
                this.formatterTypeBlanco.setSelection(false);
                this.setEnableForBlanco(false);
                break;
            }
            case 1: {
                this.formatterTypeKry.setSelection(false);
                this.setEnableForDBV(false);
                this.formatterTypeBlanco.setSelection(true);
                this.setEnableForBlanco(true);
                break;
            }
        }
        this.formatterPatchForBlanco.setSelection(onPatch);
        if (tabSize == 2) {
            this.tabSize2.setSelection(true);
            this.tabSize4.setSelection(false);
        } else {
            this.tabSize2.setSelection(false);
            this.tabSize4.setSelection(true);
        }
        this.specialFormatDecode.setSelection(optionDecode);
        this.specialFormatIn.setSelection(optionIn);
    }

    private void updateDefaultSetting() {
        String maxCount = this.getPreferenceStore().getDefaultString(P_MAX_SQL_COUNT);
        int type = this.getPreferenceStore().getDefaultInt(P_USE_FORMATTER_TYPE);
        boolean onPatch = this.getPreferenceStore().getDefaultBoolean(P_FORMAT_PATCH);
        int tabSize = this.getPreferenceStore().getDefaultInt(P_FORMAT_OPTION_TABSIZE);
        boolean optionDecode = this.getPreferenceStore().getDefaultBoolean(P_FORMAT_OPTION_DECODE);
        boolean optionIn = this.getPreferenceStore().getDefaultBoolean(P_FORMAT_OPTION_IN);
        this.maxText.setText(maxCount);
        switch (type) {
            case 0: {
                this.formatterTypeKry.setSelection(true);
                this.setEnableForDBV(true);
                this.formatterTypeBlanco.setSelection(false);
                this.setEnableForBlanco(false);
                break;
            }
            case 1: {
                this.formatterTypeKry.setSelection(false);
                this.setEnableForDBV(false);
                this.formatterTypeBlanco.setSelection(true);
                this.setEnableForBlanco(true);
                break;
            }
        }
        this.formatterPatchForBlanco.setSelection(onPatch);
        if (tabSize == 2) {
            this.tabSize2.setSelection(true);
            this.tabSize4.setSelection(false);
        } else {
            this.tabSize2.setSelection(false);
            this.tabSize4.setSelection(true);
        }
        this.specialFormatDecode.setSelection(optionDecode);
        this.specialFormatIn.setSelection(optionIn);
    }

    protected void performDefaults() {
        this.updateDefaultSetting();
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue(P_MAX_SQL_COUNT, this.maxText.getText());
        this.getPreferenceStore().setValue(P_FORMAT_PATCH, this.formatterPatchForBlanco.getSelection());
        if (this.tabSize2.getSelection()) {
            this.getPreferenceStore().setValue(P_FORMAT_OPTION_TABSIZE, 2);
        } else {
            this.getPreferenceStore().setValue(P_FORMAT_OPTION_TABSIZE, 4);
        }
        this.getPreferenceStore().setValue(P_FORMAT_OPTION_DECODE, this.specialFormatDecode.getSelection());
        this.getPreferenceStore().setValue(P_FORMAT_OPTION_IN, this.specialFormatIn.getSelection());
        if (this.formatterTypeKry.getSelection()) {
            this.getPreferenceStore().setValue(P_USE_FORMATTER_TYPE, 0);
        } else {
            this.getPreferenceStore().setValue(P_USE_FORMATTER_TYPE, 1);
        }
        return super.performOk();
    }

    public void modifyText(ModifyEvent e) {
        if (!StringUtil.isNumeric(this.maxText.getText())) {
            this.updateStatus(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
            return;
        }
        if (this.maxText.getText().length() == 0) {
            this.updateStatus(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
            return;
        }
        this.updateStatus(null);
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setValid(message == null);
    }
}

