/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.preference;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.Messages;
import zigen.plugin.db.preference.SQLTemplateEditorUI;
import zigen.plugin.db.ui.contentassist.SQLTemplateFormatter;

public class SQLTemplatesPreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    public static final String DESC = Messages.getString("SQLTemplatesPreferencePage.0");
    public static final String TEMPLATES_USE_CODEFORMATTER = "org.eclipse.ui.texteditor.templates.preferences.format_templates";
    IPreferenceStore ps = DbPlugin.getDefault().getPreferenceStore();

    public SQLTemplatesPreferencePage() {
        this.setPreferenceStore(SQLTemplateEditorUI.getDefault().getPreferenceStore());
        this.setTemplateStore(SQLTemplateEditorUI.getDefault().getTemplateStore());
        this.setContextTypeRegistry(SQLTemplateEditorUI.getDefault().getContextTypeRegistry());
        super.setDescription(DESC);
        super.setTitle(Messages.getString("SQLTemplatesPreferencePage.1"));
    }

    protected boolean isShowFormatterSetting() {
        return true;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        SQLTemplateEditorUI.getDefault().savePluginPreferences();
        return ok;
    }

    protected void updateViewerInput() {
        boolean useCodeFormatter = this.ps.getBoolean(TEMPLATES_USE_CODEFORMATTER);
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer sv = this.getViewer();
        if (selection.size() == 1) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            if (useCodeFormatter) {
                SQLTemplateFormatter formatter = new SQLTemplateFormatter(sv.getDocument(), 0);
                sv.getDocument().set(formatter.format(template.getPattern()));
            } else {
                sv.getDocument().set(template.getPattern());
            }
        } else {
            sv.getDocument().set("");
        }
    }
}

