/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SQLFormattingStrategy
implements IFormattingStrategy {
    int maxfomatCnt = 10;
    SQLSourceViewer viewer;
    IPreferenceStore ps = DbPlugin.getDefault().getPreferenceStore();

    public SQLFormattingStrategy(ISourceViewer sourceViewer) {
        if (sourceViewer instanceof SQLSourceViewer) {
            this.viewer = (SQLSourceViewer)sourceViewer;
        }
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        if (this.viewer != null) {
            IDocument doc = this.viewer.getDocument();
            TextSelection ts = (TextSelection)this.viewer.getSelection();
            int firstPosition = this.calcFirstWordPosition(doc, ts);
            boolean selectionMode = ts.getText().length() > 0;
            return this.innerformat(content, selectionMode, firstPosition);
        }
        return content;
    }

    void setSelection(ISourceViewer viewer, ISelection selection, boolean reveal) {
        if (selection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)selection;
            viewer.setSelectedRange(s.getOffset(), s.getLength());
            if (reveal) {
                viewer.revealRange(s.getOffset(), s.getLength());
            }
        }
    }

    private int calcFirstWordPosition(IDocument doc, TextSelection selection) {
        int formattOffset = 0;
        try {
            if (selection.getText().length() > 0) {
                int sOffset = doc.getLineOffset(selection.getStartLine());
                int firstWordPosition = StringUtil.firstWordPosition(selection.getText());
                formattOffset = selection.getOffset() - sOffset + firstWordPosition;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return formattOffset;
    }

    private String innerformat(String content, boolean selectionMode, int firstPosition) {
        String demiliter = this.ps.getString("SQLEditorPreferencePage.SqlDemiliter");
        boolean onPatch = this.ps.getBoolean("SQLEditorPreferencePage.FormatPatch");
        int type = this.ps.getInt("SQLFormatPreferencePage.UseFormatterType");
        StringBuffer sb = new StringBuffer();
        SQLTokenizer st = new SQLTokenizer(content, demiliter);
        if (st.getTokenCount() <= this.maxfomatCnt) {
            while (st.hasMoreElements()) {
                String sql = (String)st.nextElement();
                if (sql == null || sql.length() <= 0) continue;
                sb.append(SQLFormatter.format(sql, type, onPatch, firstPosition));
                if (selectionMode) continue;
                if ("/".equals(demiliter)) {
                    sb.append(DbPluginConstant.LINE_SEP);
                }
                sb.append(demiliter);
                sb.append(DbPluginConstant.LINE_SEP);
            }
        } else {
            return content;
        }
        return sb.toString();
    }

    public void formatterStarts(String initialIndentation) {
    }

    public void formatterStops() {
    }
}

