/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.epic.debug.PerlDebugPlugin;

public class ProjectSelectionDialog
extends ElementListSelectionDialog {
    private static final String PERL_NATURE_ID = "org.epic.perleditor.perlnature";

    public ProjectSelectionDialog(Shell shell) {
        super(shell, (ILabelProvider)new ProjectLabelProvider());
        this.setTitle("Project Selection");
        this.setMessage("Choose a project");
        this.setElements(this.getPerlProjects());
    }

    private String[] getPerlProjects() {
        ArrayList<String> projectList = new ArrayList<String>();
        IWorkspaceRoot workspaceRoot = PerlDebugPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                if (project.isAccessible() && project.hasNature(PERL_NATURE_ID)) {
                    projectList.add(project.getName());
                }
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
            ++i;
        }
        return projectList.toArray(new String[projectList.size()]);
    }

    private static class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)PerlDebugPlugin.getDefault().toString(), (String)"icons/project_folder.gif").createImage();
        }
    }
}

