/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractCopyOrMoveResourcesOperation
extends AbstractResourcesOperation {
    protected IPath[] destinationPaths = null;
    protected IPath destination = null;
    protected boolean fCreateGroups = false;
    protected boolean fCreateLinks = false;
    protected String fRelativeToVariable = null;

    AbstractCopyOrMoveResourcesOperation(IResource[] resources, IPath[] destinationPaths, String label) {
        super(resources, label);
        if (this.resources == null || destinationPaths == null) {
            throw new IllegalArgumentException("The resource and destination paths may not be null");
        }
        if (this.resources.length != resources.length) {
            throw new IllegalArgumentException("The resource list contained descendants that cannot be moved to separate destination paths");
        }
        if (this.resources.length != destinationPaths.length) {
            throw new IllegalArgumentException("The resource and destination paths must be the same length");
        }
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i] == null) {
                throw new IllegalArgumentException("The resources array may not contain null resources");
            }
            if (destinationPaths[i] == null) {
                throw new IllegalArgumentException("The destination paths array may not contain null paths");
            }
            ++i;
        }
        this.destinationPaths = destinationPaths;
    }

    AbstractCopyOrMoveResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
        super(resources, label);
        this.destination = destinationPath;
    }

    AbstractCopyOrMoveResourcesOperation(IResource[] resources, String label) {
        super(resources, label);
    }

    protected IStatus computeMoveOrCopyStatus() {
        if (this.resources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            if (!resource.exists()) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractCopyOrMoveResourcesOperation_ResourceDoesNotExist);
            }
            if (!this.isDestinationPathValid(resource, i)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractCopyOrMoveResourcesOperation_SameNameOrLocation);
            }
            IStatus status = this.getWorkspace().validateName(this.getProposedName(resource, i), resource.getType());
            if (status.getSeverity() == 4) {
                this.markInvalid();
            }
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IPath getDestinationPath(IResource resource, int index) {
        if (this.destinationPaths != null) {
            return this.destinationPaths[index];
        }
        return this.destination.append(resource.getName());
    }

    protected void appendDescriptiveText(StringBuffer text) {
        super.appendDescriptiveText(text);
        text.append(" destination: ");
        text.append(this.destination);
        text.append(", destinationPaths: ");
        text.append(this.destinationPaths);
        text.append('\'');
    }

    protected boolean isDestinationPathValid(IResource resource, int index) {
        return !resource.getFullPath().equals((Object)this.getDestinationPath(resource, index));
    }

    protected String getProposedName(IResource resource, int index) {
        return this.getDestinationPath(resource, index).lastSegment();
    }

    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeMoveOrCopyStatus();
        }
        return status;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeRedoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeMoveOrCopyStatus();
        }
        return status;
    }

    public void setCreateVirtualFolders(boolean value) {
        this.fCreateGroups = value;
    }

    public void setCreateLinks(boolean value) {
        this.fCreateLinks = value;
    }

    public void setRelativeVariable(String value) {
        this.fRelativeToVariable = value;
    }
}

