/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.reporting;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.ISubclipseEclipseEnvironment;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.AbstractEclipseEnvironment;
import org.tigris.subversion.subclipse.tools.usage.internal.SubclipseToolsUsageActivator;
import org.tigris.subversion.subclipse.tools.usage.reporting.SubclipseComponents;

public class SubclipseEclipseEnvironment
extends AbstractEclipseEnvironment
implements ISubclipseEclipseEnvironment {
    private static final char SUBCLIPSE_COMPONENTS_DELIMITER = '-';

    public SubclipseEclipseEnvironment(String accountName, String hostName, IEclipsePreferences preferences) {
        super(accountName, hostName, preferences);
    }

    public String getKeyword() {
        Collection subclipseComponentNames = SubclipseComponents.getComponentIds(this.getBundleGroupProviders());
        return this.bundleGroupsToKeywordString(subclipseComponentNames);
    }

    protected IBundleGroupProvider[] getBundleGroupProviders() {
        return Platform.getBundleGroupProviders();
    }

    private String bundleGroupsToKeywordString(Collection subclipseComponentNames) {
        char delimiter = '-';
        StringBuffer builder = new StringBuffer();
        Iterator iter = subclipseComponentNames.iterator();
        while (iter.hasNext()) {
            String componentName = (String)iter.next();
            builder.append(componentName);
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public String getSubclipseVersion() {
        return SubclipseToolsUsageActivator.getDefault().getBundle().getHeaders().get("Bundle-Version").toString();
    }

    public boolean isLinuxDistro() {
        return this.getLinuxDistroNameAndVersion() != null;
    }
}

