/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.dialogs.MergeDialog;
import org.tigris.subversion.subclipse.ui.operations.MergeOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            int i = 0;
            while (i < resources.length) {
                MergeDialog dialog = new MergeDialog(this.getShell(), resources[i]);
                if (dialog.open() == 1) break;
                SVNUrl svnUrl1 = dialog.getFromUrl();
                SVNRevision svnRevision1 = dialog.getFromRevision();
                SVNUrl svnUrl2 = dialog.getToUrl();
                SVNRevision svnRevision2 = dialog.getToRevision();
                MergeOperation mergeOperation = new MergeOperation(this.getTargetPart(), this.getSelectedResources(), svnUrl1, svnRevision1, svnUrl2, svnRevision2);
                mergeOperation.setForce(dialog.isForce());
                mergeOperation.setIgnoreAncestry(dialog.isIgnoreAncestry());
                mergeOperation.run();
                ++i;
            }
        }
    }

    protected String getErrorTitle() {
        return Policy.bind("MergeAction.merge");
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Merge";
    }
}

