/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.subclipse.ui.wizards.WizardDialogWithPersistedLocation;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.GenerateDiffFileWizard;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class GenerateDiffFileSynchronizeOperation
extends SVNSynchronizeOperation {
    private ArrayList unaddedList;
    private IResource[] selectedResources;

    public GenerateDiffFileSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        Iterator iter = projectSyncInfos.keySet().iterator();
        IProject project = (IProject)iter.next();
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        this.run(provider, syncSet, Policy.subMonitorFor(monitor, 100));
        monitor.done();
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Object[] resources = set.getResources();
        HashMap<IResource, SVNStatusKind> statusMap = new HashMap<IResource, SVNStatusKind>();
        this.unaddedList = new ArrayList();
        int i = 0;
        while (i < resources.length) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
            SyncInfo syncInfo = set.getSyncInfo(resources[i]);
            SVNStatusKind statusKind = null;
            try {
                if (!svnResource.isManaged()) {
                    statusKind = SVNStatusKind.UNVERSIONED;
                } else {
                    switch (SyncInfo.getChange((int)syncInfo.getKind())) {
                        case 1: {
                            statusKind = SVNStatusKind.ADDED;
                            break;
                        }
                        case 2: {
                            statusKind = SVNStatusKind.DELETED;
                            break;
                        }
                        case 12: {
                            statusKind = SVNStatusKind.CONFLICTED;
                            break;
                        }
                        default: {
                            statusKind = SVNStatusKind.MODIFIED;
                        }
                    }
                }
                statusMap.put(resources[i], statusKind);
                if (!svnResource.isManaged() && !svnResource.isIgnored()) {
                    this.unaddedList.add(resources[i]);
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
            ++i;
        }
        ArrayList<IResource> dedupedList = new ArrayList<IResource>();
        Iterator iter = this.unaddedList.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (this.isDupe(resource)) continue;
            dedupedList.add(resource);
        }
        IResource[] unversionedResources = new IResource[dedupedList.size()];
        dedupedList.toArray(unversionedResources);
        GenerateDiffFileWizard wizard = new GenerateDiffFileWizard((IStructuredSelection)new StructuredSelection(resources), unversionedResources, statusMap);
        wizard.setWindowTitle(Policy.bind("GenerateSVNDiff.title"));
        wizard.setSelectedResources(this.selectedResources);
        final WizardDialogWithPersistedLocation dialog = new WizardDialogWithPersistedLocation(this.getShell(), (IWizard)wizard, "GenerateDiffFileWizard");
        dialog.setMinimumPageSize(350, 250);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private boolean isDupe(IResource resource) {
        IResource parent = resource;
        while (parent != null) {
            if (!this.unaddedList.contains(parent = parent.getParent())) continue;
            return true;
        }
        return false;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }
}

