/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.Branches;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.repository.model.SVNModelElement;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnWizardConfigureTagsPage
extends SvnWizardDialogPage {
    private ISVNLocalResource[] svnResources;
    private ISVNClientAdapter svnClient;
    private Branches branches;
    private Tags tags;
    private TreeViewer treeViewer;
    private Action deleteAction;
    private Action addTagAction;
    private Action addBranchAction;
    private Group tagGroup;
    private Label revisionLabel;
    private Text revisionText;
    private Label nameLabel;
    private Text nameText;
    private Label pathLabel;
    private Text pathText;
    private Button browseButton;
    private Button branchButton;
    private Button applyButton;
    private Button deleteButton;
    private boolean updates = false;
    private boolean tagUpdatePending = false;
    private Alias previousAlias;
    private static final int LIST_HEIGHT_HINT = 250;
    private static final int LIST_WIDTH_HINT = 450;

    public SvnWizardConfigureTagsPage(ISVNLocalResource[] svnResources) {
        super("ConfigureTagsDialog", Policy.bind("ConfigureTagsDialog.title"));
        this.svnResources = svnResources;
        this.deleteAction = new DeleteAction();
        this.deleteAction.setText(Policy.bind("ConfigureTagsDialog.delete"));
        this.addBranchAction = new AddBranchAction();
        this.addBranchAction.setText(Policy.bind("ConfigureTagsDialog.addBranch"));
        this.addTagAction = new AddTagAction();
        this.addTagAction.setText(Policy.bind("ConfigureTagsDialog.addTag"));
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
        this.applyButton = wizardDialog.createButton(parent, 2, Policy.bind("ConfigureTagsDialog.apply"), false);
        this.applyButton.setEnabled(false);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new UpdateAction().run();
            }
        });
        this.deleteButton = wizardDialog.createButton(parent, 3, Policy.bind("ConfigureTagsDialog.delete"), false);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DeleteAction().run();
            }
        });
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite urlGroup = new Composite(composite, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlGroup.setLayout((Layout)urlLayout);
        urlGroup.setLayoutData((Object)new GridData(768));
        Label urlLabel = new Label(urlGroup, 0);
        urlLabel.setText(Policy.bind("ConfigureTagsDialog.url"));
        Text urlText = new Text(urlGroup, 2048);
        GridData data = new GridData(768);
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        try {
            if (this.svnResources.length == 1) {
                urlText.setText(this.svnResources[0].getStatus().getUrlString());
            } else {
                urlText.setText(Policy.bind("SvnWizardConfigureTagsPage.0"));
            }
            this.svnClient = this.svnResources[0].getRepository().getSVNClient();
        }
        catch (SVNException sVNException) {}
        this.getBranchesAndTags();
        this.treeViewer = new TreeViewer(composite, 2818);
        this.treeViewer.setContentProvider((IContentProvider)new TagsContentProvider(this.svnResources[0].getResource()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TagsLabelProvider());
        this.treeViewer.setInput((Object)this.svnResources[0]);
        data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 450;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.tagGroup = new Group(composite, 0);
        GridLayout tagLayout = new GridLayout();
        tagLayout.numColumns = 3;
        this.tagGroup.setLayout((Layout)tagLayout);
        this.tagGroup.setLayoutData((Object)new GridData(768));
        this.revisionLabel = new Label((Composite)this.tagGroup, 0);
        this.revisionLabel.setText(Policy.bind("ConfigureTagsDialog.revision"));
        this.revisionText = new Text((Composite)this.tagGroup, 2048);
        data = new GridData();
        data.widthHint = 50;
        data.horizontalSpan = 2;
        this.revisionText.setLayoutData((Object)data);
        this.nameLabel = new Label((Composite)this.tagGroup, 0);
        this.nameLabel.setText(Policy.bind("ConfigureTagsDialog.name"));
        this.nameText = new Text((Composite)this.tagGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        data.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)data);
        this.pathLabel = new Label((Composite)this.tagGroup, 0);
        this.pathLabel.setText(Policy.bind("ConfigureTagsDialog.path"));
        this.pathText = new Text((Composite)this.tagGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        this.pathText.setLayoutData((Object)data);
        this.browseButton = new Button((Composite)this.tagGroup, 8);
        this.browseButton.setText(Policy.bind("ConfigureTagsDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(SvnWizardConfigureTagsPage.this.getShell(), SvnWizardConfigureTagsPage.this.svnResources[0].getResource());
                dialog.setIncludeBranchesAndTags(false);
                dialog.setFoldersOnly(true);
                if (dialog.open() == 1) {
                    return;
                }
                String url = dialog.getUrl();
                if (url != null) {
                    SvnWizardConfigureTagsPage.this.nameText.setText(dialog.getName());
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, url){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ String val$url;
                        {
                            this.this$1 = var1_1;
                            this.val$url = string;
                        }

                        public void run() {
                            try {
                                SVNUrl svnUrl = new SVNUrl(this.val$url);
                                ISVNInfo svnInfo = SvnWizardConfigureTagsPage.access$13(3.access$0(this.this$1)).getInfo(svnUrl);
                                SvnWizardConfigureTagsPage.access$7(3.access$0(this.this$1)).setText(svnInfo.getLastChangedRevision().toString());
                                String repositoryUrl = SvnWizardConfigureTagsPage.access$12(3.access$0(this.this$1))[0].getRepository().getUrl().toString();
                                SvnWizardConfigureTagsPage.access$9(3.access$0(this.this$1)).setText(this.val$url.substring(repositoryUrl.length()));
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)3.access$0(this.this$1).getShell(), (String)Policy.bind("ConfigureTagsDialog.title"), (String)e1.getMessage());
                            }
                        }
                    });
                }
            }

            static /* synthetic */ SvnWizardConfigureTagsPage access$0(3 var0) {
                return var0.SvnWizardConfigureTagsPage.this;
            }
        });
        this.branchButton = new Button((Composite)this.tagGroup, 32);
        this.branchButton.setText(Policy.bind("ConfigureTagsDialog.branch"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.branchButton.setLayoutData((Object)data);
        this.setTagGroupEnablement(false);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SvnWizardConfigureTagsPage.this.tagUpdatePending) {
                    if (MessageDialog.openQuestion((Shell)SvnWizardConfigureTagsPage.this.getShell(), (String)Policy.bind("ConfigureTagsDialog.title"), (String)Policy.bind("ConfigureTagsDialog.pendingUpdate"))) {
                        new UpdateAction(SvnWizardConfigureTagsPage.this.previousAlias).run();
                    }
                    SvnWizardConfigureTagsPage.this.tagUpdatePending = false;
                }
                SvnWizardConfigureTagsPage.this.applyButton.setEnabled(false);
                IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
                boolean deleteEnabled = false;
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof Alias)) continue;
                    deleteEnabled = true;
                    break;
                }
                SvnWizardConfigureTagsPage.this.deleteButton.setEnabled(deleteEnabled);
                if (selection.size() == 1 && selection.getFirstElement() instanceof Alias) {
                    Alias alias = (Alias)selection.getFirstElement();
                    SvnWizardConfigureTagsPage.this.previousAlias = alias;
                    if (alias.isBranch()) {
                        SvnWizardConfigureTagsPage.this.tagGroup.setText(Policy.bind("ConfigureTagsDialog.branchHeader"));
                        SvnWizardConfigureTagsPage.this.branchButton.setSelection(true);
                    } else {
                        SvnWizardConfigureTagsPage.this.tagGroup.setText(Policy.bind("ConfigureTagsDialog.tagHeader"));
                        SvnWizardConfigureTagsPage.this.branchButton.setSelection(false);
                    }
                    SvnWizardConfigureTagsPage.this.revisionText.setText(Integer.toString(alias.getRevision()));
                    SvnWizardConfigureTagsPage.this.nameText.setText(alias.getName());
                    if (alias.getRelativePath() == null) {
                        SvnWizardConfigureTagsPage.this.pathText.setText("");
                    } else {
                        SvnWizardConfigureTagsPage.this.pathText.setText(alias.getRelativePath());
                    }
                    SvnWizardConfigureTagsPage.this.setTagGroupEnablement(true);
                } else {
                    SvnWizardConfigureTagsPage.this.tagGroup.setText("");
                    SvnWizardConfigureTagsPage.this.revisionText.setText("");
                    SvnWizardConfigureTagsPage.this.nameText.setText("");
                    SvnWizardConfigureTagsPage.this.pathText.setText("");
                    SvnWizardConfigureTagsPage.this.branchButton.setSelection(false);
                    SvnWizardConfigureTagsPage.this.setTagGroupEnablement(false);
                }
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardConfigureTagsPage.this.applyButton.setEnabled(SvnWizardConfigureTagsPage.this.canUpdate());
                if (SvnWizardConfigureTagsPage.this.applyButton.isEnabled()) {
                    SvnWizardConfigureTagsPage.this.tagUpdatePending = true;
                } else {
                    SvnWizardConfigureTagsPage.this.tagUpdatePending = false;
                }
            }
        };
        this.revisionText.addModifyListener(modifyListener);
        this.nameText.addModifyListener(modifyListener);
        this.pathText.addModifyListener(modifyListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener((FocusListener)focusListener);
        this.nameText.addFocusListener((FocusListener)focusListener);
        this.pathText.addFocusListener((FocusListener)focusListener);
        this.branchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardConfigureTagsPage.this.applyButton.setEnabled(SvnWizardConfigureTagsPage.this.canUpdate());
                if (SvnWizardConfigureTagsPage.this.applyButton.isEnabled()) {
                    SvnWizardConfigureTagsPage.this.tagUpdatePending = true;
                } else {
                    SvnWizardConfigureTagsPage.this.tagUpdatePending = false;
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
                Iterator iter = selection.iterator();
                boolean deleteAdded = false;
                boolean addAdded = false;
                while (iter.hasNext()) {
                    Object selectedItem = iter.next();
                    if (!deleteAdded && selectedItem instanceof Alias) {
                        manager.add((IAction)SvnWizardConfigureTagsPage.this.deleteAction);
                        deleteAdded = true;
                    }
                    if (!addAdded && selectedItem instanceof ISVNRemoteFolder) {
                        manager.add((IAction)SvnWizardConfigureTagsPage.this.addBranchAction);
                        manager.add((IAction)SvnWizardConfigureTagsPage.this.addTagAction);
                        addAdded = true;
                    }
                    if (deleteAdded && addAdded) break;
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.configure_tags_dialog_context");
    }

    public String getWindowTitle() {
        return Policy.bind("ConfigureTagsDialog.title");
    }

    public boolean performCancel() {
        return !this.updates || MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("ConfigureTagsDialog.title"), (String)Policy.bind("ConfigureTagsDialog.confirmExit"));
    }

    public boolean performFinish() {
        if (this.updates) {
            try {
                String propertyValue = this.getPropertyValue();
                int i = 0;
                while (i < this.svnResources.length) {
                    this.svnResources[i].setSvnProperty("subclipse:tags", propertyValue, false);
                    ++i;
                }
            }
            catch (SVNException e) {
                if (!e.operationInterrupted()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ConfigureTagsDialog.title"), (String)e.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    public void saveSettings() {
    }

    public void setMessage() {
        this.setMessage(Policy.bind("ConfigureTagsDialog.text"));
    }

    private void setTagGroupEnablement(boolean enable) {
        this.revisionLabel.setEnabled(enable);
        this.revisionText.setEnabled(enable);
        this.nameLabel.setEnabled(enable);
        this.nameText.setEnabled(enable);
        this.pathLabel.setEnabled(enable);
        this.pathText.setEnabled(enable);
        this.browseButton.setEnabled(enable);
        this.branchButton.setEnabled(enable);
        this.tagGroup.setEnabled(enable);
    }

    private boolean canUpdate() {
        if (this.revisionText.getText().trim().length() == 0 || this.nameText.getText().trim().length() == 0) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Alias alias = (Alias)selection.getFirstElement();
        return !this.revisionText.getText().trim().equals(Integer.toString(alias.getRevision())) || !this.nameText.getText().trim().equals(alias.getName()) || !this.pathText.getText().trim().equals(alias.getRelativePath()) || this.branchButton.getSelection() != alias.isBranch();
    }

    private void getBranchesAndTags() {
        AliasManager aliasManager = new AliasManager(this.svnResources[0].getResource(), false);
        Alias[] branchAliases = aliasManager.getBranches();
        this.branches = new Branches(branchAliases);
        Alias[] tagAliases = aliasManager.getTags();
        this.tags = new Tags(tagAliases);
    }

    private String getPropertyValue() {
        StringBuffer propertyValue = new StringBuffer();
        Alias[] branchAliases = this.branches.getBranches();
        int i = 0;
        while (i < branchAliases.length) {
            if (branchAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias branch = branchAliases[i];
                propertyValue.append(String.valueOf(branch.getRevision()) + "," + branch.getName());
                if (branch.getRelativePath() != null) {
                    propertyValue.append("," + branch.getRelativePath());
                }
                if (branch.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        Alias[] tagAliases = this.tags.getTags();
        int i2 = 0;
        while (i2 < tagAliases.length) {
            if (tagAliases[i2].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias tag = tagAliases[i2];
                propertyValue.append(String.valueOf(tag.getRevision()) + "," + tag.getName());
                if (tag.getRelativePath() != null) {
                    propertyValue.append("," + tag.getRelativePath());
                }
                if (tag.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i2;
        }
        return propertyValue.toString();
    }

    static /* synthetic */ ISVNClientAdapter access$13(SvnWizardConfigureTagsPage svnWizardConfigureTagsPage) {
        return svnWizardConfigureTagsPage.svnClient;
    }

    class TagsContentProvider
    extends WorkbenchContentProvider {
        public TagsContentProvider(IResource resource) {
            AliasManager tagManager = new AliasManager(resource);
            Alias[] branchAliases = tagManager.getBranches();
            Alias[] tagAliases = tagManager.getTags();
            SvnWizardConfigureTagsPage.this.branches = new Branches(branchAliases);
            SvnWizardConfigureTagsPage.this.tags = new Tags(tagAliases);
        }

        public boolean hasChildren(Object element) {
            if (element == null) {
                return false;
            }
            if (element instanceof Branches || element instanceof Tags) {
                return true;
            }
            if (element instanceof Alias) {
                return false;
            }
            if (element instanceof ISVNRepositoryLocation) {
                return true;
            }
            if (element instanceof ISVNRemoteResource) {
                return ((ISVNRemoteResource)element).isContainer();
            }
            return super.hasChildren(element);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ISVNLocalResource) {
                Object[] rootChildren = new Object[]{((ISVNLocalResource)parentElement).getRepository(), SvnWizardConfigureTagsPage.this.branches, SvnWizardConfigureTagsPage.this.tags};
                return rootChildren;
            }
            if (parentElement instanceof Branches) {
                return ((Branches)parentElement).getBranches();
            }
            if (parentElement instanceof Tags) {
                return ((Tags)parentElement).getTags();
            }
            IWorkbenchAdapter adapter = this.getAdapter(parentElement);
            if (adapter instanceof SVNModelElement) {
                Object[] children = ((SVNModelElement)adapter).getChildren(parentElement);
                ArrayList<Object> folderArray = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof ISVNRemoteFolder) {
                        folderArray.add(children[i]);
                    }
                    ++i;
                }
                children = new Object[folderArray.size()];
                folderArray.toArray(children);
                return children;
            }
            return super.getChildren(parentElement);
        }
    }

    class UpdateAction
    extends Action {
        private Alias previousAlias;

        public UpdateAction() {
        }

        public UpdateAction(Alias alias) {
            this();
            this.previousAlias = alias;
        }

        public void run() {
            SvnWizardConfigureTagsPage.this.updates = true;
            SvnWizardConfigureTagsPage.this.tagUpdatePending = false;
            boolean branchAttributeChanged = false;
            Alias alias = null;
            if (this.previousAlias == null) {
                IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
                alias = (Alias)selection.getFirstElement();
            } else {
                alias = this.previousAlias;
            }
            alias.setRevision(Integer.parseInt(SvnWizardConfigureTagsPage.this.revisionText.getText().trim()));
            alias.setName(SvnWizardConfigureTagsPage.this.nameText.getText().trim());
            if (SvnWizardConfigureTagsPage.this.pathText.getText().trim().length() == 0) {
                alias.setRelativePath(null);
            } else {
                alias.setRelativePath(SvnWizardConfigureTagsPage.this.pathText.getText().trim());
            }
            if (alias.isBranch() != SvnWizardConfigureTagsPage.this.branchButton.getSelection()) {
                branchAttributeChanged = true;
            }
            alias.setBranch(SvnWizardConfigureTagsPage.this.branchButton.getSelection());
            if (branchAttributeChanged) {
                ArrayList<Alias> branchArray = new ArrayList<Alias>();
                ArrayList<Alias> tagArray = new ArrayList<Alias>();
                Object[] branchAliases = SvnWizardConfigureTagsPage.this.branches.getBranches();
                Object[] tagAliases = SvnWizardConfigureTagsPage.this.tags.getTags();
                int i = 0;
                while (i < branchAliases.length) {
                    if (branchAliases[i].isBranch()) {
                        branchArray.add(branchAliases[i]);
                    } else {
                        tagArray.add(branchAliases[i]);
                    }
                    ++i;
                }
                i = 0;
                while (i < tagAliases.length) {
                    if (tagAliases[i].isBranch()) {
                        branchArray.add(tagAliases[i]);
                    } else {
                        tagArray.add(tagAliases[i]);
                    }
                    ++i;
                }
                branchAliases = new Alias[branchArray.size()];
                tagAliases = new Alias[tagArray.size()];
                branchArray.toArray(branchAliases);
                tagArray.toArray(tagAliases);
                Arrays.sort(branchAliases);
                Arrays.sort(tagAliases);
                SvnWizardConfigureTagsPage.this.branches.setBranches((Alias[])branchAliases);
                SvnWizardConfigureTagsPage.this.tags.setTags((Alias[])tagAliases);
            }
            SvnWizardConfigureTagsPage.this.treeViewer.refresh();
            SvnWizardConfigureTagsPage.this.applyButton.setEnabled(false);
        }
    }

    class DeleteAction
    extends Action {
        DeleteAction() {
        }

        public void run() {
            SvnWizardConfigureTagsPage.this.updates = true;
            IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
            ArrayList<Alias> branchArray = new ArrayList<Alias>();
            ArrayList<Alias> tagArray = new ArrayList<Alias>();
            Alias[] branchAliases = SvnWizardConfigureTagsPage.this.branches.getBranches();
            Alias[] tagAliases = SvnWizardConfigureTagsPage.this.tags.getTags();
            int i = 0;
            while (i < branchAliases.length) {
                branchArray.add(branchAliases[i]);
                ++i;
            }
            i = 0;
            while (i < tagAliases.length) {
                tagArray.add(tagAliases[i]);
                ++i;
            }
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object selectedItem = iter.next();
                if (!(selectedItem instanceof Alias)) continue;
                Alias alias = (Alias)selectedItem;
                if (alias.isBranch()) {
                    branchArray.remove(alias);
                    continue;
                }
                tagArray.remove(alias);
            }
            branchAliases = new Alias[branchArray.size()];
            branchArray.toArray(branchAliases);
            SvnWizardConfigureTagsPage.this.branches.setBranches(branchAliases);
            tagAliases = new Alias[tagArray.size()];
            tagArray.toArray(tagAliases);
            SvnWizardConfigureTagsPage.this.tags.setTags(tagAliases);
            SvnWizardConfigureTagsPage.this.treeViewer.refresh();
        }
    }

    class AddBranchAction
    extends Action {
        AddBranchAction() {
        }

        public void run() {
            SvnWizardConfigureTagsPage.this.updates = true;
            ArrayList<Alias> branchArray = new ArrayList<Alias>();
            Object[] branchAliases = SvnWizardConfigureTagsPage.this.branches.getBranches();
            int i = 0;
            while (i < branchAliases.length) {
                branchArray.add(branchAliases[i]);
                ++i;
            }
            IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object selectedItem = iter.next();
                if (!(selectedItem instanceof ISVNRemoteFolder)) continue;
                ISVNRemoteFolder folder = (ISVNRemoteFolder)selectedItem;
                Alias newAlias = new Alias();
                newAlias.setBranch(true);
                newAlias.setName(folder.getName());
                String revNo = folder.getLastChangedRevision().toString();
                int revision = Integer.parseInt(revNo);
                newAlias.setRevision(revision);
                newAlias.setUrl(folder.getUrl().toString());
                String relativePath = folder.getUrl().toString().substring(folder.getRepository().getUrl().toString().length());
                newAlias.setRelativePath(relativePath);
                branchArray.add(newAlias);
            }
            branchAliases = new Alias[branchArray.size()];
            branchArray.toArray(branchAliases);
            Arrays.sort(branchAliases);
            SvnWizardConfigureTagsPage.this.branches.setBranches((Alias[])branchAliases);
            SvnWizardConfigureTagsPage.this.treeViewer.refresh();
        }
    }

    class AddTagAction
    extends Action {
        AddTagAction() {
        }

        public void run() {
            SvnWizardConfigureTagsPage.this.updates = true;
            ArrayList<Alias> tagArray = new ArrayList<Alias>();
            Object[] tagAliases = SvnWizardConfigureTagsPage.this.tags.getTags();
            int i = 0;
            while (i < tagAliases.length) {
                tagArray.add(tagAliases[i]);
                ++i;
            }
            IStructuredSelection selection = (IStructuredSelection)SvnWizardConfigureTagsPage.this.treeViewer.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object selectedItem = iter.next();
                if (!(selectedItem instanceof ISVNRemoteFolder)) continue;
                ISVNRemoteFolder folder = (ISVNRemoteFolder)selectedItem;
                Alias newAlias = new Alias();
                newAlias.setBranch(false);
                newAlias.setName(folder.getName());
                String revNo = folder.getLastChangedRevision().toString();
                int revision = Integer.parseInt(revNo);
                newAlias.setRevision(revision);
                newAlias.setUrl(folder.getUrl().toString());
                String relativePath = folder.getUrl().toString().substring(folder.getRepository().getUrl().toString().length());
                newAlias.setRelativePath(relativePath);
                tagArray.add(newAlias);
            }
            tagAliases = new Alias[tagArray.size()];
            tagArray.toArray(tagAliases);
            Arrays.sort(tagAliases);
            SvnWizardConfigureTagsPage.this.tags.setTags((Alias[])tagAliases);
            SvnWizardConfigureTagsPage.this.treeViewer.refresh();
        }
    }

    class TagsLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        TagsLabelProvider() {
        }

        public Color getForeground(Object element) {
            return this.workbenchLabelProvider.getForeground(element);
        }

        public Color getBackground(Object element) {
            return this.workbenchLabelProvider.getBackground(element);
        }

        public Font getFont(Object element) {
            return this.workbenchLabelProvider.getFont(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Branches) {
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/branches_rep.gif").createImage();
            }
            if (element instanceof Tags) {
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/versions_rep.gif").createImage();
            }
            if (element instanceof Alias) {
                if (((Alias)element).isBranch()) {
                    return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/tag.gif").createImage();
                }
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif").createImage();
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Branches) {
                return Policy.bind("ChooseUrlDialog.branches");
            }
            if (element instanceof Tags) {
                return Policy.bind("ChooseUrlDialog.tags");
            }
            if (element instanceof Alias) {
                return ((Alias)element).getName();
            }
            return this.workbenchLabelProvider.getText(element);
        }
    }
}

