/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class GenerateDiffFileOperation
implements IRunnableWithProgress {
    private static String ECLIPSE_PATCH_HEADER = "### Eclipse Workspace Patch 1.0";
    private static String ECLIPSE_PROJECT_MARKER = "#P ";
    private static String EOL = System.getProperty("line.separator");
    private File outputFile;
    private IResource[] resources;
    private IResource[] unaddedResources;
    private Shell shell;
    private boolean recursive;
    private boolean toClipboard;
    private ArrayList newFiles;
    private IResource[] selectedResources;
    private final boolean eclipseFormat;
    private final boolean projectRelative;

    GenerateDiffFileOperation(IResource[] resources, IResource[] unaddedResources, File file, boolean toClipboard, boolean recursive, boolean eclipseFormat, boolean projectRelative, Shell shell) {
        this.resources = resources;
        this.unaddedResources = unaddedResources;
        this.outputFile = file;
        this.eclipseFormat = eclipseFormat;
        this.projectRelative = projectRelative;
        this.shell = shell;
        this.recursive = recursive;
        this.toClipboard = toClipboard;
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                Object var10_17;
                monitor.beginTask("", 500);
                monitor.setTaskName(Policy.bind("GenerateSVNDiff.working"));
                OutputStream os = this.toClipboard ? new ByteArrayOutputStream() : new FileOutputStream(this.outputFile);
                File tmpFile = File.createTempFile("sub", "");
                tmpFile.deleteOnExit();
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]);
                this.newFiles = new ArrayList();
                if (this.unaddedResources.length > 0) {
                    int i = 0;
                    while (true) {
                        if (i >= this.unaddedResources.length) {
                            if (this.newFiles.size() <= 0) break;
                            try {
                                Hashtable table = this.getProviderMapping(this.newFiles.toArray(new IResource[this.newFiles.size()]));
                                Set keySet = table.keySet();
                                Iterator iterator = keySet.iterator();
                                while (iterator.hasNext()) {
                                    IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 100);
                                    SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
                                    List list = (List)table.get(provider);
                                    IResource[] providerResources = list.toArray(new IResource[list.size()]);
                                    provider.add(providerResources, 2, subMonitor);
                                }
                                break;
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        this.newFiles.add(this.unaddedResources[i]);
                        ++i;
                    }
                }
                ISVNClientAdapter svnClient = svnResource.getRepository().getSVNClient();
                try {
                    int length;
                    monitor.worked(100);
                    File[] files = this.getVersionedFiles();
                    if (this.selectedResources == null) {
                        svnClient.diff(files, tmpFile, this.recursive);
                    } else if (this.eclipseFormat) {
                        HashSet<IResource> includedResources = new HashSet<IResource>();
                        includedResources.addAll(Arrays.asList(this.unaddedResources));
                        includedResources.addAll(Arrays.asList(this.resources));
                        this.createEclipsePatch(includedResources.toArray(new IResource[0]), tmpFile, this.recursive);
                    } else {
                        File relativeToPath = null;
                        if (this.projectRelative) {
                            relativeToPath = this.selectedResources[0].getProject().getLocation().toFile();
                        } else {
                            relativeToPath = this.getRelativeToPath();
                            if (relativeToPath.isFile()) {
                                relativeToPath = relativeToPath.getParentFile();
                            }
                        }
                        svnClient.createPatch(files, relativeToPath, tmpFile, this.recursive);
                    }
                    monitor.worked(300);
                    FileInputStream is = new FileInputStream(tmpFile);
                    byte[] buffer = new byte[30000];
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    var10_17 = null;
                    os.close();
                    throw throwable;
                }
                {
                    var10_17 = null;
                }
                os.close();
                if (this.newFiles.size() > 0) {
                    int i = 0;
                    while (i < this.newFiles.size()) {
                        IResource resource = (IResource)this.newFiles.get(i);
                        try {
                            SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).revert();
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                boolean emptyDiff = false;
                if (this.toClipboard) {
                    final ByteArrayOutputStream baos = (ByteArrayOutputStream)os;
                    if (baos.size() == 0) {
                        emptyDiff = true;
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                                Clipboard clipboard = new Clipboard(GenerateDiffFileOperation.this.shell.getDisplay());
                                clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
                                clipboard.dispose();
                            }
                        });
                    }
                } else if (this.outputFile.length() == 0L) {
                    emptyDiff = true;
                    this.outputFile.delete();
                }
                if (emptyDiff) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)GenerateDiffFileOperation.this.shell, (String)Policy.bind("GenerateSVNDiff.noDiffsFoundTitle"), (String)Policy.bind("GenerateSVNDiff.noDiffsFoundMsg"));
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_22 = null;
        }
        monitor.done();
    }

    private File getRelativeToPath() {
        if (this.selectedResources.length == 1) {
            return new File(this.selectedResources[0].getLocation().toString());
        }
        String commonRoot = null;
        String path = this.selectedResources[0].getLocation().toString();
        int i = 0;
        block0: while (i < path.length()) {
            String partialPath = path.substring(0, i + 1);
            if (partialPath.endsWith("/") || partialPath.endsWith("\\")) {
                int j = 1;
                while (j < this.selectedResources.length) {
                    if (!this.selectedResources[j].getLocation().toString().startsWith(partialPath)) break block0;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i);
            }
            ++i;
        }
        if (commonRoot != null) {
            return new File(commonRoot);
        }
        return null;
    }

    private File[] getVersionedFiles() {
        ArrayList<File> versionedFileList = new ArrayList<File>();
        ArrayList<IResource> unaddedResourceList = new ArrayList<IResource>();
        int i = 0;
        while (i < this.unaddedResources.length) {
            unaddedResourceList.add(this.unaddedResources[i]);
            ++i;
        }
        i = 0;
        while (i < this.resources.length) {
            if (!this.containsResource(unaddedResourceList, this.resources[i]) || this.containsResource(this.newFiles, this.resources[i])) {
                versionedFileList.add(new File(this.resources[i].getLocation().toOSString()));
            }
            ++i;
        }
        File[] files = new File[versionedFileList.size()];
        versionedFileList.toArray(files);
        return files;
    }

    private boolean containsResource(ArrayList list, IResource resource) {
        if (list.contains(resource)) {
            return true;
        }
        IResource parent = resource;
        while (parent != null) {
            if (!list.contains(parent = parent.getParent())) continue;
            return true;
        }
        return false;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    /*
     * Exception decompiling
     */
    private void createEclipsePatch(IResource[] paths, File outputFile, boolean recurse) throws SVNClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 382->385)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

