/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.StatusCommand;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class StatusAndInfoCommand
extends StatusCommand
implements ISVNCommand {
    private RemoteResourceStatus[] remoteStatuses;
    private ISVNLocalResource svnResource;

    public StatusAndInfoCommand(ISVNLocalResource svnResource, boolean descend, boolean getAll, boolean contactServer) {
        super(svnResource.getFile(), descend, getAll, contactServer);
        this.svnResource = svnResource;
    }

    protected void execute(ISVNClientAdapter client, IProgressMonitor monitor) throws SVNClientException {
        super.execute(client, monitor);
        monitor.worked(50);
        this.remoteStatuses = this.collectRemoteStatuses(this.getStatuses(), client, Policy.subMonitorFor(monitor, 50));
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            ISVNClientAdapter svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
            this.execute(svnClient, monitor);
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
    }

    public RemoteResourceStatus[] getRemoteResourceStatuses() {
        return this.remoteStatuses;
    }

    private RemoteResourceStatus[] collectRemoteStatuses(ISVNStatus[] statuses, ISVNClientAdapter client, IProgressMonitor monitor) {
        RemoteResourceStatus[] remoteResourceStatusArray;
        monitor.beginTask("", statuses.length);
        try {
            RemoteResourceStatus[] result = new RemoteResourceStatus[statuses.length];
            Arrays.sort(statuses, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ISVNStatus)o1).getPath().compareTo(((ISVNStatus)o2).getPath());
                }
            });
            int i = 0;
            while (i < statuses.length) {
                ISVNStatus status = statuses[i];
                SVNStatusKind localTextStatus = status.getTextStatus();
                result[i] = SVNStatusKind.UNVERSIONED.equals((Object)localTextStatus) || SVNStatusKind.ADDED.equals((Object)localTextStatus) || SVNStatusKind.IGNORED.equals((Object)localTextStatus) ? (SVNStatusKind.NONE.equals((Object)status.getRepositoryTextStatus()) ? RemoteResourceStatus.NONE : new RemoteResourceStatus(statuses[i], this.getRevisionFor(statuses[i]))) : new RemoteResourceStatus(statuses[i], this.getRevisionFor(statuses[i]));
                monitor.worked(1);
                ++i;
            }
            remoteResourceStatusArray = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return remoteResourceStatusArray;
    }
}

