/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse;

import java.net.URL;
import java.util.Hashtable;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.impl.Logger;
import org.eclipse.jface.resource.ImageDescriptor;

public class ImageStore {
    static final URL BASE_URL = ColorerPlugin.getDefault().getBundle().getEntry("/");
    static Hashtable hash = new Hashtable();
    public static final ImageDescriptor EDITOR_UPDATEHRC;
    public static final ImageDescriptor EDITOR_UPDATEHRC_A;
    public static final ImageDescriptor EDITOR_FILETYPE;
    public static final ImageDescriptor EDITOR_FILETYPE_A;
    public static final ImageDescriptor EDITOR_CUR_FILETYPE;
    public static final ImageDescriptor EDITOR_CUR_GROUP;
    public static final ImageDescriptor EDITOR_GROUP;
    public static final ImageDescriptor EDITOR_PAIR_MATCH;
    public static final ImageDescriptor EDITOR_PAIR_SELECT;
    public static final ImageDescriptor EDITOR_PAIR_SELECTCONTENT;
    static String iconPath;
    static String prefix;

    private static ImageDescriptor createImageDescriptor(String path) {
        URL url = null;
        try {
            url = new URL(BASE_URL, path);
            url.openStream().close();
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (Exception e) {
            Logger.trace("ImageStore", "Can't open URL: " + url);
            return null;
        }
    }

    public static ImageDescriptor getID(String name) {
        ImageDescriptor id = (ImageDescriptor)hash.get(name);
        if (id == null) {
            id = ImageStore.createImageDescriptor(prefix + name + ".gif");
            if (id == null) {
                return null;
            }
            hash.put(name, id);
        }
        return id;
    }

    static {
        prefix = iconPath = "icons/";
        EDITOR_UPDATEHRC = ImageStore.createImageDescriptor(prefix + "updatehrc.gif");
        EDITOR_UPDATEHRC_A = ImageStore.createImageDescriptor(prefix + "updatehrc_a.gif");
        EDITOR_FILETYPE = ImageStore.createImageDescriptor(prefix + "filetype.gif");
        EDITOR_FILETYPE_A = ImageStore.createImageDescriptor(prefix + "filetype_a.gif");
        EDITOR_CUR_FILETYPE = ImageStore.createImageDescriptor(prefix + "filetype/filetype.current.gif");
        EDITOR_CUR_GROUP = ImageStore.createImageDescriptor(prefix + "filetype/group.current.gif");
        EDITOR_GROUP = ImageStore.createImageDescriptor(prefix + "filetype/group.gif");
        EDITOR_PAIR_MATCH = ImageStore.createImageDescriptor(prefix + "pair-match.gif");
        EDITOR_PAIR_SELECT = ImageStore.createImageDescriptor(prefix + "pair-select.gif");
        EDITOR_PAIR_SELECTCONTENT = ImageStore.createImageDescriptor(prefix + "pair-select-content.gif");
    }
}

