/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.ftpp;

import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.ImageStore;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.ftpp.TypeContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class TypeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    Image grImage = ImageStore.EDITOR_CUR_GROUP.createImage();
    Image grImageDis = ImageStore.EDITOR_GROUP.createImage();
    Image hrdImage = ImageStore.EDITOR_UPDATEHRC_A.createImage();
    Image wwImage = ImageStore.EDITOR_PAIR_SELECT.createImage();
    TypeContentProvider contentProvider;

    public TypeLabelProvider(TypeContentProvider cp) {
        this.contentProvider = cp;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if ("@@HRD@@".equals(element)) {
            return this.hrdImage;
        }
        if ("@@WORD_WRAP@@".equals(element)) {
            return this.wwImage;
        }
        int value = ColorerPlugin.getDefault().getPropertyParameter(this.contentProvider.type, element.toString());
        if (value == 1) {
            return this.grImage;
        }
        if (value == 0) {
            return this.grImageDis;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.contentProvider == null) {
            return null;
        }
        if ("@@HRD@@".equals(element)) {
            if (columnIndex == 0) {
                return Messages.get("ftpp.hrd_set");
            }
            String hrd = ColorerPlugin.getDefault().getPropertyHRD(this.contentProvider.type);
            String hrd_descr = null;
            hrd_descr = hrd == null ? Messages.get("ftpp.default") : ColorerPlugin.getDefaultPF().getHRDescription("rgb", hrd);
            return hrd_descr;
        }
        if ("@@WORD_WRAP@@".equals(element)) {
            if (columnIndex == 0) {
                return Messages.get("ftpp.word_wrap");
            }
            int ww = ColorerPlugin.getDefault().getPropertyWordWrap(this.contentProvider.type);
            return this.getDefaultTrueFalse(ww);
        }
        if (columnIndex == 0) {
            return this.contentProvider.type.getParameterDescription((String)element);
        }
        int val = ColorerPlugin.getDefault().getPropertyParameter(this.contentProvider.type, element.toString());
        if (val == -1) {
            String value = this.contentProvider.type.getParameterValue((String)element);
            if (value.equals("true")) {
                val = 1;
            } else if (value.equals("false")) {
                val = 1;
            } else {
                return value;
            }
        }
        return this.getDefaultTrueFalse(val);
    }

    private String getDefaultTrueFalse(int ww) {
        if (ww == -1) {
            return Messages.get("ftpp.default");
        }
        if (ww == 0) {
            return Messages.get("ftpp.false");
        }
        if (ww == 1) {
            return Messages.get("ftpp.true");
        }
        return null;
    }
}

