/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.outline;

import java.util.Stack;
import java.util.Vector;
import net.sf.colorer.Region;
import net.sf.colorer.RegionHandler;
import net.sf.colorer.eclipse.outline.IWorkbenchOutlineSource;
import net.sf.colorer.eclipse.outline.OutlineElement;
import net.sf.colorer.eclipse.outline.OutlineSchemeElement;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.EditorListener;
import net.sf.colorer.editor.OutlineItem;
import net.sf.colorer.editor.OutlineListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ParseTreeOutliner
implements IWorkbenchOutlineSource,
RegionHandler,
EditorListener,
IWorkbenchAdapter {
    Vector listeners = new Vector();
    Vector regionsList = new Vector();
    Vector cList = this.regionsList;
    Stack schemeStack = new Stack();
    boolean changed = false;
    int modifiedLine = -1;
    int curLevel;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public void clear() {
        this.clear(this.regionsList, 0);
    }

    public void clear(Vector list, int topLine) {
        int csize;
        for (csize = 0; csize < list.size() && ((OutlineElement)list.elementAt((int)csize)).lno < topLine; ++csize) {
        }
        list.setSize(csize);
    }

    public void startParsing(int lno) {
        this.curLevel = 0;
        this.schemeStack.clear();
        this.cList = this.regionsList;
    }

    public void endParsing(int lno) {
        this.curLevel = 0;
        if (this.modifiedLine < lno) {
            this.modifiedLine = lno + 1;
        }
        if (this.changed) {
            this.notifyUpdate();
            this.changed = false;
        }
    }

    public void clearLine(int lno, String line) {
    }

    public void addRegion(int lno, String line, int sx, int ex, Region region) {
        if (lno < this.modifiedLine) {
            return;
        }
        this.cList.addElement(new OutlineElement(this, lno, sx, ex - sx, this.curLevel, null, region));
        this.changed = true;
    }

    public void enterScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
        ++this.curLevel;
        OutlineSchemeElement sel = null;
        Vector elements = null;
        if (this.cList.size() > 0 && this.cList.lastElement() instanceof OutlineSchemeElement) {
            sel = (OutlineSchemeElement)this.cList.lastElement();
            if (sel.level != this.curLevel) {
                sel = null;
            } else if (sel.lno == lno && sel.pos <= sx) {
                sel = null;
            } else if (sel.l2no != 0 && sel.l2no < lno) {
                sel = null;
            }
            if (sel != null) {
                elements = sel.elements;
                this.clear(elements, lno);
            }
        }
        if (sel == null || elements == null) {
            elements = new Vector();
            sel = new OutlineSchemeElement(this, lno, sx, ex - sx, this.curLevel, scheme, region, elements);
            this.cList.addElement(sel);
        }
        sel.pos2 = 0;
        sel.l2no = 0;
        this.schemeStack.push(this.cList);
        this.cList = elements;
    }

    public void leaveScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
        --this.curLevel;
        this.cList = (Vector)this.schemeStack.pop();
        if (this.cList.size() > 0 && this.cList.lastElement() instanceof OutlineSchemeElement) {
            OutlineSchemeElement lastScheme = (OutlineSchemeElement)this.cList.lastElement();
            lastScheme.l2no = lno;
            lastScheme.pos2 = ex;
        }
    }

    public void modifyEvent(int topLine) {
        this.clear(this.regionsList, topLine);
        this.modifiedLine = topLine;
        this.changed = true;
    }

    public Object[] getChildren(Object o) {
        if (o == this) {
            return this.regionsList.toArray();
        }
        if (o instanceof OutlineSchemeElement) {
            return ((OutlineSchemeElement)o).elements.toArray();
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof OutlineSchemeElement) {
            StringBuffer scheme = ((OutlineSchemeElement)o).token;
            return "scheme: " + scheme;
        }
        return ((OutlineItem)o).region.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ParseTreeOutliner.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
            return this;
        }
        return null;
    }

    public void setHierarchy(boolean hierarchy) {
    }

    public void setSorting(boolean sorting) {
    }

    public void attachOutliner(BaseEditor editor) {
        editor.addRegionHandler(this, null);
        editor.addEditorListener(this);
    }

    public void detachOutliner(BaseEditor editor) {
        editor.removeRegionHandler(this);
        editor.removeEditorListener(this);
    }

    public void addUpdateListener(OutlineListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeUpdateListener(OutlineListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void notifyUpdate() {
        for (int idx = 0; idx < this.listeners.size(); ++idx) {
            ((OutlineListener)this.listeners.elementAt(idx)).notifyUpdate();
        }
    }

    public Object getItemByLine(int line) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

