/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.CommentedASMifierClassVisitor;
import de.loskutov.bco.asm.CommentedClassVisitor;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.asm.DecompilerMethodVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.AbstractVisitor;

public class DecompilerClassVisitor
extends ClassAdapter {
    private final String fieldFilter;
    private final String methodFilter;
    private String name;
    private final List methods;
    private AnnotationVisitor dummyAnnVisitor;
    private String javaVersion;
    private final BitSet modes;
    private int accessFlags;
    private final ClassNode classNode = new ClassNode();

    public DecompilerClassVisitor(ClassVisitor cv, String field, String method, BitSet modes) {
        super(cv);
        this.fieldFilter = field;
        this.methodFilter = method;
        this.modes = modes;
        this.methods = new ArrayList();
    }

    public static DecompiledClass getDecompiledClass(InputStream is, String field, String method, BitSet modes, ClassLoader cl) throws IOException, UnsupportedClassVersionError {
        ClassReader cr = new ClassReader(is);
        int crFlags = 0;
        if (modes.get(7)) {
            crFlags |= 8;
        }
        Object cv = modes.get(2) ? new CommentedASMifierClassVisitor(modes) : new CommentedClassVisitor(modes);
        DecompilerClassVisitor dcv = new DecompilerClassVisitor((ClassVisitor)cv, field, method, modes);
        cr.accept((ClassVisitor)dcv, crFlags);
        return dcv.getResult(cl);
    }

    public DecompiledClass getResult(ClassLoader cl) {
        ArrayList text = new ArrayList();
        this.formatText(((AbstractVisitor)this.cv).getText(), new StringBuffer(), text, cl);
        while (text.size() > 0 && text.get(0).equals("\n")) {
            text.remove(0);
        }
        DecompiledClass dc = new DecompiledClass(text);
        dc.setAttribute("java.version", this.javaVersion);
        dc.setAttribute("access", String.valueOf(this.accessFlags));
        dc.setClassNode(this.classNode);
        return dc;
    }

    private void formatText(List input, StringBuffer line, List result, ClassLoader cl) {
        for (int i = 0; i < input.size(); ++i) {
            int p;
            Object o = input.get(i);
            if (o instanceof List) {
                this.formatText((List)o, line, result, cl);
                continue;
            }
            if (o instanceof DecompilerMethodVisitor) {
                result.add(((DecompilerMethodVisitor)((Object)o)).getResult(cl));
                continue;
            }
            String s = o.toString();
            do {
                if ((p = s.indexOf(10)) == -1) {
                    line.append(s);
                    continue;
                }
                result.add(line.toString() + s.substring(0, p + 1));
                s = s.substring(p + 1);
                line.setLength(0);
            } while (p != -1);
        }
    }

    public void visit(int version, int access, String name1, String signature, String superName, String[] interfaces) {
        if (this.decompilingEntireClass()) {
            super.visit(version, access, name1, signature, superName, interfaces);
        }
        this.classNode.visit(version, access, name1, signature, superName, interfaces);
        this.name = name1;
        int major = version & 0xFFFF;
        int javaV = major % 44;
        if (javaV > 0 && javaV < 10) {
            this.javaVersion = "1." + javaV;
        }
        this.accessFlags = access;
    }

    public void visitSource(String source, String debug) {
        if (this.decompilingEntireClass()) {
            super.visitSource(source, debug);
            this.classNode.visitSource(source, debug);
        }
    }

    private boolean decompilingEntireClass() {
        return this.methodFilter == null && this.fieldFilter == null;
    }

    public void visitOuterClass(String owner, String name1, String desc) {
        if (this.decompilingEntireClass()) {
            super.visitOuterClass(owner, name1, desc);
            this.classNode.visitOuterClass(owner, name1, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.decompilingEntireClass()) {
            AnnotationVisitor cav = this.classNode.visitAnnotation(desc, visible);
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (av instanceof CommentedClassVisitor.CommentedAnnotationVisitor) {
                CommentedClassVisitor.CommentedAnnotationVisitor visitor = (CommentedClassVisitor.CommentedAnnotationVisitor)av;
                visitor.setAnnotationVisitor(cav);
            }
            return av;
        }
        return this.getDummyAnnotationVisitor();
    }

    public void visitAttribute(Attribute attr) {
        if (this.decompilingEntireClass()) {
            super.visitAttribute(attr);
            this.classNode.visitAttribute(attr);
        }
    }

    public void visitInnerClass(String name1, String outerName, String innerName, int access) {
        if (this.decompilingEntireClass()) {
            super.visitInnerClass(name1, outerName, innerName, access);
            this.classNode.visitInnerClass(name1, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name1, String desc, String signature, Object value) {
        if (this.methodFilter != null) {
            return null;
        }
        if (this.fieldFilter != null && !name1.equals(this.fieldFilter)) {
            return null;
        }
        FieldVisitor cfv = this.classNode.visitField(access, name1, desc, signature, value);
        FieldVisitor fieldVisitor = super.visitField(access, name1, desc, signature, value);
        if (fieldVisitor instanceof CommentedClassVisitor.CommentedFieldVisitor) {
            CommentedClassVisitor.CommentedFieldVisitor visitor = (CommentedClassVisitor.CommentedFieldVisitor)fieldVisitor;
            visitor.setFieldVisitor(cfv);
        }
        return fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name1, String desc, String signature, String[] exceptions) {
        if (this.fieldFilter != null) {
            return null;
        }
        if (this.methodFilter != null && !(name1 + desc).equals(this.methodFilter)) {
            return null;
        }
        MethodNode meth = (MethodNode)this.classNode.visitMethod(access, name1, desc, signature, exceptions);
        List text = ((AbstractVisitor)this.cv).getText();
        int size = text.size();
        Object mv = this.cv.visitMethod(access, name1, desc, signature, exceptions);
        mv = new DecompilerMethodVisitor(this.name, meth, (MethodVisitor)mv, this.modes);
        this.methods.add(mv);
        for (int i = size; i < text.size(); ++i) {
            if (!(text.get(i) instanceof List)) continue;
            text.set(i, mv);
        }
        return mv;
    }

    public void visitEnd() {
        if (this.decompilingEntireClass()) {
            this.classNode.visitEnd();
            super.visitEnd();
        }
    }

    private AnnotationVisitor getDummyAnnotationVisitor() {
        if (this.dummyAnnVisitor == null) {
            this.dummyAnnVisitor = new AnnotationVisitor(){

                public void visit(String n, Object value) {
                }

                public void visitEnum(String n, String desc, String value) {
                }

                public AnnotationVisitor visitAnnotation(String n, String desc) {
                    return this;
                }

                public AnnotationVisitor visitArray(String n) {
                    return this;
                }

                public void visitEnd() {
                }
            };
        }
        return this.dummyAnnVisitor;
    }
}

