/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class ConnectionEventSupport {
    PooledConnection source;
    Set mlisteners = new HashSet();

    public ConnectionEventSupport(PooledConnection source) {
        this.source = source;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener mlistener) {
        this.mlisteners.add(mlistener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener mlistener) {
        this.mlisteners.remove(mlistener);
    }

    public synchronized void fireConnectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this.source);
        Iterator i = this.mlisteners.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cl = (ConnectionEventListener)i.next();
            cl.connectionClosed(evt);
        }
    }

    public synchronized void fireConnectionErrorOccurred(SQLException error) {
        ConnectionEvent evt = new ConnectionEvent(this.source, error);
        Iterator i = this.mlisteners.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cl = (ConnectionEventListener)i.next();
            cl.connectionErrorOccurred(evt);
        }
    }
}

