/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.io.UTF8StreamWriter;
import javolution.util.FastList;

public class Announcements {
    private static Logger _log = Logger.getLogger(Announcements.class.getName());
    private List<String> _announcements = new FastList();
    private List<String> _critAnnouncements = new FastList();
    private List<List<Object>> _eventAnnouncements = new FastList();

    private Announcements() {
        this.loadAnnouncements();
    }

    public static Announcements getInstance() {
        return SingletonHolder._instance;
    }

    public void loadAnnouncements() {
        this._announcements.clear();
        this._critAnnouncements.clear();
        this.readFromDisk("data/announcements.txt", this._announcements);
        this.readFromDisk("data/critannouncements.txt", this._critAnnouncements);
        if (Config.DEBUG) {
            _log.info("Announcements: Loaded " + (this._announcements.size() + this._critAnnouncements.size()) + " announcements.");
        }
    }

    public void showAnnouncements(L2PcInstance activeChar) {
        CreatureSay cs;
        for (String announce : this._announcements) {
            cs = new CreatureSay(0, 10, activeChar.getName(), announce);
            activeChar.sendPacket(cs);
        }
        for (String critAnnounce : this._critAnnouncements) {
            if (critAnnounce.indexOf(37) >= 0) {
                critAnnounce = critAnnounce.replaceFirst("%server_name%", LoginServerThread.getInstance().getServerName());
            }
            cs = new CreatureSay(0, 18, activeChar.getName(), critAnnounce);
            activeChar.sendPacket(cs);
        }
        Iterator<Object> i$ = this._eventAnnouncements.iterator();
        while (i$.hasNext()) {
            List eventAnnounce;
            List entry = eventAnnounce = (List)i$.next();
            DateRange validDateRange = (DateRange)entry.get(0);
            String[] msg = (String[])entry.get(1);
            Date currentDate = new Date();
            if (!validDateRange.isValid() || !validDateRange.isWithinRange(currentDate)) continue;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
            for (int j = 0; j < msg.length; ++j) {
                sm.addString(msg[j]);
            }
            activeChar.sendPacket(sm);
        }
    }

    public void addEventAnnouncement(DateRange validDateRange, String[] msg) {
        FastList entry = new FastList();
        entry.add(validDateRange);
        entry.add(msg);
        this._eventAnnouncements.add((List<Object>)entry);
    }

    public void listAnnouncements(L2PcInstance activeChar) {
        String content = HtmCache.getInstance().getHtmForce(activeChar.getHtmlPrefix(), "data/html/admin/announce.htm");
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        adminReply.setHtml(content);
        StringBuilder replyMSG = StringUtil.startAppend(500, "<br>");
        for (int i = 0; i < this._announcements.size(); ++i) {
            StringUtil.append(replyMSG, "<table width=260><tr><td width=220>", this._announcements.get(i), "</td><td width=40><button value=\"Delete\" action=\"bypass -h admin_del_announcement ", String.valueOf(i), "\" width=60 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table>");
        }
        adminReply.replace((CharSequence)"%announces%", replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void listCritAnnouncements(L2PcInstance activeChar) {
        String content = HtmCache.getInstance().getHtmForce(activeChar.getHtmlPrefix(), "data/html/admin/critannounce.htm");
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        adminReply.setHtml(content);
        StringBuilder replyMSG = StringUtil.startAppend(500, "<br>");
        for (int i = 0; i < this._critAnnouncements.size(); ++i) {
            StringUtil.append(replyMSG, "<table width=260><tr><td width=220>", this._critAnnouncements.get(i), "</td><td width=40><button value=\"Delete\" action=\"bypass -h admin_del_critannouncement ", String.valueOf(i), "\" width=60 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table>");
        }
        adminReply.replace((CharSequence)"%critannounces%", replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void addAnnouncement(String text) {
        this._announcements.add(text);
        this.saveToDisk(false);
    }

    public void delAnnouncement(int line) {
        this._announcements.remove(line);
        this.saveToDisk(false);
    }

    public void addCritAnnouncement(String text) {
        this._critAnnouncements.add(text);
        this.saveToDisk(true);
    }

    public void delCritAnnouncement(int line) {
        this._critAnnouncements.remove(line);
        this.saveToDisk(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromDisk(String path, List<String> list) {
        File file = new File(Config.DATAPACK_ROOT, path);
        if (file.exists()) {
            BufferedReader lnr = null;
            try {
                String line = null;
                lnr = Util.utf8BufferedReader(file);
                while ((line = lnr.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (IOException e1) {
                _log.log(Level.SEVERE, "Error reading announcements: ", e1);
            }
            finally {
                try {
                    lnr.close();
                }
                catch (Exception e2) {}
            }
        } else {
            _log.warning(file.getAbsolutePath() + " doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk(boolean isCritical) {
        List<String> list;
        String path;
        if (isCritical) {
            path = "data/critannouncements.txt";
            list = this._critAnnouncements;
        } else {
            path = "data/announcements.txt";
            list = this._announcements;
        }
        File file = new File(path);
        UTF8StreamWriter save = null;
        try {
            save = Util.utf8StreamWriter(file);
            for (String announce : list) {
                save.write(announce);
                save.write("\r\n");
            }
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Saving to the announcements file has failed: ", e);
        }
        finally {
            try {
                save.close();
            }
            catch (Exception e) {}
        }
    }

    public void announceToAll(String text) {
        this.announceToAll(text, false);
    }

    public void announceToAll(String text, boolean isCritical) {
        Broadcast.announceToOnlinePlayers(text, isCritical);
    }

    public void announceToAll(SystemMessage sm) {
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void announceToInstance(SystemMessage sm, int instanceId) {
        Broadcast.toPlayersInInstance(sm, instanceId);
    }

    public void handleAnnounce(String command, int lengthToTrim, boolean isCritical) {
        try {
            String text = command.substring(lengthToTrim);
            SingletonHolder._instance.announceToAll(text, isCritical);
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final Announcements _instance = new Announcements();

        private SingletonHolder() {
        }
    }
}

