/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.communitybbs.Manager.BaseBBSManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javolution.io.UTF8StreamWriter;

public class ClanBBSManager
extends BaseBBSManager {
    private ClanBBSManager() {
    }

    public static ClanBBSManager getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        if (command.equals("_bbsclan")) {
            if (activeChar.getClan() == null || activeChar.getClan().getLevel() < 2) {
                this.clanlist(activeChar, 1);
            } else {
                this.clanhome(activeChar);
            }
        } else if (command.startsWith("_bbsclan_clanlist")) {
            if (command.equals("_bbsclan_clanlist")) {
                this.clanlist(activeChar, 1);
            } else if (command.startsWith("_bbsclan_clanlist;")) {
                StringTokenizer st = new StringTokenizer(command, ";");
                st.nextToken();
                int index = Integer.parseInt(st.nextToken());
                this.clanlist(activeChar, index);
            }
        } else if (command.startsWith("_bbsclan_clanhome")) {
            if (command.equals("_bbsclan_clanhome")) {
                this.clanhome(activeChar);
            } else if (command.startsWith("_bbsclan_clanhome;")) {
                StringTokenizer st = new StringTokenizer(command, ";");
                st.nextToken();
                int index = Integer.parseInt(st.nextToken());
                this.clanhome(activeChar, index);
            }
        } else if (command.startsWith("_bbsclan_clanadmin;")) {
            StringTokenizer st = new StringTokenizer(command, ";");
            st.nextToken();
            String subcmd = st.nextToken();
            String msgType = "";
            int clanId = Integer.parseInt(st.nextToken());
            if (activeChar.getClan() == null || activeChar.getClan().getClanId() != clanId || activeChar.getClan().getLeaderId() != activeChar.getObjectId()) {
                activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
                this.parsecmd("_bbsclan_clanlist", activeChar);
                return;
            }
            if (subcmd.startsWith("new")) {
                if (subcmd.equals("newcomm")) {
                    msgType = "comment";
                } else if (subcmd.equals("newanno")) {
                    msgType = "announce";
                }
                this.showMsgEdit(activeChar, msgType, clanId);
            } else if (subcmd.startsWith("del")) {
                if (subcmd.equals("delcomm")) {
                    msgType = "comment";
                } else if (subcmd.equals("delanno")) {
                    msgType = "announce";
                }
                File file = new File(Config.DATAPACK_ROOT + "/data/clans/" + msgType + "_" + clanId + ".txt");
                file.delete();
                this.clanhome(activeChar);
            }
        } else if (command.startsWith("_bbsclan_clannotice_edit;")) {
            this.clanNotice(activeChar, activeChar.getClanId());
        } else if (command.startsWith("_bbsclan_clannotice_enable")) {
            if (activeChar.getClan() != null) {
                activeChar.getClan().setNoticeEnabled(true);
            }
            this.clanNotice(activeChar, activeChar.getClanId());
        } else if (command.startsWith("_bbsclan_clannotice_disable")) {
            if (activeChar.getClan() != null) {
                activeChar.getClan().setNoticeEnabled(false);
            }
            this.clanNotice(activeChar, activeChar.getClanId());
        } else {
            this.separateAndSend("<html><body><br><br><center>Command : " + command + " needs core development</center><br><br></body></html>", activeChar);
        }
    }

    private void clanNotice(L2PcInstance activeChar, int clanId) {
        L2Clan cl = ClanTable.getInstance().getClan(clanId);
        if (cl != null) {
            if (cl.getLevel() < 2) {
                activeChar.sendPacket(SystemMessageId.NO_CB_IN_MY_CLAN);
                this.parsecmd("_bbsclan_clanlist", activeChar);
            } else {
                StringBuilder html = StringUtil.startAppend(2000, "<html><body><br><br><table border=0 width=610><tr><td width=10></td><td width=600 align=left><a action=\"bypass _bbshome\"> &$377; </a> &gt; <a action=\"bypass _bbsclan_clanlist\"> &$337; </a>  &gt; <a action=\"bypass _bbsclan_clanhome;", String.valueOf(clanId), "\"> &amp;$802; </a></td></tr></table>");
                if (activeChar.isClanLeader()) {
                    StringUtil.append(html, "<br><br><center><table width=610 border=0 cellspacing=0 cellpadding=0><tr><td fixwidth=610><font color=\"AAAAAA\">The Clan Notice function allows the clan leader to send messages through a pop-up window to clan members at login.</font> </td></tr><tr><td height=20></td></tr>");
                    if (activeChar.getClan().isNoticeEnabled()) {
                        StringUtil.append(html, "<tr><td fixwidth=610> Clan Notice Function:&nbsp;&nbsp;&nbsp;on&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a action=\"bypass _bbsclan_clannotice_disable\">off</a>");
                    } else {
                        StringUtil.append(html, "<tr><td fixwidth=610> Clan Notice Function:&nbsp;&nbsp;&nbsp;<a action=\"bypass _bbsclan_clannotice_enable\">on</a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;off");
                    }
                    StringUtil.append(html, "</td></tr></table><img src=\"L2UI.Squaregray\" width=\"610\" height=\"1\"><br> <br><table width=610 border=0 cellspacing=2 cellpadding=0><tr><td>Edit Notice: </td></tr><tr><td height=5></td></tr><tr><td><MultiEdit var =\"Content\" width=610 height=100></td></tr></table><br><table width=610 border=0 cellspacing=0 cellpadding=0><tr><td height=5></td></tr><tr><td align=center FIXWIDTH=65><button value=\"&$140;\" action=\"Write Notice Set _ Content Content Content\" back=\"L2UI_ct1.button_df_down\" width=65 height=21 fore=\"L2UI_ct1.button_df\" ></td><td align=center FIXWIDTH=45></td><td align=center FIXWIDTH=500></td></tr></table></center></body></html>");
                    this.send1001(html.toString(), activeChar);
                    this.send1002(activeChar, activeChar.getClan().getNotice(), " ", "0");
                } else {
                    StringUtil.append(html, "<img src=\"L2UI.squareblank\" width=\"1\" height=\"10\"><center><table border=0 cellspacing=0 cellpadding=0><tr><td>You are not your clan's leader, and therefore cannot change the clan notice</td></tr></table>");
                    if (activeChar.getClan().isNoticeEnabled()) {
                        StringUtil.append(html, "<table border=0 cellspacing=0 cellpadding=0><tr><td>The current clan notice:</td></tr><tr><td fixwidth=5></td><td FIXWIDTH=600 align=left>", activeChar.getClan().getNotice(), "</td><td fixqqwidth=5></td></tr></table>");
                    }
                    StringUtil.append(html, "</center></body></html>");
                    this.separateAndSend(html.toString(), activeChar);
                }
            }
        }
    }

    private void clanlist(L2PcInstance activeChar, int index) {
        int i;
        if (index < 1) {
            index = 1;
        }
        StringBuilder html = StringUtil.startAppend(2000, "<html><body><br><br><center><table border=0 cellspacing=0 cellpadding=0><tr><td FIXWIDTH=15>&nbsp;</td><td width=610 height=30 align=left><a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a></td></tr></table><table border=0 cellspacing=0 cellpadding=0 width=610 bgcolor=434343><tr><td height=10></td></tr><tr><td fixWIDTH=5></td><td fixWIDTH=600><a action=\"bypass _bbsclan_clanhome;", String.valueOf(activeChar.getClan() != null ? activeChar.getClan().getClanId() : 0), "\">[&$802;]</a>&nbsp;&nbsp;</td><td fixWIDTH=5></td></tr><tr><td height=10></td></tr></table><br><table border=0 cellspacing=0 cellpadding=2 bgcolor=5A5A5A width=610><tr><td FIXWIDTH=5></td><td FIXWIDTH=200 align=center>&$580;</td><td FIXWIDTH=200 align=center>&$342;</td><td FIXWIDTH=100 align=center>&$392;</td><td FIXWIDTH=100 align=center>&$1036;</td><td FIXWIDTH=5></td></tr></table><img src=\"L2UI.Squareblank\" width=\"1\" height=\"5\">");
        L2Clan[] clanList = ClanTable.getInstance().getClans();
        int end = Math.min(i + 12, clanList.length);
        for (i = (index - 1) * 12; i < end; ++i) {
            L2Clan cl = clanList[i];
            if (cl == null) continue;
            html.append("<table border=0 cellspacing=0 cellpadding=5 width=610><tr> <td FIXWIDTH=5></td><td FIXWIDTH=200 align=center><a action=\"bypass _bbsclan_clanhome;").append(cl.getClanId()).append("\">").append(cl.getName()).append("</a></td><td FIXWIDTH=200 align=center>").append(cl.getLeaderName()).append("</td><td FIXWIDTH=100 align=center>").append(cl.getLevel()).append("</td><td FIXWIDTH=100 align=center>").append(cl.getMembersCount()).append("</td><td FIXWIDTH=5></td></tr></table><img src=\"L2UI.SquareGray\" width=\"610\" height=\"1\">");
        }
        html.append("<br><table cellpadding=0 cellspacing=2 border=0><tr>");
        int nbp = (clanList.length - 1) / 12 + 1;
        int startIdx = (index - 1) / 10 * 10 + 1;
        if (startIdx > 1) {
            html.append("<td><button action=\"bypass _bbsclan_clanlist;").append(startIdx - 1).append("\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
        } else {
            html.append("<td><button action=\"\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
        }
        if (index > 1) {
            html.append("<td><button action=\"bypass _bbsclan_clanlist;").append(index - 1).append("\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
        } else {
            html.append("<td><button action=\"\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
        }
        for (int i2 = startIdx; i2 <= nbp && i2 < startIdx + 10; ++i2) {
            if (i2 == index) {
                html.append("<td> ").append(i2).append(" </td>");
                continue;
            }
            html.append("<td><a action=\"bypass _bbsclan_clanlist;").append(i2).append("\"> ").append(i2).append(" </a></td>");
        }
        if (index + 1 <= nbp) {
            html.append("<td><button action=\"bypass _bbsclan_clanlist;").append(index + 1).append("\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
        } else {
            html.append("<td><button action=\"\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
        }
        if (startIdx + 10 <= nbp) {
            html.append("<td><button action=\"bypass _bbsclan_clanlist;").append(startIdx + 10).append("\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
        } else {
            html.append("<td><button action=\"\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
        }
        html.append("</tr></table></center></body></html>");
        this.separateAndSend(html.toString(), activeChar);
    }

    private void clanhome(L2PcInstance activeChar) {
        this.clanhome(activeChar, activeChar.getClan().getClanId());
    }

    private void clanhome(L2PcInstance activeChar, int clanId) {
        L2Clan cl = ClanTable.getInstance().getClan(clanId);
        if (cl != null) {
            if (activeChar.getClan() != null && activeChar.getClan().getClanId() == clanId && cl.getLevel() < 2) {
                activeChar.sendPacket(SystemMessageId.NO_CB_IN_MY_CLAN);
                this.parsecmd("_bbsclan_clanlist", activeChar);
            } else {
                StringBuilder html = StringUtil.startAppend(2000, "<html><body><center><br><br><table border=0 cellspacing=0 cellpadding=0><tr><td FIXWIDTH=15>&nbsp;</td><td width=610 height=30 align=left><a action=\"bypass _bbshome\"> &$377; </a> &gt; <a action=\"bypass _bbsclan_clanlist\"> &$809; </a>  &gt; <a action=\"bypass _bbsclan_clanhome;", String.valueOf(clanId), "\"> &amp;$802; </a></td></tr></table><table border=0 cellspacing=0 cellpadding=0 width=610 bgcolor=434343><tr><td height=10></td></tr><tr><td fixWIDTH=5></td><td fixwidth=600><a action=\"bypass _bbsclan_clanadmin;newcomm;", String.valueOf(clanId), "\">[&$423;&$424;]</a>&nbsp;<a action=\"bypass _bbsclan_clanadmin;newanno;", String.valueOf(clanId), "\">[&$328;&$424;]</a>&nbsp;<a action=\"bypass _bbscustom;msglist;clan\">[&$382;&$387;]</a>&nbsp;</td><td fixWIDTH=5></td></tr><tr><td height=10></td></tr></table><table border=0 cellspacing=0 cellpadding=0 width=610><tr><td height=10></td></tr><tr><td fixWIDTH=5></td><td fixwidth=290 valign=top>", this.getMsgData("comment", clanId), "</td><td fixWIDTH=5></td><td fixWIDTH=5 align=center valign=top><img src=\"l2ui.squaregray\" width=2  height=128></td><td fixWIDTH=5></td><td fixwidth=295><table border=0 cellspacing=0 cellpadding=0 width=295><tr><td fixWIDTH=100 align=left>&$580;</td><td fixWIDTH=195 align=left>", cl.getName(), "</td></tr><tr><td height=7></td></tr><tr><td fixWIDTH=100 align=left>&$392;</td><td fixWIDTH=195 align=left height=16>", String.valueOf(cl.getLevel()), "</td></tr><tr><td height=7></td></tr><tr><td fixWIDTH=100 align=left>&$1036;</td><td fixWIDTH=195 align=left height=16>", String.valueOf(cl.getMembersCount()), "</td></tr><tr><td height=7></td></tr><tr><td fixWIDTH=100 align=left>&$342;</td><td fixWIDTH=195 align=left height=16>", cl.getLeaderName(), "</td></tr><tr><td height=7></td></tr><tr><td height=7></td></tr><tr><td fixWIDTH=100 align=left>&$571;</td><td fixWIDTH=195 align=left height=16>", cl.getAllyName() != null ? cl.getAllyName() : "", "</td></tr></table></td><td fixWIDTH=5></td></tr><tr><td height=10></td></tr></table><img src=\"L2UI.squareblank\" width=\"1\" height=\"5\"><img src=\"L2UI.squaregray\" width=\"610\" height=\"1\"><img src=\"L2UI.squareblank\" width=\"1\" height=\"5\"><BR> &$1322;<TABLE border=0 cellspacing=0 cellpadding=0 width=610><TR><TD fixWIDTH=5></td><TD fixWIDTH=600>");
                for (L2ClanMember member : cl.getMembers()) {
                    html.append("<A action=\"bypass _bbscustom;msgnew;private;").append(member.getName()).append("\">").append(member.getName()).append("</A> (").append(L2World.getInstance().getPlayer(member.getName()) != null ? "&$1006;" : "&$1007;").append(") &nbsp;");
                }
                html.append("</TD><TD fixWIDTH=5></td></TR></TABLE></center><br> <br></body></html>");
                this.separateAndSend(html.toString(), activeChar);
            }
        }
    }

    private void showMsgEdit(L2PcInstance activeChar, String msgType, int clanId) {
        StringBuilder html = new StringBuilder(2000).append("<html><body><br><br><table border=0 width=610><tr><td width=10></td><td width=600 align=left>").append(this.getHeaderTree(msgType, clanId)).append("</td></tr></table><img src=\"L2UI.squareblank\" width=\"1\" height=\"10\"><center><table border=0 cellspacing=0 cellpadding=0><tr><td width=610><img src=\"sek.cbui355\" width=\"610\" height=\"1\"></td></tr></table><table fixwidth=610 border=0 cellspacing=0 cellpadding=0><tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr><tr><td><img src=\"l2ui.mini_logo\" width=5 height=1></td><td align=center FIXWIDTH=60 height=29 valign=top>&$427;</td><td align=center FIXWIDTH=540><MultiEdit var=\"Content\" width=540 height=300></td><td><img src=\"l2ui.mini_logo\" width=5 height=1></td></tr><tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr></table><img src=\"L2UI.squareblank\" width=\"1\" height=\"5\"><img src=\"L2UI.squaregray\" width=\"610\" height=\"1\"><img src=\"L2UI.squareblank\" width=\"1\" height=\"5\"><table fixwidth=610 border=0 cellspacing=0 cellpadding=0><tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr><tr><td><img src=\"l2ui.mini_logo\" width=5 height=1></td><td align=center FIXWIDTH=60 height=29>&nbsp;</td><td align=center FIXWIDTH=70><button value=\"&$424;\" action=\"Write Clan ").append(msgType).append(' ').append(clanId).append(" Content Content Content\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=21 fore=\"L2UI_CT1.BUTTON_DF\"></td><td align=center FIXWIDTH=70><button value=\"&$425;\" action=\"bypass _bbsclan_clanadmin;").append(msgType.equals("comment") ? "delcomm" : "delanno").append(';').append(clanId).append("\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=21 fore=\"L2UI_CT1.BUTTON_DF\" ></td>&nbsp;<td align=center FIXWIDTH=70><button value=\"&$141;\" action=\"bypass _bbsclan_clanhome\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=21 fore=\"L2UI_CT1.BUTTON_DF\"></td><td align=center FIXWIDTH=330>&nbsp;</td><td><img src=\"l2ui.mini_logo\" width=5 height=1></td></tr></table></center></body></html>");
        this.separateAndSend(html.toString(), activeChar);
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
        if (activeChar == null) {
            return;
        }
        if (ar1.equals("Set")) {
            activeChar.getClan().setNotice(ar4);
            this.parsecmd("_bbsclan_clanhome;" + activeChar.getClan().getClanId(), activeChar);
        }
        if (ar1.equals("comment") || ar1.equals("announce")) {
            this.setMsgData(ar1, Integer.parseInt(ar2), ar3);
            this.parsecmd("_bbsclan_clanhome", activeChar);
        } else {
            ShowBoard sb = new ShowBoard("<html><body><br><br><center>\u30b3\u30de\u30f3\u30c9\uff1a " + ar1 + " \u306f\u672a\u5b9f\u88c5\u3067\u3059</center><br><br></body></html>", "101");
            activeChar.sendPacket(sb);
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMsgData(String msgType, int clanId) {
        File file = new File(Config.DATAPACK_ROOT + "/data/clans/" + msgType + "_" + clanId + ".txt");
        BufferedReader lnr = null;
        StringBuilder MsgData = new StringBuilder(256);
        try {
            String line = null;
            lnr = Util.utf8BufferedReader(file);
            while ((line = lnr.readLine()) != null) {
                MsgData.append(line);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return MsgData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMsgData(String msgType, int clanId, String MsgData) {
        File file = new File(Config.DATAPACK_ROOT + "/data/clans/" + msgType + "_" + clanId + ".txt");
        try {
            file.createNewFile();
            UTF8StreamWriter save = Util.utf8StreamWriter(file);
            MsgData = MsgData.replace("\r\n", "<br1>\r\n");
            save.write(MsgData);
            save.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getHeaderTree(String msgType, int clanId) {
        String html = "";
        if (msgType.equals("comment")) {
            html = "<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanhome;" + clanId + "\"> &$802; </a>&nbsp;>&nbsp;" + "<a action=\"bypass _bbsclan_clanadmin;newcomm;" + clanId + "\"> &$423;&$424;";
        } else if (msgType.equals("announce")) {
            html = "<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanhome;" + clanId + "\"> &$802; </a>&nbsp;>&nbsp;" + "<a action=\"bypass _bbsclan_clanadmin;newanno;" + clanId + "\"> &$328;&$424;";
        }
        return html;
    }

    private static class SingletonHolder {
        protected static final ClanBBSManager _instance = new ClanBBSManager();

        private SingletonHolder() {
        }
    }
}

