/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.type.L2EtcItemType;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PetDataTable {
    private static Logger _log = Logger.getLogger(L2PetInstance.class.getName());
    private static TIntObjectHashMap<L2PetData> _petTable;

    public static PetDataTable getInstance() {
        return SingletonHolder._instance;
    }

    private PetDataTable() {
        _petTable = new TIntObjectHashMap();
        this.load();
    }

    public void load() {
        _petTable.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/stats/npc/PetData.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse PetData.xml file: " + e.getMessage(), e);
            }
            Node n = doc.getFirstChild();
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!d.getNodeName().equals("pet")) continue;
                int npcId = Integer.parseInt(d.getAttributes().getNamedItem("id").getNodeValue());
                L2PetData data = new L2PetData();
                for (Node p = d.getFirstChild(); p != null; p = p.getNextSibling()) {
                    Node s;
                    if (p.getNodeName().equals("set")) {
                        NamedNodeMap attrs = p.getAttributes();
                        String type = attrs.getNamedItem("name").getNodeValue();
                        if ("food".equals(type)) {
                            String[] values = attrs.getNamedItem("val").getNodeValue().split(";");
                            int[] food = new int[values.length];
                            for (int i = 0; i < values.length; ++i) {
                                food[i] = Integer.parseInt(values[i]);
                            }
                            data.set_food(food);
                            continue;
                        }
                        if ("load".equals(type)) {
                            data.set_load(Integer.parseInt(attrs.getNamedItem("val").getNodeValue()));
                            continue;
                        }
                        if (!"hungry_limit".equals(type)) continue;
                        data.set_hungry_limit(Integer.parseInt(attrs.getNamedItem("val").getNodeValue()));
                        continue;
                    }
                    if (p.getNodeName().equals("skills")) {
                        for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                            if (!s.getNodeName().equals("skill")) continue;
                            NamedNodeMap attrs = s.getAttributes();
                            int skillId = Integer.parseInt(attrs.getNamedItem("skillId").getNodeValue());
                            int skillLvl = Integer.parseInt(attrs.getNamedItem("skillLvl").getNodeValue());
                            int minLvl = Integer.parseInt(attrs.getNamedItem("minLvl").getNodeValue());
                            data.addNewSkill(skillId, skillLvl, minLvl);
                        }
                        continue;
                    }
                    if (!p.getNodeName().equals("stats")) continue;
                    for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                        if (!s.getNodeName().equals("stat")) continue;
                        int level = Integer.parseInt(s.getAttributes().getNamedItem("level").getNodeValue());
                        L2PetLevelData stat = new L2PetLevelData();
                        for (Node bean = s.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                            if (!bean.getNodeName().equals("set")) continue;
                            NamedNodeMap attrs = bean.getAttributes();
                            String type = attrs.getNamedItem("name").getNodeValue();
                            String value = attrs.getNamedItem("val").getNodeValue();
                            if ("max_meal".equals(type)) {
                                stat.setPetMaxFeed(Integer.parseInt(value));
                                continue;
                            }
                            if ("exp".equals(type)) {
                                stat.setPetMaxExp(Long.parseLong(value));
                                continue;
                            }
                            if ("get_exp_type".equals(type)) {
                                stat.setOwnerExpTaken(Integer.parseInt(value));
                                continue;
                            }
                            if ("consume_meal_in_battle".equals(type)) {
                                stat.setPetFeedBattle(Integer.parseInt(value));
                                continue;
                            }
                            if ("consume_meal_in_normal".equals(type)) {
                                stat.setPetFeedNormal(Integer.parseInt(value));
                                continue;
                            }
                            if ("org_pattack".equals(type)) {
                                stat.setPetPAtk(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_pdefend".equals(type)) {
                                stat.setPetPDef(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_mattack".equals(type)) {
                                stat.setPetMAtk(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_mdefend".equals(type)) {
                                stat.setPetMDef(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_hp".equals(type)) {
                                stat.setPetMaxHP(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_mp".equals(type)) {
                                stat.setPetMaxMP(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_hp_regen".equals(type)) {
                                stat.setPetRegenHP(Float.parseFloat(value));
                                continue;
                            }
                            if ("org_mp_regen".equals(type)) {
                                stat.setPetRegenMP(Float.parseFloat(value));
                                continue;
                            }
                            if ("soulshot_count".equals(type)) {
                                stat.setPetSoulShot((short)Integer.parseInt(value));
                                continue;
                            }
                            if (!"spiritshot_count".equals(type)) continue;
                            stat.setPetSpiritShot((short)Integer.parseInt(value));
                        }
                        data.addNewStat(stat, level);
                    }
                }
                _petTable.put(npcId, (Object)data);
            }
        } else {
            _log.warning("Not found PetData.xml");
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _petTable.size() + " Pets.");
    }

    public L2PetLevelData getPetLevelData(int petID, int petLevel) {
        return ((L2PetData)_petTable.get(petID)).getPetLevelData(petLevel);
    }

    public L2PetData getPetData(int petID) {
        if (!_petTable.contains(petID)) {
            _log.info("Missing pet data for npcid: " + petID);
        }
        return (L2PetData)_petTable.get(petID);
    }

    public int getPetMinLevel(int petID) {
        return ((L2PetData)_petTable.get(petID)).getMinLevel();
    }

    public static boolean isWolf(int npcId) {
        return npcId == 12077;
    }

    public static boolean isEvolvedWolf(int npcId) {
        return npcId == 16030 || npcId == 16037 || npcId == 16025 || npcId == 16041 || npcId == 16042;
    }

    public static boolean isSinEater(int npcId) {
        return npcId == 12564;
    }

    public static boolean isHatchling(int npcId) {
        return npcId > 12310 && npcId < 12314;
    }

    public static boolean isStrider(int npcId) {
        return npcId > 12525 && npcId < 12529 || npcId > 16037 && npcId < 16041 || npcId == 16068;
    }

    public static boolean isWyvern(int npcId) {
        return npcId == 12621;
    }

    public static boolean isBaby(int npcId) {
        return npcId > 12779 && npcId < 12783;
    }

    public static boolean isImprovedBaby(int npcId) {
        return npcId > 16033 && npcId < 16037;
    }

    public static boolean isPetFood(int itemId) {
        switch (itemId) {
            case 2515: 
            case 4038: 
            case 5168: 
            case 5169: 
            case 6316: 
            case 7582: 
            case 9668: 
            case 10425: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static int[] getFoodItemId(int npcId) {
        switch (npcId) {
            case 12077: 
            case 12564: {
                return new int[]{2515};
            }
            case 16025: 
            case 16030: 
            case 16037: 
            case 16041: 
            case 16042: {
                return new int[]{9668};
            }
            case 12311: 
            case 12312: 
            case 12313: {
                return new int[]{4038};
            }
            case 12526: 
            case 12527: 
            case 12528: 
            case 16038: 
            case 16039: 
            case 16040: 
            case 16068: {
                return new int[]{5168, 5169};
            }
            case 12621: {
                return new int[]{6316};
            }
            case 12780: 
            case 12781: 
            case 12782: {
                return new int[]{7582};
            }
            case 16034: 
            case 16035: 
            case 16036: {
                return new int[]{10425};
            }
        }
        return new int[]{0};
    }

    public static boolean isPetItem(int itemId) {
        L2Item item = ItemTable.getInstance().getTemplate(itemId);
        return item != null && item.getItemType() == L2EtcItemType.PET_COLLAR;
    }

    public static int[] getPetItemsByNpc(int npcId) {
        switch (npcId) {
            case 12077: {
                return new int[]{2375};
            }
            case 16025: {
                return new int[]{9882};
            }
            case 16030: {
                return new int[]{10163};
            }
            case 16037: {
                return new int[]{10307};
            }
            case 16041: {
                return new int[]{10426};
            }
            case 16042: {
                return new int[]{10611};
            }
            case 12564: {
                return new int[]{4425};
            }
            case 12311: 
            case 12312: 
            case 12313: {
                return new int[]{3500, 3501, 3502};
            }
            case 12526: 
            case 12527: 
            case 12528: 
            case 16038: 
            case 16039: 
            case 16040: 
            case 16068: {
                return new int[]{4422, 4423, 4424, 10308, 10309, 10310, 14819};
            }
            case 12621: {
                return new int[]{8663};
            }
            case 12780: 
            case 12781: 
            case 12782: {
                return new int[]{6648, 6649, 6650};
            }
            case 16034: 
            case 16035: 
            case 16036: {
                return new int[]{10311, 10312, 10313};
            }
        }
        return new int[]{0};
    }

    public static boolean isMountable(int npcId) {
        return npcId == 12526 || npcId == 12527 || npcId == 12528 || npcId == 12621 || npcId == 16037 || npcId == 16041 || npcId == 16042 || npcId == 16038 || npcId == 16039 || npcId == 16040 || npcId == 16068;
    }

    public static void main(String ... s) {
        PetDataTable.getInstance();
    }

    private static class SingletonHolder {
        protected static final PetDataTable _instance = new PetDataTable();

        private SingletonHolder() {
        }
    }
}

