/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2SummonItem;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.Scanner;
import java.util.logging.Logger;

public class SummonItemsData {
    protected static final Logger _log = Logger.getLogger(SummonItemsData.class.getName());
    private final TIntObjectHashMap<L2SummonItem> _summonitems = new TIntObjectHashMap();

    public static SummonItemsData getInstance() {
        return SingletonHolder._instance;
    }

    private SummonItemsData() {
        Scanner s;
        try {
            s = new Scanner(new File(Config.DATAPACK_ROOT + "/data/summon_items.csv"));
        }
        catch (Exception e) {
            _log.warning("Summon items data: Can not find '" + Config.DATAPACK_ROOT + "/data/summon_items.csv'");
            return;
        }
        int lineCount = 0;
        while (s.hasNextLine()) {
            ++lineCount;
            String line = s.nextLine();
            if (line.startsWith("#") || line.isEmpty()) continue;
            String[] lineSplit = line.split(";");
            boolean ok = true;
            int itemID = 0;
            int npcID = 0;
            byte summonType = 0;
            int despawn = -1;
            try {
                itemID = Integer.parseInt(lineSplit[0]);
                npcID = Integer.parseInt(lineSplit[1]);
                summonType = Byte.parseByte(lineSplit[2]);
                if (summonType == 0) {
                    despawn = Integer.parseInt(lineSplit[3]);
                }
            }
            catch (Exception e) {
                _log.warning("Summon items data: Error in line " + lineCount + " -> incomplete/invalid data or wrong seperator!");
                _log.warning("\t\t" + line);
                ok = false;
            }
            if (!ok) continue;
            L2SummonItem summonitem = new L2SummonItem(itemID, npcID, summonType, despawn);
            this._summonitems.put(itemID, (Object)summonitem);
        }
        _log.info("Summon items data: Loaded " + this._summonitems.size() + " summon items.");
    }

    public L2SummonItem getSummonItem(int itemId) {
        return (L2SummonItem)this._summonitems.get(itemId);
    }

    public int[] itemIDs() {
        int size = this._summonitems.size();
        int[] result = new int[size];
        int i = 0;
        for (L2SummonItem si : (L2SummonItem[])this._summonitems.values((Object[])new L2SummonItem[0])) {
            result[i++] = si.getItemId();
        }
        return result;
    }

    private static class SingletonHolder {
        protected static final SummonItemsData _instance = new SummonItemsData();

        private SingletonHolder() {
        }
    }
}

