/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Map;
import javolution.util.FastMap;

public class AntiFeedManager {
    public static final int GAME_ID = 0;
    public static final int OLYMPIAD_ID = 1;
    public static final int TVT_ID = 2;
    public static final int L2EVENT_ID = 3;
    private final Map<Integer, Long> _lastDeathTimes = new FastMap().shared();
    private final TIntObjectHashMap<Map<Integer, Connections>> _eventIPs = new TIntObjectHashMap();

    public static final AntiFeedManager getInstance() {
        return SingletonHolder._instance;
    }

    private AntiFeedManager() {
    }

    public final void setLastDeathTime(int objectId) {
        this._lastDeathTimes.put(objectId, System.currentTimeMillis());
    }

    public final boolean check(L2Character attacker, L2Character target) {
        if (!Config.L2JMOD_ANTIFEED_ENABLE) {
            return true;
        }
        if (target == null) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_INTERVAL > 0 && this._lastDeathTimes.containsKey(targetPlayer.getObjectId())) {
            return System.currentTimeMillis() - this._lastDeathTimes.get(targetPlayer.getObjectId()) > (long)Config.L2JMOD_ANTIFEED_INTERVAL;
        }
        if (Config.L2JMOD_ANTIFEED_DUALBOX && attacker != null) {
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer == null) {
                return false;
            }
            L2GameClient targetClient = targetPlayer.getClient();
            L2GameClient attackerClient = attackerPlayer.getClient();
            if (targetClient == null || attackerClient == null || targetClient.isDetached() || attackerClient.isDetached()) {
                return !Config.L2JMOD_ANTIFEED_DISCONNECTED_AS_DUALBOX;
            }
            return !targetClient.getConnectionAddress().equals(attackerClient.getConnectionAddress());
        }
        return true;
    }

    public final void clear() {
        this._lastDeathTimes.clear();
    }

    public final void registerEvent(int eventId) {
        if (!this._eventIPs.containsKey(eventId)) {
            this._eventIPs.put(eventId, (Object)new FastMap());
        }
    }

    public final boolean tryAddPlayer(int eventId, L2PcInstance player, int max) {
        return this.tryAddClient(eventId, player.getClient(), max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAddClient(int eventId, L2GameClient client, int max) {
        Connections conns;
        if (client == null) {
            return false;
        }
        Map event = (Map)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash.intValue());
        limit = limit < 0 ? Integer.MAX_VALUE : limit + max;
        Map map = event;
        synchronized (map) {
            conns = (Connections)event.get(addrHash);
            if (conns == null) {
                conns = new Connections();
                event.put(addrHash, conns);
            }
        }
        return conns.testAndIncrement(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removePlayer(int eventId, L2PcInstance player) {
        L2GameClient client = player.getClient();
        if (client == null) {
            return false;
        }
        Map event = (Map)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        Connections conns = (Connections)event.get(addrHash);
        if (conns == null) {
            return false;
        }
        Map map = event;
        synchronized (map) {
            if (conns.testAndDecrement()) {
                event.remove(addrHash);
            }
        }
        return true;
    }

    public final void onDisconnect(L2GameClient client) {
        if (client == null) {
            return;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        this._eventIPs.forEachValue((TObjectProcedure)new DisconnectProcedure(addrHash));
    }

    public final void clear(int eventId) {
        Map event = (Map)this._eventIPs.get(eventId);
        if (event != null) {
            event.clear();
        }
    }

    public final int getLimit(L2PcInstance player, int max) {
        return this.getLimit(player.getClient(), max);
    }

    public final int getLimit(L2GameClient client, int max) {
        if (client == null) {
            return max;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash.intValue());
        return limit < 0 ? 0 : limit + max;
    }

    private static class SingletonHolder {
        protected static final AntiFeedManager _instance = new AntiFeedManager();

        private SingletonHolder() {
        }
    }

    private static final class DisconnectProcedure
    implements TObjectProcedure<Map<Integer, Connections>> {
        private final Integer _addrHash;

        public DisconnectProcedure(Integer addrHash) {
            this._addrHash = addrHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean execute(Map<Integer, Connections> event) {
            Connections conns = event.get(this._addrHash);
            if (conns != null) {
                Map<Integer, Connections> map = event;
                synchronized (map) {
                    if (conns.testAndDecrement()) {
                        event.remove(this._addrHash);
                    }
                }
            }
            return true;
        }
    }

    private static final class Connections {
        private int _num = 0;

        private Connections() {
        }

        public final synchronized boolean testAndIncrement(int max) {
            if (this._num < max) {
                ++this._num;
                return true;
            }
            return false;
        }

        public final synchronized boolean testAndDecrement() {
            if (this._num > 0) {
                --this._num;
            }
            return this._num == 0;
        }
    }
}

