/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class CastleManager
implements InstanceListManager {
    protected static final Logger _log = Logger.getLogger(CastleManager.class.getName());
    private List<Castle> _castles;
    private static final int[] _castleCirclets = new int[]{0, 6838, 6835, 6839, 6837, 6840, 6834, 6836, 8182, 8183};
    int _castleId = 1;

    public static final CastleManager getInstance() {
        return SingletonHolder._instance;
    }

    private CastleManager() {
    }

    public final int findNearestCastleIndex(L2Object obj) {
        return this.findNearestCastleIndex(obj, Long.MAX_VALUE);
    }

    public final int findNearestCastleIndex(L2Object obj, long maxDistance) {
        int index = this.getCastleIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this.getCastles().size(); ++i) {
                double distance;
                Castle castle = this.getCastles().get(i);
                if (castle == null || !((double)maxDistance > (distance = castle.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public final Castle getCastleById(int castleId) {
        for (Castle temp : this.getCastles()) {
            if (temp.getCastleId() != castleId) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastleByOwner(L2Clan clan) {
        for (Castle temp : this.getCastles()) {
            if (temp.getOwnerId() != clan.getClanId()) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(String name) {
        name = name.trim();
        for (Castle temp : this.getCastles()) {
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(int x, int y, int z) {
        for (Castle temp : this.getCastles()) {
            if (!temp.checkIfInZone(x, y, z)) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(L2Object activeObject) {
        return this.getCastle(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getCastleIndex(int castleId) {
        for (int i = 0; i < this.getCastles().size(); ++i) {
            Castle castle = this.getCastles().get(i);
            if (castle == null || castle.getCastleId() != castleId) continue;
            return i;
        }
        return -1;
    }

    public final int getCastleIndex(L2Object activeObject) {
        return this.getCastleIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getCastleIndex(int x, int y, int z) {
        for (int i = 0; i < this.getCastles().size(); ++i) {
            Castle castle = this.getCastles().get(i);
            if (castle == null || !castle.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public final List<Castle> getCastles() {
        if (this._castles == null) {
            this._castles = new FastList();
        }
        return this._castles;
    }

    public final void validateTaxes(int sealStrifeOwner) {
        int maxTax;
        switch (sealStrifeOwner) {
            case 1: {
                maxTax = 5;
                break;
            }
            case 2: {
                maxTax = 25;
                break;
            }
            default: {
                maxTax = 15;
            }
        }
        for (Castle castle : this._castles) {
            if (castle.getTaxPercent() <= maxTax) continue;
            castle.setTaxPercent(maxTax);
        }
    }

    public int getCirclet() {
        return this.getCircletByCastleId(this._castleId);
    }

    public int getCircletByCastleId(int castleId) {
        if (castleId > 0 && castleId < 10) {
            return _castleCirclets[castleId];
        }
        return 0;
    }

    public void removeCirclet(L2Clan clan, int castleId) {
        for (L2ClanMember member : clan.getMembers()) {
            this.removeCirclet(member, castleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCirclet(L2ClanMember member, int castleId) {
        if (member == null) {
            return;
        }
        L2PcInstance player = member.getPlayerInstance();
        int circletId = this.getCircletByCastleId(castleId);
        if (circletId != 0) {
            if (player != null) {
                try {
                    L2ItemInstance circlet = player.getInventory().getItemByItemId(circletId);
                    if (circlet != null) {
                        if (circlet.isEquipped()) {
                            player.getInventory().unEquipItemInSlot(circlet.getLocationSlot());
                        }
                        player.destroyItemByItemId("CastleCircletRemoval", circletId, 1L, player, true);
                    }
                    return;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("DELETE FROM items WHERE owner_id = ? and item_id = ?");
                statement.setInt(1, member.getObjectId());
                statement.setInt(2, circletId);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed to remove castle circlets offline for player " + member.getName() + ": " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadInstances() {
        _log.info("Initializing CastleManager");
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id FROM castle ORDER BY id");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.getCastles().add(new Castle(rs.getInt("id")));
            }
            rs.close();
            statement.close();
            _log.info("Loaded: " + this.getCastles().size() + " castles");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleData(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Castle castle : this._castles) {
            castle.activateInstance();
        }
    }

    private static class SingletonHolder {
        protected static final CastleManager _instance = new CastleManager();

        private SingletonHolder() {
        }
    }
}

