/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.entity.Fort;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class FortManager
implements InstanceListManager {
    protected static final Logger _log = Logger.getLogger(FortManager.class.getName());
    private List<Fort> _forts;

    public static final FortManager getInstance() {
        return SingletonHolder._instance;
    }

    private FortManager() {
    }

    public final int findNearestFortIndex(L2Object obj) {
        return this.findNearestFortIndex(obj, Long.MAX_VALUE);
    }

    public final int findNearestFortIndex(L2Object obj, long maxDistance) {
        int index = this.getFortIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this.getForts().size(); ++i) {
                double distance;
                Fort fort = this.getForts().get(i);
                if (fort == null || !((double)maxDistance > (distance = fort.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public final Fort getFortById(int fortId) {
        for (Fort f : this.getForts()) {
            if (f.getFortId() != fortId) continue;
            return f;
        }
        return null;
    }

    public final Fort getFortByOwner(L2Clan clan) {
        for (Fort f : this.getForts()) {
            if (f.getOwnerClan() != clan) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(String name) {
        for (Fort f : this.getForts()) {
            if (!f.getName().equalsIgnoreCase(name.trim())) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(int x, int y, int z) {
        for (Fort f : this.getForts()) {
            if (!f.checkIfInZone(x, y, z)) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(L2Object activeObject) {
        return this.getFort(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getFortIndex(int fortId) {
        for (int i = 0; i < this.getForts().size(); ++i) {
            Fort fort = this.getForts().get(i);
            if (fort == null || fort.getFortId() != fortId) continue;
            return i;
        }
        return -1;
    }

    public final int getFortIndex(L2Object activeObject) {
        return this.getFortIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getFortIndex(int x, int y, int z) {
        for (int i = 0; i < this.getForts().size(); ++i) {
            Fort fort = this.getForts().get(i);
            if (fort == null || !fort.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public final List<Fort> getForts() {
        if (this._forts == null) {
            this._forts = new FastList();
        }
        return this._forts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadInstances() {
        _log.info("Initializing FortManager");
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id FROM fort ORDER BY id");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.getForts().add(new Fort(rs.getInt("id")));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFortData(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("Loaded: " + this.getForts().size() + " fortress");
        for (Fort fort : this.getForts()) {
            fort.getSiege().getSiegeGuardManager().loadSiegeGuard();
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Fort fort : this._forts) {
            fort.activateInstance();
        }
    }

    private static class SingletonHolder {
        protected static final FortManager _instance = new FortManager();

        private SingletonHolder() {
        }
    }
}

