/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.GlobalVariablesManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.quest.Quest;
import java.util.Calendar;
import java.util.logging.Logger;

public class GraciaSeedsManager {
    private static final Logger _log = Logger.getLogger(GraciaSeedsManager.class.getName());
    public static String qn = "EnergySeeds";
    private static final byte SOITYPE = 2;
    private static final byte SOATYPE = 3;
    private static final byte SODTYPE = 1;
    private int _SoDTiatKilled = 0;
    private int _SoDState = 1;
    private Calendar _SoDLastStateChangeDate;

    private GraciaSeedsManager() {
        _log.info(this.getClass().getSimpleName() + ": Initializing");
        this._SoDLastStateChangeDate = Calendar.getInstance();
        this.loadData();
        this.handleSodStages();
    }

    public void saveData(byte seedType) {
        switch (seedType) {
            case 1: {
                GlobalVariablesManager.getInstance().storeVariable("SoDState", String.valueOf(this._SoDState));
                GlobalVariablesManager.getInstance().storeVariable("SoDTiatKilled", String.valueOf(this._SoDTiatKilled));
                GlobalVariablesManager.getInstance().storeVariable("SoDLSCDate", String.valueOf(this._SoDLastStateChangeDate.getTimeInMillis()));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                _log.warning("GraciaSeedManager: Unknown SeedType in SaveData: " + seedType);
            }
        }
    }

    public void loadData() {
        if (GlobalVariablesManager.getInstance().isVariableStored("SoDState")) {
            this._SoDState = Integer.parseInt(GlobalVariablesManager.getInstance().getStoredVariable("SoDState"));
            this._SoDTiatKilled = Integer.parseInt(GlobalVariablesManager.getInstance().getStoredVariable("SoDTiatKilled"));
            this._SoDLastStateChangeDate.setTimeInMillis(Long.parseLong(GlobalVariablesManager.getInstance().getStoredVariable("SoDLSCDate")));
        } else {
            this.saveData((byte)1);
        }
    }

    private void handleSodStages() {
        switch (this._SoDState) {
            case 1: {
                break;
            }
            case 2: {
                long timePast = System.currentTimeMillis() - this._SoDLastStateChangeDate.getTimeInMillis();
                if (timePast >= Config.SOD_STAGE_2_LENGTH) {
                    this.setSoDState(1, true);
                    break;
                }
                ThreadPoolManager.getInstance().scheduleEffect(new Runnable(){

                    @Override
                    public void run() {
                        GraciaSeedsManager.this.setSoDState(1, true);
                        Quest esQuest = QuestManager.getInstance().getQuest(qn);
                        if (esQuest == null) {
                            _log.warning("GraciaSeedManager: missing EnergySeeds Quest!");
                        } else {
                            esQuest.notifyEvent("StopSoDAi", null, null);
                        }
                    }
                }, Config.SOD_STAGE_2_LENGTH - timePast);
                break;
            }
            case 3: {
                this.setSoDState(1, true);
                break;
            }
            default: {
                _log.warning("GraciaSeedManager: Unknown Seed of Destruction state(" + this._SoDState + ")! ");
            }
        }
    }

    public void increaseSoDTiatKilled() {
        if (this._SoDState == 1) {
            ++this._SoDTiatKilled;
            if (this._SoDTiatKilled >= Config.SOD_TIAT_KILL_COUNT) {
                this.setSoDState(2, false);
            }
            this.saveData((byte)1);
            Quest esQuest = QuestManager.getInstance().getQuest(qn);
            if (esQuest == null) {
                _log.warning("GraciaSeedManager: missing EnergySeeds Quest!");
            } else {
                esQuest.notifyEvent("StartSoDAi", null, null);
            }
        }
    }

    public int getSoDTiatKilled() {
        return this._SoDTiatKilled;
    }

    public void setSoDState(int value, boolean doSave) {
        _log.info("GraciaSeedManager: New Seed of Destruction state -> " + value + ".");
        this._SoDLastStateChangeDate.setTimeInMillis(System.currentTimeMillis());
        this._SoDState = value;
        if (this._SoDState == 1) {
            this._SoDTiatKilled = 0;
        }
        this.handleSodStages();
        if (doSave) {
            this.saveData((byte)1);
        }
    }

    public long getSoDTimeForNextStateChange() {
        switch (this._SoDState) {
            case 1: {
                return -1L;
            }
            case 2: {
                return this._SoDLastStateChangeDate.getTimeInMillis() + Config.SOD_STAGE_2_LENGTH - System.currentTimeMillis();
            }
            case 3: {
                return -1L;
            }
        }
        return -1L;
    }

    public Calendar getSoDLastStateChangeDate() {
        return this._SoDLastStateChangeDate;
    }

    public int getSoDState() {
        return this._SoDState;
    }

    public static final GraciaSeedsManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GraciaSeedsManager _instance = new GraciaSeedsManager();

        private SingletonHolder() {
        }
    }
}

