/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameAddPlayer;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangeTeam;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameRemovePlayer;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.List;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class HandysBlockCheckerManager {
    private static ArenaParticipantsHolder[] _arenaPlayers;
    private static TIntIntHashMap _arenaVotes;
    private static FastMap<Integer, Boolean> _arenaStatus;
    private static FastList<Integer> _registrationPenalty;

    public synchronized int getArenaVotes(int arenaId) {
        return _arenaVotes.get(arenaId);
    }

    public synchronized void increaseArenaVotes(int arena) {
        ArenaParticipantsHolder holder;
        int newVotes = _arenaVotes.get(arena) + 1;
        if (newVotes > (holder = _arenaPlayers[arena]).getAllPlayers().size() / 2 && !holder.getEvent().isStarted()) {
            this.clearArenaVotes(arena);
            if (holder.getBlueTeamSize() == 0 || holder.getRedTeamSize() == 0) {
                return;
            }
            if (Config.HBCE_FAIR_PLAY) {
                holder.checkAndShuffle();
            }
            ThreadPoolManager.getInstance().executeTask(new BlockCheckerEngine.StartEvent(holder.getEvent()));
        } else {
            _arenaVotes.put(arena, newVotes);
        }
    }

    public synchronized void clearArenaVotes(int arena) {
        _arenaVotes.put(arena, 0);
    }

    private HandysBlockCheckerManager() {
        if (_arenaStatus == null) {
            _arenaStatus = new FastMap();
            _arenaStatus.put((Object)0, (Object)false);
            _arenaStatus.put((Object)1, (Object)false);
            _arenaStatus.put((Object)2, (Object)false);
            _arenaStatus.put((Object)3, (Object)false);
        }
    }

    public ArenaParticipantsHolder getHolder(int arena) {
        return _arenaPlayers[arena];
    }

    public void startUpParticipantsQueue() {
        _arenaPlayers = new ArenaParticipantsHolder[4];
        for (int i = 0; i < 4; ++i) {
            HandysBlockCheckerManager._arenaPlayers[i] = new ArenaParticipantsHolder(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlayerToArena(L2PcInstance player, int arenaId) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arenaId];
        synchronized (arenaParticipantsHolder) {
            boolean isRed;
            for (int i = 0; i < 4; ++i) {
                if (!_arenaPlayers[i].getAllPlayers().contains(player)) continue;
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_MATCH_WAITING_LIST);
                msg.addCharName(player);
                player.sendPacket(msg);
                return false;
            }
            if (player.isCursedWeaponEquipped()) {
                player.sendPacket(SystemMessageId.CANNOT_REGISTER_PROCESSING_CURSED_WEAPON);
                return false;
            }
            if (TvTEvent.isPlayerParticipant(player.getObjectId()) || player.isInOlympiadMode()) {
                player.sendMessage("\u4ed6\u306e\u30a4\u30d9\u30f3\u30c8\u306b\u7533\u3057\u8fbc\u307f\u4e2d\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (OlympiadManager.getInstance().isRegistered(player)) {
                OlympiadManager.getInstance().unRegisterNoble(player);
                player.sendPacket(SystemMessageId.COLISEUM_OLYMPIAD_KRATEIS_APPLICANTS_CANNOT_PARTICIPATE);
            }
            if (_registrationPenalty.contains((Object)player.getObjectId())) {
                player.sendPacket(SystemMessageId.CANNOT_REQUEST_REGISTRATION_10_SECS_AFTER);
                return false;
            }
            if (holder.getBlueTeamSize() < holder.getRedTeamSize()) {
                holder.addPlayer(player, 1);
                isRed = false;
            } else {
                holder.addPlayer(player, 0);
                isRed = true;
            }
            holder.broadCastPacketToTeam(new ExCubeGameAddPlayer(player, isRed));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(L2PcInstance player, int arenaId, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arenaId];
        synchronized (arenaParticipantsHolder) {
            Integer objId;
            int teamSize;
            boolean isRed = team == 0;
            holder.removePlayer(player, team);
            holder.broadCastPacketToTeam(new ExCubeGameRemovePlayer(player, isRed));
            int n = teamSize = isRed ? holder.getRedTeamSize() : holder.getBlueTeamSize();
            if (teamSize == 0) {
                holder.getEvent().endEventAbnormally();
            }
            if (!_registrationPenalty.contains((Object)(objId = Integer.valueOf(player.getObjectId())))) {
                _registrationPenalty.add((Object)objId);
            }
            this.schedulePenaltyRemoval(objId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePlayerToTeam(L2PcInstance player, int arena, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arena];
        synchronized (arenaParticipantsHolder) {
            boolean isFromRed = holder._redPlayers.contains(player);
            if (isFromRed && holder.getBlueTeamSize() == 6) {
                player.sendPacket(SystemMessageId.CANNOT_REGISTER_CAUSE_QUEUE_FULL);
                return;
            }
            if (!isFromRed && holder.getRedTeamSize() == 6) {
                player.sendPacket(SystemMessageId.CANNOT_REGISTER_CAUSE_QUEUE_FULL);
                return;
            }
            int futureTeam = isFromRed ? 1 : 0;
            holder.addPlayer(player, futureTeam);
            if (isFromRed) {
                holder.removePlayer(player, 0);
            } else {
                holder.removePlayer(player, 1);
            }
            holder.broadCastPacketToTeam(new ExCubeGameChangeTeam(player, isFromRed));
        }
    }

    public synchronized void clearPaticipantQueueByArenaId(int arenaId) {
        _arenaPlayers[arenaId].clearPlayers();
    }

    public boolean arenaIsBeingUsed(int arenaId) {
        if (arenaId < 0 || arenaId > 3) {
            return false;
        }
        return (Boolean)_arenaStatus.get((Object)arenaId);
    }

    public void setArenaBeingUsed(int arenaId) {
        _arenaStatus.put((Object)arenaId, (Object)true);
    }

    public void setArenaFree(int arenaId) {
        _arenaStatus.put((Object)arenaId, (Object)false);
    }

    public void onDisconnect(L2PcInstance player) {
        int arena = player.getBlockCheckerArena();
        int team = this.getHolder(arena).getPlayerTeam(player);
        HandysBlockCheckerManager.getInstance().removePlayer(player, arena, team);
        if (player.getTeam() > 0) {
            long count;
            player.stopAllEffects();
            player.setTeam(0);
            PcInventory inv = player.getInventory();
            if (inv.getItemByItemId(13787) != null) {
                count = inv.getInventoryItemCount(13787, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
            }
            if (inv.getItemByItemId(13788) != null) {
                count = inv.getInventoryItemCount(13788, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
            }
            player.setInsideZone((byte)0, false);
            player.teleToLocation(-57478 + Rnd.get(-200, 200), -60367 + Rnd.get(-200, 200), -2370);
        }
    }

    public static HandysBlockCheckerManager getInstance() {
        return SingletonHolder._instance;
    }

    private void schedulePenaltyRemoval(int objId) {
        ThreadPoolManager.getInstance().scheduleGeneral(new PenaltyRemove(objId), 10000L);
    }

    static {
        _arenaVotes = new TIntIntHashMap();
        _registrationPenalty = new FastList();
    }

    private class PenaltyRemove
    implements Runnable {
        Integer objectId;

        public PenaltyRemove(Integer id) {
            this.objectId = id;
        }

        @Override
        public void run() {
            try {
                _registrationPenalty.remove((Object)this.objectId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ArenaParticipantsHolder {
        int _arena;
        List<L2PcInstance> _redPlayers;
        List<L2PcInstance> _bluePlayers;
        BlockCheckerEngine _engine;

        public ArenaParticipantsHolder(int arena) {
            this._arena = arena;
            this._redPlayers = new ArrayList<L2PcInstance>(6);
            this._bluePlayers = new ArrayList<L2PcInstance>(6);
            this._engine = new BlockCheckerEngine(this, this._arena);
        }

        public List<L2PcInstance> getRedPlayers() {
            return this._redPlayers;
        }

        public List<L2PcInstance> getBluePlayers() {
            return this._bluePlayers;
        }

        public ArrayList<L2PcInstance> getAllPlayers() {
            ArrayList<L2PcInstance> all = new ArrayList<L2PcInstance>(12);
            all.addAll(this._redPlayers);
            all.addAll(this._bluePlayers);
            return all;
        }

        public void addPlayer(L2PcInstance player, int team) {
            if (team == 0) {
                this._redPlayers.add(player);
            } else {
                this._bluePlayers.add(player);
            }
        }

        public void removePlayer(L2PcInstance player, int team) {
            if (team == 0) {
                this._redPlayers.remove(player);
            } else {
                this._bluePlayers.remove(player);
            }
        }

        public int getPlayerTeam(L2PcInstance player) {
            if (this._redPlayers.contains(player)) {
                return 0;
            }
            if (this._bluePlayers.contains(player)) {
                return 1;
            }
            return -1;
        }

        public int getRedTeamSize() {
            return this._redPlayers.size();
        }

        public int getBlueTeamSize() {
            return this._bluePlayers.size();
        }

        public void broadCastPacketToTeam(L2GameServerPacket packet) {
            for (L2PcInstance p : this._redPlayers) {
                p.sendPacket(packet);
            }
            for (L2PcInstance p : this._bluePlayers) {
                p.sendPacket(packet);
            }
        }

        public void clearPlayers() {
            this._redPlayers.clear();
            this._bluePlayers.clear();
        }

        public BlockCheckerEngine getEvent() {
            return this._engine;
        }

        public void updateEvent() {
            this._engine.updatePlayersOnStart(this);
        }

        private void checkAndShuffle() {
            block3: {
                int blueSize;
                int redSize;
                block2: {
                    redSize = this._redPlayers.size();
                    if (redSize <= (blueSize = this._bluePlayers.size()) + 1) break block2;
                    this.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_ADJUSTED_BECAUSE_WRONG_POPULATION_RATIO));
                    int needed = redSize - (blueSize + 1);
                    for (int i = 0; i < needed + 1; ++i) {
                        L2PcInstance plr = this._redPlayers.get(i);
                        if (plr == null) continue;
                        HandysBlockCheckerManager.this.changePlayerToTeam(plr, this._arena, 1);
                    }
                    break block3;
                }
                if (blueSize <= redSize + 1) break block3;
                this.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_ADJUSTED_BECAUSE_WRONG_POPULATION_RATIO));
                int needed = blueSize - (redSize + 1);
                for (int i = 0; i < needed + 1; ++i) {
                    L2PcInstance plr = this._bluePlayers.get(i);
                    if (plr == null) continue;
                    HandysBlockCheckerManager.this.changePlayerToTeam(plr, this._arena, 0);
                }
            }
        }
    }

    private static class SingletonHolder {
        private static HandysBlockCheckerManager _instance = new HandysBlockCheckerManager();

        private SingletonHolder() {
        }
    }
}

