/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.form.ZoneCuboid;
import com.l2jserver.gameserver.model.zone.form.ZoneCylinder;
import com.l2jserver.gameserver.model.zone.form.ZoneNPoly;
import com.l2jserver.gameserver.model.zone.type.L2ArenaZone;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.model.zone.type.L2RespawnZone;
import com.l2jserver.util.file.filter.XMLFilter;
import gnu.trove.procedure.TObjectProcedure;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ZoneManager {
    private static final Logger _log = Logger.getLogger(ZoneManager.class.getName());
    private final Map<Class<? extends L2ZoneType>, Map<Integer, ? extends L2ZoneType>> _classZones = new FastMap();
    private int _lastDynamicId = 300000;
    private List<L2ItemInstance> _debugItems;

    public static final ZoneManager getInstance() {
        return SingletonHolder._instance;
    }

    private ZoneManager() {
        _log.info("Initializing ZoneManager");
        this.load();
    }

    public void reload() {
        int count = 0;
        L2WorldRegion[][] worldRegions = L2World.getInstance().getAllWorldRegions();
        for (int x = 0; x < worldRegions.length; ++x) {
            for (int y = 0; y < worldRegions[x].length; ++y) {
                worldRegions[x][y].getZones().clear();
                ++count;
            }
        }
        GrandBossManager.getInstance().getZones().clear();
        _log.info("Removed zones in " + count + " regions.");
        this.load();
        L2World.getInstance().forEachObject(new ForEachCharacterRevalidateZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        _log.info("Loading zones...");
        this._classZones.clear();
        L2WorldRegion[][] worldRegions = L2World.getInstance().getAllWorldRegions();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File dir = new File(Config.DATAPACK_ROOT, "data/zones");
            if (!dir.exists()) {
                _log.config("Dir " + dir.getAbsolutePath() + " not exists");
                return;
            }
            File[] files = dir.listFiles(new XMLFilter());
            FastList hash = new FastList(files.length);
            for (File f : files) {
                if ("zone.xml".equalsIgnoreCase(f.getName())) {
                    hash.addFirst((Object)f);
                    continue;
                }
                hash.add((Object)f);
            }
            for (File f : hash) {
                Document doc = factory.newDocumentBuilder().parse(f);
                for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                    NamedNodeMap attrs;
                    Node attribute;
                    if (!"list".equalsIgnoreCase(n.getNodeName()) || (attribute = (attrs = n.getAttributes()).getNamedItem("enabled")) != null && !Boolean.parseBoolean(attribute.getNodeValue())) continue;
                    for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        L2ZoneType temp;
                        String zoneName;
                        int zoneId;
                        block39: {
                            Class<?> newZone;
                            if (!"zone".equalsIgnoreCase(d.getNodeName())) continue;
                            attrs = d.getAttributes();
                            attribute = attrs.getNamedItem("id");
                            if (attribute != null) {
                                zoneId = Integer.parseInt(attribute.getNodeValue());
                            } else {
                                ++this._lastDynamicId;
                            }
                            attribute = attrs.getNamedItem("name");
                            zoneName = attribute != null ? attribute.getNodeValue() : null;
                            attribute = attrs.getNamedItem("minZ");
                            if (attribute == null) {
                                _log.warning("ZoneData: Missing minZ for zone: " + zoneId + " in file: " + f.getName());
                                continue;
                            }
                            int minZ = Integer.parseInt(attribute.getNodeValue());
                            attribute = attrs.getNamedItem("maxZ");
                            if (attribute == null) {
                                _log.warning("ZoneData: Missing maxZ for zone: " + zoneId + " in file: " + f.getName());
                                continue;
                            }
                            int maxZ = Integer.parseInt(attribute.getNodeValue());
                            attribute = attrs.getNamedItem("type");
                            if (attribute == null) {
                                _log.warning("ZoneData: Missing type for zone: " + zoneId + " in file: " + f.getName());
                                continue;
                            }
                            String zoneType = attribute.getNodeValue();
                            attribute = attrs.getNamedItem("shape");
                            if (attribute == null) {
                                _log.warning("ZoneData: Missing shape for zone: " + zoneId + " in file: " + f.getName());
                                continue;
                            }
                            String zoneShape = attribute.getNodeValue();
                            try {
                                newZone = Class.forName("com.l2jserver.gameserver.model.zone.type.L2" + zoneType);
                            }
                            catch (ClassNotFoundException e) {
                                _log.warning("ZoneData: No such zone type: " + zoneType + " in file: " + f.getName());
                                continue;
                            }
                            Constructor<?> zoneConstructor = newZone.getConstructor(Integer.TYPE);
                            temp = (L2ZoneType)zoneConstructor.newInstance(zoneId);
                            try {
                                int[][] coords = null;
                                FastList rs = FastList.newInstance();
                                try {
                                    for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                                        if (!"node".equalsIgnoreCase(cd.getNodeName())) continue;
                                        attrs = cd.getAttributes();
                                        int[] point = new int[]{Integer.parseInt(attrs.getNamedItem("X").getNodeValue()), Integer.parseInt(attrs.getNamedItem("Y").getNodeValue())};
                                        rs.add((Object)point);
                                    }
                                    coords = (int[][])rs.toArray((Object[])new int[rs.size()][]);
                                }
                                finally {
                                    FastList.recycle((FastList)rs);
                                }
                                if (coords == null || coords.length == 0) {
                                    _log.warning("ZoneData: missing data for zone: " + zoneId + " in both XML and SQL, file: " + f.getName());
                                    continue;
                                }
                                if (zoneShape.equalsIgnoreCase("Cuboid")) {
                                    if (coords.length == 2) {
                                        temp.setZone(new ZoneCuboid(coords[0][0], coords[1][0], coords[0][1], coords[1][1], minZ, maxZ));
                                        break block39;
                                    }
                                    _log.warning("ZoneData: Missing cuboid vertex in sql data for zone: " + zoneId + " in file: " + f.getName());
                                    continue;
                                }
                                if (zoneShape.equalsIgnoreCase("NPoly")) {
                                    if (coords.length > 2) {
                                        int[] aX = new int[coords.length];
                                        int[] aY = new int[coords.length];
                                        for (int i = 0; i < coords.length; ++i) {
                                            aX[i] = coords[i][0];
                                            aY[i] = coords[i][1];
                                        }
                                        temp.setZone(new ZoneNPoly(aX, aY, minZ, maxZ));
                                        break block39;
                                    }
                                    _log.warning("ZoneData: Bad data for zone: " + zoneId + " in file: " + f.getName());
                                    continue;
                                }
                                if (zoneShape.equalsIgnoreCase("Cylinder")) {
                                    attrs = d.getAttributes();
                                    int zoneRad = Integer.parseInt(attrs.getNamedItem("rad").getNodeValue());
                                    if (coords.length == 1 && zoneRad > 0) {
                                        temp.setZone(new ZoneCylinder(coords[0][0], coords[0][1], minZ, maxZ, zoneRad));
                                        break block39;
                                    }
                                    _log.warning("ZoneData: Bad data for zone: " + zoneId + " in file: " + f.getName());
                                    continue;
                                }
                                _log.warning("ZoneData: Unknown shape: " + zoneShape + " in file: " + f.getName());
                                continue;
                            }
                            catch (Exception e) {
                                _log.log(Level.WARNING, "ZoneData: Failed to load zone " + zoneId + " coordinates: " + e.getMessage(), e);
                            }
                        }
                        for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if ("stat".equalsIgnoreCase(cd.getNodeName())) {
                                attrs = cd.getAttributes();
                                String name = attrs.getNamedItem("name").getNodeValue();
                                String val = attrs.getNamedItem("val").getNodeValue();
                                temp.setParameter(name, val);
                                continue;
                            }
                            if ("spawn".equalsIgnoreCase(cd.getNodeName()) && temp instanceof L2ZoneRespawn) {
                                attrs = cd.getAttributes();
                                int spawnX = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                                int spawnY = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                                int spawnZ = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                                Node val = attrs.getNamedItem("type");
                                ((L2ZoneRespawn)temp).parseLoc(spawnX, spawnY, spawnZ, val == null ? null : val.getNodeValue());
                                continue;
                            }
                            if (!"race".equalsIgnoreCase(cd.getNodeName()) || !(temp instanceof L2RespawnZone)) continue;
                            attrs = cd.getAttributes();
                            String race = attrs.getNamedItem("name").getNodeValue();
                            String point = attrs.getNamedItem("point").getNodeValue();
                            ((L2RespawnZone)temp).addRaceRespawnPoint(race, point);
                        }
                        if (this.checkId(zoneId)) {
                            _log.config("Caution: Zone (" + zoneId + ") from file: " + f.getName() + " overrides previos definition.");
                        }
                        if (zoneName != null && !zoneName.isEmpty()) {
                            temp.setName(zoneName);
                        }
                        this.addZone(zoneId, temp);
                        for (int x = 0; x < worldRegions.length; ++x) {
                            for (int y = 0; y < worldRegions[x].length; ++y) {
                                int ax = x - L2World.OFFSET_X << 12;
                                int bx = x + 1 - L2World.OFFSET_X << 12;
                                int ay = y - L2World.OFFSET_Y << 12;
                                int by = y + 1 - L2World.OFFSET_Y << 12;
                                if (!temp.getZone().intersectsRectangle(ax, bx, ay, by)) continue;
                                if (Config.DEBUG) {
                                    _log.info("Zone (" + zoneId + ") added to: " + x + " " + y);
                                }
                                worldRegions[x][y].addZone(temp);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while loading zones.", e);
            return;
        }
        _log.info("Done: loaded " + this._classZones.size() + " zone classes and " + this.getSize() + " zones.");
    }

    public int getSize() {
        int i = 0;
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            i += map.size();
        }
        return i;
    }

    public boolean checkId(int id) {
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            if (!map.containsKey(id)) continue;
            return true;
        }
        return false;
    }

    public <T extends L2ZoneType> void addZone(Integer id, T zone) {
        FastMap map = this._classZones.get(zone.getClass());
        if (map == null) {
            map = new FastMap();
            map.put(id, zone);
            this._classZones.put(zone.getClass(), (Map<Integer, ? extends L2ZoneType>)map);
        } else {
            map.put(id, zone);
        }
    }

    @Deprecated
    public Collection<L2ZoneType> getAllZones() {
        FastList zones = new FastList();
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            zones.addAll(map.values());
        }
        return zones;
    }

    public <T extends L2ZoneType> Collection<T> getAllZones(Class<T> zoneType) {
        return this._classZones.get(zoneType).values();
    }

    public L2ZoneType getZoneById(int id) {
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            if (!map.containsKey(id)) continue;
            return map.get(id);
        }
        return null;
    }

    public <T extends L2ZoneType> T getZoneById(int id, Class<T> zoneType) {
        return (T)this._classZones.get(zoneType).get(id);
    }

    public FastList<L2ZoneType> getZones(L2Object object) {
        return this.getZones(object.getX(), object.getY(), object.getZ());
    }

    public <T extends L2ZoneType> T getZone(L2Object object, Class<T> type) {
        if (object == null) {
            return null;
        }
        return this.getZone(object.getX(), object.getY(), object.getZ(), type);
    }

    public FastList<L2ZoneType> getZones(int x, int y) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        FastList temp = new FastList();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y)) continue;
            temp.add((Object)zone);
        }
        return temp;
    }

    public FastList<L2ZoneType> getZones(int x, int y, int z) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        FastList temp = new FastList();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z)) continue;
            temp.add((Object)zone);
        }
        return temp;
    }

    public <T extends L2ZoneType> T getZone(int x, int y, int z, Class<T> type) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z) || !type.isInstance(zone)) continue;
            return (T)zone;
        }
        return null;
    }

    public final L2ArenaZone getArena(L2Character character) {
        if (character == null) {
            return null;
        }
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2ArenaZone) || !temp.isCharacterInZone(character)) continue;
            return (L2ArenaZone)temp;
        }
        return null;
    }

    public final L2OlympiadStadiumZone getOlympiadStadium(L2Character character) {
        if (character == null) {
            return null;
        }
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2OlympiadStadiumZone) || !temp.isCharacterInZone(character)) continue;
            return (L2OlympiadStadiumZone)temp;
        }
        return null;
    }

    public <T extends L2ZoneType> T getClosestZone(L2Object obj, Class<T> type) {
        Object zone = this.getZone(obj, type);
        if (zone == null) {
            double closestdis = Double.MAX_VALUE;
            for (L2ZoneType l2ZoneType : this._classZones.get(type).values()) {
                double distance = l2ZoneType.getDistanceToZone(obj);
                if (!(distance < closestdis)) continue;
                closestdis = distance;
                zone = l2ZoneType;
            }
        }
        return zone;
    }

    public List<L2ItemInstance> getDebugItems() {
        if (this._debugItems == null) {
            this._debugItems = new FastList();
        }
        return this._debugItems;
    }

    public void clearDebugItems() {
        if (this._debugItems != null) {
            Iterator<L2ItemInstance> it = this._debugItems.iterator();
            while (it.hasNext()) {
                L2ItemInstance item = it.next();
                if (item != null) {
                    item.decayMe();
                }
                it.remove();
            }
        }
    }

    private static class SingletonHolder {
        protected static final ZoneManager _instance = new ZoneManager();

        private SingletonHolder() {
        }
    }

    private final class ForEachCharacterRevalidateZone
    implements TObjectProcedure<L2Object> {
        private ForEachCharacterRevalidateZone() {
        }

        public final boolean execute(L2Object o) {
            if (o instanceof L2Character) {
                ((L2Character)o).revalidateZone(true);
            }
            return true;
        }
    }
}

