/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import javolution.util.FastList;

public class L2DropCategory {
    private FastList<L2DropData> _drops;
    private int _categoryChance;
    private int _categoryBalancedChance;
    private int _categoryType;

    public L2DropCategory(int categoryType) {
        this._categoryType = categoryType;
        this._drops = new FastList(0);
        this._categoryChance = 0;
        this._categoryBalancedChance = 0;
    }

    public void addDropData(L2DropData drop, boolean raid) {
        boolean found = false;
        if (!drop.isQuestDrop()) {
            if (Config.CUSTOM_DROPLIST_TABLE) {
                for (L2DropData d : this._drops) {
                    if (d.getItemId() != drop.getItemId()) continue;
                    d.setMinDrop(drop.getMinDrop());
                    d.setMaxDrop(drop.getMaxDrop());
                    if (d.getChance() != drop.getChance()) {
                        this._categoryChance = (int)((double)this._categoryChance - d.getChance());
                        this._categoryBalancedChance = (int)((double)this._categoryBalancedChance - Math.min(d.getChance() * (double)Config.RATE_DROP_ITEMS, 1000000.0));
                        d.setChance(drop.getChance());
                        this._categoryChance = (int)((double)this._categoryChance + d.getChance());
                        this._categoryBalancedChance = (int)((double)this._categoryBalancedChance + Math.min(d.getChance() * (double)Config.RATE_DROP_ITEMS, 1000000.0));
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                this._drops.add((Object)drop);
                this._categoryChance = (int)((double)this._categoryChance + drop.getChance());
                this._categoryBalancedChance = (int)((double)this._categoryBalancedChance + Math.min(drop.getChance() * (double)(raid ? Config.RATE_DROP_ITEMS_BY_RAID : Config.RATE_DROP_ITEMS), 1000000.0));
            }
        }
    }

    public FastList<L2DropData> getAllDrops() {
        return this._drops;
    }

    public void clearAllDrops() {
        this._drops.clear();
    }

    public boolean isSweep() {
        return this.getCategoryType() == -1;
    }

    public int getCategoryChance() {
        if (this.getCategoryType() >= 0) {
            return this._categoryChance;
        }
        return 1000000;
    }

    public int getCategoryBalancedChance() {
        if (this.getCategoryType() >= 0) {
            return this._categoryBalancedChance;
        }
        return 1000000;
    }

    public int getCategoryType() {
        return this._categoryType;
    }

    public synchronized L2DropData dropSeedAllowedDropsOnly() {
        FastList drops = new FastList();
        int subCatChance = 0;
        for (L2DropData drop : this.getAllDrops()) {
            if (drop.getItemId() != 57 && !Util.contains(SevenSigns.SEAL_STONE_IDS, drop.getItemId())) continue;
            drops.add((Object)drop);
            subCatChance = (int)((double)subCatChance + drop.getChance());
        }
        int randomIndex = Rnd.get(subCatChance);
        int sum = 0;
        for (L2DropData drop : drops) {
            if ((sum = (int)((double)sum + drop.getChance())) <= randomIndex) continue;
            drops.clear();
            drops = null;
            return drop;
        }
        return null;
    }

    public synchronized L2DropData dropOne(boolean raid) {
        int randomIndex = Rnd.get(this.getCategoryBalancedChance());
        int sum = 0;
        for (L2DropData drop : this.getAllDrops()) {
            if ((sum = (int)((double)sum + Math.min(drop.getChance() * (double)(raid ? Config.RATE_DROP_ITEMS_BY_RAID : Config.RATE_DROP_ITEMS), 1000000.0))) < randomIndex) continue;
            return drop;
        }
        return null;
    }
}

