/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class L2Effect
implements IChanceSkillTrigger {
    protected static final Logger _log = Logger.getLogger(L2Effect.class.getName());
    private static final Func[] _emptyFunctionSet = new Func[0];
    private final L2Character _effector;
    private final L2Character _effected;
    private final L2Skill _skill;
    private final boolean _isHerbEffect;
    private final Lambda _lambda;
    private EffectState _state;
    private final int _abnormalTime;
    private int _periodStartTicks;
    private int _periodFirstTime;
    private final EffectTemplate _template;
    private final FuncTemplate[] _funcTemplates;
    private final int _totalCount;
    private int _count;
    private final AbnormalEffect _abnormalEffect;
    private final AbnormalEffect[] _specialEffect;
    private final AbnormalEffect _eventEffect;
    private final boolean _icon;
    private boolean _isSelfEffect = false;
    private boolean _isPassiveEffect = false;
    public boolean preventExitUpdate;
    private ScheduledFuture<?> _currentFuture;
    private final String _abnormalType;
    private final byte _abnormalLvl;
    private boolean _inUse = false;
    private boolean _startConditionsCorrect = true;
    private double _effectPower;
    private L2SkillType _effectSkillType;

    protected L2Effect(Env env, EffectTemplate template) {
        this._state = EffectState.CREATED;
        this._skill = env.skill;
        this._template = template;
        this._effected = env.target;
        this._effector = env.player;
        this._lambda = template.lambda;
        this._funcTemplates = template.funcTemplates;
        this._totalCount = this._count = template.counter;
        int temp = template.abnormalTime;
        if ((this._skill.getId() > 2277 && this._skill.getId() < 2286 || this._skill.getId() >= 2512 && this._skill.getId() <= 2514) && (this._effected instanceof L2SummonInstance || this._effected instanceof L2PcInstance && ((L2PcInstance)this._effected).getPet() instanceof L2SummonInstance)) {
            temp /= 2;
        }
        if (env.skillMastery) {
            temp *= 2;
        }
        this._abnormalTime = temp;
        this._abnormalEffect = template.abnormalEffect;
        this._specialEffect = template.specialEffect;
        this._eventEffect = template.eventEffect;
        this._abnormalType = template.abnormalType;
        this._abnormalLvl = template.abnormalLvl;
        this._periodStartTicks = GameTimeController.getGameTicks();
        this._periodFirstTime = 0;
        this._icon = template.icon;
        this._effectPower = template.effectPower;
        this._effectSkillType = template.effectType;
        this._isHerbEffect = this.IS_HERB(this._skill.getName());
    }

    protected L2Effect(Env env, L2Effect effect) {
        this._template = effect._template;
        this._state = EffectState.CREATED;
        this._skill = env.skill;
        this._effected = env.target;
        this._effector = env.player;
        this._lambda = this._template.lambda;
        this._funcTemplates = this._template.funcTemplates;
        this._count = effect.getCount();
        this._totalCount = this._template.counter;
        this._abnormalTime = this._template.abnormalTime;
        this._abnormalEffect = this._template.abnormalEffect;
        this._specialEffect = this._template.specialEffect;
        this._eventEffect = this._template.eventEffect;
        this._abnormalType = this._template.abnormalType;
        this._abnormalLvl = this._template.abnormalLvl;
        this._periodStartTicks = effect.getPeriodStartTicks();
        this._periodFirstTime = effect.getTime();
        this._icon = this._template.icon;
        this._isHerbEffect = this.IS_HERB(this._skill.getName());
    }

    public int getCount() {
        return this._count;
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public void setCount(int newcount) {
        this._count = Math.min(newcount, this._totalCount);
    }

    public void setFirstTime(int newFirstTime) {
        this._periodFirstTime = Math.min(newFirstTime, this._abnormalTime);
        this._periodStartTicks -= this._periodFirstTime * 10;
    }

    public boolean getShowIcon() {
        return this._icon;
    }

    public int getAbnormalTime() {
        return this._abnormalTime;
    }

    public int getTime() {
        return (GameTimeController.getGameTicks() - this._periodStartTicks) / 10;
    }

    public int getTaskTime() {
        if (this._count == this._totalCount) {
            return 0;
        }
        return Math.abs(this._count - this._totalCount + 1) * this._abnormalTime + this.getTime() + 1;
    }

    public boolean getInUse() {
        return this._inUse;
    }

    public boolean setInUse(boolean inUse) {
        this._inUse = inUse;
        if (this._inUse) {
            this._startConditionsCorrect = this.onStart();
        } else {
            this.onExit();
        }
        return this._startConditionsCorrect;
    }

    public String getAbnormalType() {
        return this._abnormalType;
    }

    public byte getAbnormalLvl() {
        return this._abnormalLvl;
    }

    public final L2Skill getSkill() {
        return this._skill;
    }

    public final L2Character getEffector() {
        return this._effector;
    }

    public final L2Character getEffected() {
        return this._effected;
    }

    public boolean isSelfEffect() {
        return this._isSelfEffect;
    }

    public void setSelfEffect() {
        this._isSelfEffect = true;
    }

    public boolean isPassiveEffect() {
        return this._isPassiveEffect;
    }

    public void setPassiveEffect() {
        this._isPassiveEffect = true;
    }

    public boolean isHerbEffect() {
        return this._isHerbEffect;
    }

    private boolean IS_HERB(String name) {
        return name.contains("Herb") || name.contains("\u30cf\u30fc\u30d6");
    }

    public final double calc() {
        Env env = new Env();
        env.player = this._effector;
        env.target = this._effected;
        env.skill = this._skill;
        return this._lambda.calc(env);
    }

    private final synchronized void startEffectTask() {
        if (this._abnormalTime > 0) {
            this.stopEffectTask();
            int initialDelay = Math.max((this._abnormalTime - this._periodFirstTime) * 1000, 5);
            this._currentFuture = this._count > 1 ? ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new EffectTask(), initialDelay, this._abnormalTime * 1000) : ThreadPoolManager.getInstance().scheduleEffect(new EffectTask(), initialDelay);
        }
        if (this._state == EffectState.ACTING) {
            if (this.isSeflEffectType()) {
                this._effector.addEffect(this);
            } else {
                this._effected.addEffect(this);
            }
        }
    }

    public final void exit() {
        this.exit(false);
    }

    public final void exit(boolean preventUpdate) {
        this.preventExitUpdate = preventUpdate;
        this._state = EffectState.FINISHING;
        this.scheduleEffect();
    }

    public final synchronized void stopEffectTask() {
        if (this._currentFuture != null) {
            this._currentFuture.cancel(false);
            this._currentFuture = null;
            if (this.isSeflEffectType() && this.getEffector() != null) {
                this.getEffector().removeEffect(this);
            } else if (this.getEffected() != null) {
                this.getEffected().removeEffect(this);
            }
        }
    }

    public abstract L2EffectType getEffectType();

    public boolean onStart() {
        if (this._abnormalEffect != AbnormalEffect.NULL) {
            this.getEffected().startAbnormalEffect(this._abnormalEffect);
        }
        if (this._specialEffect != null) {
            this.getEffected().startSpecialEffect(this._specialEffect);
        }
        if (this._eventEffect != AbnormalEffect.NULL && this.getEffected() instanceof L2PcInstance) {
            this.getEffected().getActingPlayer().startEventEffect(this._eventEffect);
        }
        return true;
    }

    public void onExit() {
        if (this._abnormalEffect != AbnormalEffect.NULL) {
            this.getEffected().stopAbnormalEffect(this._abnormalEffect);
        }
        if (this._specialEffect != null) {
            this.getEffected().stopSpecialEffect(this._specialEffect);
        }
        if (this._eventEffect != AbnormalEffect.NULL && this.getEffected() instanceof L2PcInstance) {
            this.getEffected().getActingPlayer().stopEventEffect(this._eventEffect);
        }
    }

    public abstract boolean onActionTime();

    public final void scheduleEffect() {
        switch (this._state) {
            case CREATED: {
                this._state = EffectState.ACTING;
                if (this._skill.isPvpSkill() && this._icon && this.getEffected() instanceof L2PcInstance) {
                    SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                    smsg.addSkillName(this._skill);
                    this.getEffected().sendPacket(smsg);
                }
                if (this._abnormalTime != 0) {
                    this.startEffectTask();
                    return;
                }
                this._startConditionsCorrect = this.onStart();
            }
            case ACTING: {
                if (this._count > 0) {
                    --this._count;
                    if (this.getInUse() ? this.onActionTime() && this._startConditionsCorrect && this._count > 0 : this._count > 0) {
                        return;
                    }
                }
                this._state = EffectState.FINISHING;
            }
            case FINISHING: {
                L2Skill skill;
                if (this._count == 0 && this._icon && this.getEffected() instanceof L2PcInstance) {
                    SystemMessage smsg3 = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_WORN_OFF);
                    smsg3.addSkillName(this._skill);
                    this.getEffected().sendPacket(smsg3);
                }
                if (this._currentFuture == null && this.getEffected() != null) {
                    this.getEffected().removeEffect(this);
                }
                this.stopEffectTask();
                if ((this.getInUse() || this._count <= 1 && this._abnormalTime <= 0) && this._startConditionsCorrect) {
                    this.onExit();
                }
                if (this._skill.getAfterEffectId() <= 0 || (skill = SkillTable.getInstance().getInfo(this._skill.getAfterEffectId(), this._skill.getAfterEffectLvl())) == null) break;
                this.getEffected().broadcastPacket(new MagicSkillUse(this._effected, skill.getId(), skill.getLevel(), 0, 0));
                this.getEffected().broadcastPacket(new MagicSkillLaunched(this._effected, skill.getId(), skill.getLevel()));
                skill.getEffects(this.getEffected(), this.getEffected());
            }
        }
    }

    public Func[] getStatFuncs() {
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = this.getEffector();
        env.target = this.getEffected();
        env.skill = this.getSkill();
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.isEmpty()) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public final void addIcon(AbnormalStatusUpdate mi) {
        if (this._state != EffectState.ACTING) {
            return;
        }
        ScheduledFuture<?> future = this._currentFuture;
        L2Skill sk = this.getSkill();
        if (this._totalCount > 1) {
            if (sk.isPotion()) {
                mi.addEffect(sk.getDisplayId(), this.getLevel(), sk.getBuffDuration() - this.getTaskTime() * 1000);
            } else {
                mi.addEffect(sk.getDisplayId(), this.getLevel(), -1);
            }
        } else if (future != null) {
            mi.addEffect(sk.getDisplayId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._abnormalTime == -1) {
            mi.addEffect(sk.getDisplayId(), this.getLevel(), this._abnormalTime);
        }
    }

    public final void addPartySpelledIcon(PartySpelled ps) {
        if (this._state != EffectState.ACTING) {
            return;
        }
        ScheduledFuture<?> future = this._currentFuture;
        L2Skill sk = this.getSkill();
        if (future != null) {
            ps.addPartySpelledEffect(sk.getDisplayId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._abnormalTime == -1) {
            ps.addPartySpelledEffect(sk.getDisplayId(), this.getLevel(), this._abnormalTime);
        }
    }

    public final void addOlympiadSpelledIcon(ExOlympiadSpelledInfo os) {
        if (this._state != EffectState.ACTING) {
            return;
        }
        ScheduledFuture<?> future = this._currentFuture;
        L2Skill sk = this.getSkill();
        if (future != null) {
            os.addEffect(sk.getDisplayId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._abnormalTime == -1) {
            os.addEffect(sk.getDisplayId(), this.getLevel(), this._abnormalTime);
        }
    }

    public int getLevel() {
        return this.getSkill().getLevel();
    }

    public int getPeriodStartTicks() {
        return this._periodStartTicks;
    }

    public EffectTemplate getEffectTemplate() {
        return this._template;
    }

    public double getEffectPower() {
        return this._effectPower;
    }

    public L2SkillType getSkillType() {
        return this._effectSkillType;
    }

    public boolean canBeStolen() {
        return this.effectCanBeStolen() && this.getEffectType() != L2EffectType.TRANSFORMATION && !this.getSkill().isPassive() && !this.getSkill().isToggle() && !this.getSkill().isDebuff() && !this.getSkill().isHeroSkill() && !this.getSkill().isGMSkill() && (!this.getSkill().isPotion() || this.getSkill().getId() == 2274 || this.getSkill().getId() == 2341) && !this.isHerbEffect() && this.getSkill().canBeDispeled();
    }

    protected boolean effectCanBeStolen() {
        return false;
    }

    public int getEffectFlags() {
        return 0;
    }

    public String toString() {
        return "L2Effect [_skill=" + this._skill + ", _state=" + (Object)((Object)this._state) + ", _period=" + this._abnormalTime + "]";
    }

    public boolean isSeflEffectType() {
        return false;
    }

    public void decreaseForce() {
    }

    public void increaseEffect() {
    }

    public int getForceEffect() {
        return 0;
    }

    public boolean isBuffEffect() {
        return false;
    }

    public boolean isDebuffEffect() {
        return false;
    }

    @Override
    public boolean triggersChanceSkill() {
        return false;
    }

    @Override
    public int getTriggeredChanceId() {
        return 0;
    }

    @Override
    public int getTriggeredChanceLevel() {
        return 0;
    }

    @Override
    public ChanceCondition getTriggeredChanceCondition() {
        return null;
    }

    private final class EffectTask
    implements Runnable {
        private EffectTask() {
        }

        @Override
        public void run() {
            try {
                L2Effect.this._periodFirstTime = 0;
                L2Effect.this._periodStartTicks = GameTimeController.getGameTicks();
                L2Effect.this.scheduleEffect();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static enum EffectState {
        CREATED,
        ACTING,
        FINISHING;

    }
}

