/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.util.L2TIntObjectHashMap;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class L2Manor {
    private static Logger _log = Logger.getLogger(L2Manor.class.getName());
    private static L2TIntObjectHashMap<SeedData> _seeds;

    private L2Manor() {
        _seeds = new L2TIntObjectHashMap();
        this.parseData();
    }

    public static L2Manor getInstance() {
        return SingletonHolder._instance;
    }

    public SeedData[] getSeedsDataArray() {
        return _seeds.values((SeedData[])new SeedData[0]);
    }

    public FastList<Integer> getAllCrops() {
        FastList crops = new FastList();
        for (SeedData seed : this.getSeedsDataArray()) {
            if (crops.contains((Object)seed.getCrop()) || seed.getCrop() == 0 || crops.contains((Object)seed.getCrop())) continue;
            crops.add((Object)seed.getCrop());
        }
        return crops;
    }

    public int getSeedBasicPrice(int seedId) {
        L2Item seedItem = ItemTable.getInstance().getTemplate(seedId);
        if (seedItem != null) {
            return seedItem.getReferencePrice();
        }
        return 0;
    }

    public int getSeedBasicPriceByCrop(int cropId) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getCrop() != cropId) continue;
            return this.getSeedBasicPrice(seed.getId());
        }
        return 0;
    }

    public int getCropBasicPrice(int cropId) {
        L2Item cropItem = ItemTable.getInstance().getTemplate(cropId);
        if (cropItem != null) {
            return cropItem.getReferencePrice();
        }
        return 0;
    }

    public int getMatureCrop(int cropId) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getMature();
        }
        return 0;
    }

    public long getSeedBuyPrice(int seedId) {
        long buyPrice = this.getSeedBasicPrice(seedId);
        return buyPrice > 0L ? buyPrice : 1L;
    }

    public int getSeedMinLevel(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel() - 5;
        }
        return -1;
    }

    public int getSeedMaxLevel(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel() + 5;
        }
        return -1;
    }

    public int getSeedLevelByCrop(int cropId) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getLevel();
        }
        return 0;
    }

    public int getSeedLevel(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel();
        }
        return -1;
    }

    public boolean isAlternative(int seedId) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getId() != seedId) continue;
            return seed.isAlternative();
        }
        return false;
    }

    public int getCropType(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getCrop();
        }
        return -1;
    }

    public int getRewardItem(int cropId, int type) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getReward(type);
        }
        return -1;
    }

    public int getRewardItemBySeed(int seedId, int type) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getReward(type);
        }
        return 0;
    }

    public FastList<Integer> getCropsForCastle(int castleId) {
        FastList crops = new FastList();
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getManorId() != castleId || crops.contains((Object)seed.getCrop())) continue;
            crops.add((Object)seed.getCrop());
        }
        return crops;
    }

    public FastList<Integer> getSeedsForCastle(int castleId) {
        FastList seedsID = new FastList();
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getManorId() != castleId || seedsID.contains((Object)seed.getId())) continue;
            seedsID.add((Object)seed.getId());
        }
        return seedsID;
    }

    public int getCastleIdForSeed(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getManorId();
        }
        return 0;
    }

    public int getSeedSaleLimit(int seedId) {
        SeedData seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getSeedLimit();
        }
        return 0;
    }

    public int getCropPuchaseLimit(int cropId) {
        for (SeedData seed : this.getSeedsDataArray()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getCropLimit();
        }
        return 0;
    }

    private void parseData() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "/data/seeds.xml");
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not parse seeds.xml file: " + e.getMessage(), e);
        }
        doc.getDocumentElement().normalize();
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"castle".equalsIgnoreCase(d.getNodeName())) continue;
                    int castleId = Integer.parseInt(d.getAttributes().getNamedItem("id").getNodeValue());
                    for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                        if (!"crop".equalsIgnoreCase(c.getNodeName())) continue;
                        int cropId = Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue());
                        int seedId = 0;
                        int matureId = 0;
                        int type1R = 0;
                        int type2R = 0;
                        boolean isAlt = false;
                        int level = 0;
                        int limitSeeds = 0;
                        int limitCrops = 0;
                        for (Node a = c.getFirstChild(); a != null; a = a.getNextSibling()) {
                            if (a.getNodeName().equalsIgnoreCase("seed_id")) {
                                seedId = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("mature_id")) {
                                matureId = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("reward1")) {
                                type1R = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("reward2")) {
                                type2R = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("alternative")) {
                                isAlt = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue()) == 1;
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("level")) {
                                level = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (a.getNodeName().equalsIgnoreCase("limit_seed")) {
                                limitSeeds = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (!a.getNodeName().equalsIgnoreCase("limit_crops")) continue;
                            limitCrops = Integer.parseInt(a.getAttributes().getNamedItem("val").getNodeValue());
                        }
                        SeedData seed = new SeedData(level, cropId, matureId);
                        seed.setData(seedId, type1R, type2R, castleId, isAlt, limitSeeds, limitCrops);
                        _seeds.put(seed.getId(), seed);
                    }
                }
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded " + _seeds.size() + " Seeds.");
        }
    }

    public static void main(String[] arg) {
        L2Manor.getInstance();
    }

    private static class SingletonHolder {
        protected static final L2Manor _instance = new L2Manor();

        private SingletonHolder() {
        }
    }

    private static class SeedData {
        private int _id;
        private int _level;
        private int _crop;
        private int _mature;
        private int _type1;
        private int _type2;
        private int _manorId;
        private boolean _isAlternative;
        private int _limitSeeds;
        private int _limitCrops;

        public SeedData(int level, int crop, int mature) {
            this._level = level;
            this._crop = crop;
            this._mature = mature;
        }

        public void setData(int id, int t1, int t2, int manorId, boolean isAlt, int lim1, int lim2) {
            this._id = id;
            this._type1 = t1;
            this._type2 = t2;
            this._manorId = manorId;
            this._isAlternative = isAlt;
            this._limitSeeds = lim1;
            this._limitCrops = lim2;
        }

        public int getManorId() {
            return this._manorId;
        }

        public int getId() {
            return this._id;
        }

        public int getCrop() {
            return this._crop;
        }

        public int getMature() {
            return this._mature;
        }

        public int getReward(int type) {
            return type == 1 ? this._type1 : this._type2;
        }

        public int getLevel() {
            return this._level;
        }

        public boolean isAlternative() {
            return this._isAlternative;
        }

        public int getSeedLimit() {
            return this._limitSeeds * Config.RATE_DROP_MANOR;
        }

        public int getCropLimit() {
            return this._limitCrops * Config.RATE_DROP_MANOR;
        }

        public String toString() {
            return "SeedData [_id=" + this._id + ", _level=" + this._level + ", _crop=" + this._crop + ", _mature=" + this._mature + ", _type1=" + this._type1 + ", _type2=" + this._type2 + ", _manorId=" + this._manorId + ", _isAlternative=" + this._isAlternative + ", _limitSeeds=" + this._limitSeeds + ", _limitCrops=" + this._limitCrops + "]";
        }
    }
}

