/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2Macro;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.SendMacroList;
import com.l2jserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class MacroList {
    private static Logger _log = Logger.getLogger(MacroList.class.getName());
    private L2PcInstance _owner;
    private int _revision;
    private int _macroId;
    private Map<Integer, L2Macro> _macroses = new FastMap();

    public MacroList(L2PcInstance owner) {
        this._owner = owner;
        this._revision = 1;
        this._macroId = 1000;
    }

    public int getRevision() {
        return this._revision;
    }

    public L2Macro[] getAllMacroses() {
        return this._macroses.values().toArray(new L2Macro[this._macroses.size()]);
    }

    public L2Macro getMacro(int id) {
        return this._macroses.get(id - 1);
    }

    public void registerMacro(L2Macro macro) {
        if (macro.id == 0) {
            macro.id = this._macroId++;
            while (this._macroses.get(macro.id) != null) {
                ++this._macroId;
                macro.id = macro.id;
            }
            this._macroses.put(macro.id, macro);
            this.registerMacroInDb(macro);
        } else {
            L2Macro old = this._macroses.put(macro.id, macro);
            if (old != null) {
                this.deleteMacroFromDb(old);
            }
            this.registerMacroInDb(macro);
        }
        this.sendUpdate();
    }

    public void deleteMacro(int id) {
        L2ShortCut[] allShortCuts;
        L2Macro toRemove = this._macroses.get(id);
        if (toRemove != null) {
            this.deleteMacroFromDb(toRemove);
        }
        this._macroses.remove(id);
        for (L2ShortCut sc : allShortCuts = this._owner.getAllShortCuts()) {
            if (sc.getId() != id || sc.getType() != 4) continue;
            this._owner.deleteShortCut(sc.getSlot(), sc.getPage());
        }
        this.sendUpdate();
    }

    public void sendUpdate() {
        ++this._revision;
        L2Macro[] all = this.getAllMacroses();
        if (all.length == 0) {
            this._owner.sendPacket(new SendMacroList(this._revision, all.length, null));
        } else {
            for (L2Macro m : all) {
                this._owner.sendPacket(new SendMacroList(this._revision, all.length, m));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMacroInDb(L2Macro macro) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO character_macroses (charId,id,icon,name,descr,acronym,commands) values(?,?,?,?,?,?,?)");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, macro.id);
            statement.setInt(3, macro.icon);
            statement.setString(4, macro.name);
            statement.setString(5, macro.descr);
            statement.setString(6, macro.acronym);
            StringBuilder sb = new StringBuilder(300);
            for (L2Macro.L2MacroCmd cmd : macro.commands) {
                StringUtil.append(sb, String.valueOf(cmd.type), ",", String.valueOf(cmd.d1), ",", String.valueOf(cmd.d2));
                if (cmd.cmd != null && cmd.cmd.length() > 0) {
                    StringUtil.append(sb, ",", cmd.cmd);
                }
                sb.append(';');
            }
            if (sb.length() > 255) {
                sb.setLength(255);
            }
            statement.setString(7, sb.toString());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store macro:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMacroFromDb(L2Macro macro) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_macroses WHERE charId=? AND id=?");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, macro.id);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete macro:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this._macroses.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT charId, id, icon, name, descr, acronym, commands FROM character_macroses WHERE charId=?");
            statement.setInt(1, this._owner.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("id");
                int icon = rset.getInt("icon");
                String name = rset.getString("name");
                String descr = rset.getString("descr");
                String acronym = rset.getString("acronym");
                FastList commands = FastList.newInstance();
                StringTokenizer st1 = new StringTokenizer(rset.getString("commands"), ";");
                while (st1.hasMoreTokens()) {
                    StringTokenizer st = new StringTokenizer(st1.nextToken(), ",");
                    if (st.countTokens() < 3) continue;
                    int type = Integer.parseInt(st.nextToken());
                    int d1 = Integer.parseInt(st.nextToken());
                    int d2 = Integer.parseInt(st.nextToken());
                    String cmd = "";
                    if (st.hasMoreTokens()) {
                        cmd = st.nextToken();
                    }
                    L2Macro.L2MacroCmd mcmd = new L2Macro.L2MacroCmd(commands.size(), type, d1, d2, cmd);
                    commands.add((Object)mcmd);
                }
                L2Macro m = new L2Macro(id, icon, name, descr, acronym, (L2Macro.L2MacroCmd[])commands.toArray((Object[])new L2Macro.L2MacroCmd[commands.size()]));
                FastList.recycle((FastList)commands);
                this._macroses.put(m.id, m);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store shortcuts:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }
}

