/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.IhaveOwner;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2PeaceZone;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.concurrent.ScheduledFuture;

public class L2BirthdayCakeInstance
extends L2Npc
implements IhaveOwner {
    private static final int BIRTHDAY_CAKE_24 = 106;
    private static final int BIRTHDAY_CAKE = 139;
    private L2Skill _skill;
    private ScheduledFuture<?> _aiTask;
    private int _masterId;

    public L2BirthdayCakeInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public final L2PcInstance getOwner() {
        return L2World.getInstance().getPlayer(this._masterId);
    }

    @Override
    public void setOwner(L2PcInstance newOwner) {
        this._masterId = newOwner.getObjectId();
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setShowSummonAnimation(false);
        if (ZoneManager.getInstance().getZone(this, L2PeaceZone.class) == null) {
            switch (this.getNpcId()) {
                case 106: {
                    this._skill = SkillTable.getInstance().getInfo(22035, 1);
                    break;
                }
                case 139: {
                    this._skill = SkillTable.getInstance().getInfo(22250, 1);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new BuffTask(), 3000L, 3000L);
            this.broadcastPacket(new PlaySound(1, "HB01", 0, 0, 0, 0, 0));
        }
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
            this._aiTask = null;
        }
        super.deleteMe();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    private class BuffTask
    implements Runnable {
        private BuffTask() {
        }

        @Override
        public void run() {
            L2BirthdayCakeInstance npc = L2BirthdayCakeInstance.this;
            L2Skill skill = L2BirthdayCakeInstance.this._skill;
            switch (L2BirthdayCakeInstance.this.getNpcId()) {
                case 106: {
                    for (L2PcInstance player : L2BirthdayCakeInstance.this.getKnownList().getKnownPlayersInRadius(skill.getSkillRadius())) {
                        if (player.getFirstEffect(skill) != null) continue;
                        skill.getEffects(npc, player);
                    }
                    break;
                }
                case 139: {
                    L2PcInstance player = L2World.getInstance().getPlayer(L2BirthdayCakeInstance.this._masterId);
                    if (player == null) {
                        return;
                    }
                    L2Party party = player.getParty();
                    if (party == null) {
                        if (!player.isInsideRadius(npc, skill.getSkillRadius(), true, true) || player.getFirstEffect(skill) != null) break;
                        skill.getEffects(npc, player);
                        break;
                    }
                    for (L2PcInstance member : party.getPartyMembers()) {
                        if (member == null || !member.isInsideRadius(npc, skill.getSkillRadius(), true, true) || member.getFirstEffect(skill) != null) continue;
                        skill.getEffects(npc, member);
                    }
                    break;
                }
            }
        }
    }
}

