/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2FortDoormenInstance
extends L2DoormenInstance {
    public L2FortDoormenInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(L2Object.InstanceType.L2FortDoormenInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (!this.isOwnerClan(player)) {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getNpcId() + "-no.htm");
        } else if (this.isUnderSiege()) {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getNpcId() + "-busy.htm");
        } else {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getNpcId() + ".htm");
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    @Override
    protected final void openDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(10), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            this.getFort().openDoor(player, Integer.parseInt(st.nextToken()));
        }
    }

    @Override
    protected final void closeDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(11), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            this.getFort().closeDoor(player, Integer.parseInt(st.nextToken()));
        }
    }

    @Override
    protected final boolean isOwnerClan(L2PcInstance player) {
        return player.getClan() != null && this.getFort() != null && this.getFort().getOwnerClan() != null && player.getClanId() == this.getFort().getOwnerClan().getClanId();
    }

    @Override
    protected final boolean isUnderSiege() {
        return this.getFort().getZone().isActive();
    }
}

