/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.knownlist.MonsterKnownList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.MinionList;
import com.l2jserver.util.Rnd;
import java.util.concurrent.ScheduledFuture;

public class L2MonsterInstance
extends L2Attackable {
    private boolean _enableMinions = true;
    private L2MonsterInstance _master = null;
    private MinionList _minionList = null;
    protected ScheduledFuture<?> _maintenanceTask = null;
    private static final int MONSTER_MAINTENANCE_INTERVAL = 1000;

    public L2MonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2MonsterInstance);
        this.setAutoAttackable(true);
    }

    @Override
    public final MonsterKnownList getKnownList() {
        return (MonsterKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new MonsterKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return super.isAutoAttackable(attacker) && !this.isEventMob;
    }

    @Override
    public boolean isAggressive() {
        return this.getAggroRange() > 0 && !this.isEventMob;
    }

    @Override
    public void onSpawn() {
        if (!this.isTeleporting()) {
            if (this.getLeader() != null) {
                this.setIsNoRndWalk(true);
                this.setIsRaidMinion(this.getLeader().isRaid());
                this.getLeader().getMinionList().onMinionSpawn(this);
            }
            if (this.hasMinions()) {
                this.getMinionList().onMasterSpawn();
            }
            this.startMaintenanceTask();
        }
        super.onSpawn();
    }

    @Override
    public void onTeleported() {
        super.onTeleported();
        if (this.hasMinions()) {
            this.getMinionList().onMasterTeleported();
        }
    }

    protected int getMaintenanceInterval() {
        return 1000;
    }

    protected void startMaintenanceTask() {
        if (this.getTemplate().getMinionData() == null) {
            return;
        }
        if (this._maintenanceTask == null) {
            this._maintenanceTask = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    if (L2MonsterInstance.this._enableMinions) {
                        L2MonsterInstance.this.getMinionList().spawnMinions();
                    }
                }
            }, this.getMaintenanceInterval() + Rnd.get(1000));
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._maintenanceTask != null) {
            this._maintenanceTask.cancel(false);
            this._maintenanceTask = null;
        }
        return true;
    }

    @Override
    public void deleteMe() {
        if (this._maintenanceTask != null) {
            this._maintenanceTask.cancel(false);
            this._maintenanceTask = null;
        }
        if (this.hasMinions()) {
            this.getMinionList().onMasterDie(true);
        }
        if (this.getLeader() != null) {
            this.getLeader().getMinionList().onMinionDie(this, 0);
        }
        super.deleteMe();
    }

    @Override
    public L2MonsterInstance getLeader() {
        return this._master;
    }

    public void setLeader(L2MonsterInstance leader) {
        this._master = leader;
    }

    public void enableMinions(boolean b) {
        this._enableMinions = b;
    }

    public boolean hasMinions() {
        return this._minionList != null;
    }

    public MinionList getMinionList() {
        if (this._minionList == null) {
            this._minionList = new MinionList(this);
        }
        return this._minionList;
    }
}

