/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcBufferTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.logging.Logger;

public class L2NpcBufferInstance
extends L2Npc {
    static final Logger _log = Logger.getLogger(L2NpcBufferInstance.class.getName());
    private static TIntIntHashMap pageVal = new TIntIntHashMap();

    public L2NpcBufferInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2NpcBufferInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance playerInstance, int val) {
        if (playerInstance == null) {
            return;
        }
        String htmContent = HtmCache.getInstance().getHtm(playerInstance.getHtmlPrefix(), val > 0 ? "data/html/mods/NpcBuffer-" + val + ".htm" : "data/html/mods/NpcBuffer.htm");
        if (htmContent != null) {
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
            npcHtmlMessage.setHtml(htmContent);
            npcHtmlMessage.replace((CharSequence)"%objectId%", this.getObjectId());
            playerInstance.sendPacket(npcHtmlMessage);
        }
        playerInstance.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player == null || player.getLastFolkNPC() == null || player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        L2Playable target = player;
        if (command.startsWith("Pet")) {
            L2Summon pet = player.getPet();
            if (pet == null) {
                player.sendMessage("\u30da\u30c3\u30c8\u3092\u53ec\u559a\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                this.showChatWindow(player, 0);
                return;
            }
            target = pet;
        }
        int npcId = this.getNpcId();
        if (command.startsWith("Chat")) {
            int val = Integer.parseInt(command.substring(5));
            pageVal.put(player.getObjectId(), val);
            this.showChatWindow(player, val);
        } else if (command.startsWith("Buff") || command.startsWith("PetBuff")) {
            String[] buffGroupArray;
            for (String buffGroupList : buffGroupArray = command.substring(command.indexOf("Buff") + 5).split(" ")) {
                L2Skill skill;
                if (buffGroupList == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " has no buffGroup set in the bypass for the buff selected.");
                    return;
                }
                int buffGroup = Integer.parseInt(buffGroupList);
                int[] npcBuffGroupInfo = NpcBufferTable.getInstance().getSkillInfo(npcId, buffGroup);
                if (npcBuffGroupInfo == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " Location: " + this.getX() + ", " + this.getY() + ", " + this.getZ() + " Player: " + player.getName() + " has tried to use skill group (" + buffGroup + ") not assigned to the NPC Buffer!");
                    return;
                }
                int skillId = npcBuffGroupInfo[0];
                int skillLevel = npcBuffGroupInfo[1];
                int skillFeeId = npcBuffGroupInfo[2];
                int skillFeeAmount = npcBuffGroupInfo[3];
                if (skillFeeId != 0) {
                    L2ItemInstance itemInstance = player.getInventory().getItemByItemId(skillFeeId);
                    if (itemInstance == null || !itemInstance.isStackable() && player.getInventory().getInventoryItemCount(skillFeeId, -1) < (long)skillFeeAmount) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                        player.sendPacket(sm);
                        continue;
                    }
                    if (itemInstance.isStackable()) {
                        if (skillFeeId == 57) {
                            if (!player.reduceAdena("Npc Buffer", skillFeeAmount, player.getTarget(), true)) {
                                continue;
                            }
                        } else if (!player.destroyItemByItemId("Npc Buffer", skillFeeId, skillFeeAmount, player.getTarget(), true)) {
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                            player.sendPacket(sm);
                            continue;
                        }
                    } else {
                        for (int i = 0; i < skillFeeAmount; ++i) {
                            player.destroyItemByItemId("Npc Buffer", skillFeeId, 1L, player.getTarget(), true);
                        }
                    }
                }
                if ((skill = SkillTable.getInstance().getInfo(skillId, skillLevel)) == null) continue;
                skill.getEffects(player, target);
            }
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else if (command.startsWith("Heal") || command.startsWith("PetHeal")) {
            if (!target.isInCombat() && !AttackStanceTaskManager.getInstance().getAttackStanceTask(target)) {
                String[] healArray;
                for (String healType : healArray = command.substring(command.indexOf("Heal") + 5).split(" ")) {
                    if (healType.equalsIgnoreCase("HP")) {
                        target.setCurrentHp(target.getMaxHp());
                        continue;
                    }
                    if (healType.equalsIgnoreCase("MP")) {
                        target.setCurrentMp(target.getMaxMp());
                        continue;
                    }
                    if (!healType.equalsIgnoreCase("CP")) continue;
                    target.setCurrentCp(target.getMaxCp());
                }
            }
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else if (command.startsWith("RemoveBuffs") || command.startsWith("PetRemoveBuffs")) {
            target.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

