/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class L2QuestGuardInstance
extends L2GuardInstance {
    private boolean _isAutoAttackable = true;
    private boolean _isPassive = false;

    public L2QuestGuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2QuestGuardInstance);
    }

    @Override
    public void addDamage(L2Character attacker, int damage, L2Skill skill) {
        super.addDamage(attacker, damage, skill);
        if (attacker instanceof L2Attackable && this.getTemplate().getEventQuests(Quest.QuestEventType.ON_ATTACK) != null) {
            for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_ATTACK)) {
                quest.notifyAttack(this, null, damage, false, skill);
            }
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (killer instanceof L2Attackable && this.getTemplate().getEventQuests(Quest.QuestEventType.ON_KILL) != null) {
            for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_KILL)) {
                ThreadPoolManager.getInstance().scheduleEffect(new L2Attackable.OnKillNotifyTask(this, quest, null, false), this._onKillDelay);
            }
        }
        return true;
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (!this._isPassive && !(attacker instanceof L2PcInstance)) {
            super.addDamageHate(attacker, damage, aggro);
        }
    }

    public void setPassive(boolean state) {
        this._isPassive = state;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._isAutoAttackable && !(attacker instanceof L2PcInstance);
    }

    @Override
    public void setAutoAttackable(boolean state) {
        this._isAutoAttackable = state;
    }

    public boolean isPassive() {
        return this._isPassive;
    }
}

