/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

public class L2TownPetInstance
extends L2Npc {
    int randomX;
    int randomY;
    int spawnX;
    int spawnY;

    public L2TownPetInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TownPetInstance);
        if (Config.ALLOW_PET_WALKERS) {
            ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new RandomWalkTask(), 2000L, 4000L);
        }
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact && !this.canInteract(player)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.spawnX = this.getX();
        this.spawnY = this.getY();
    }

    public class RandomWalkTask
    implements Runnable {
        @Override
        public void run() {
            if (!L2TownPetInstance.this.isInActiveRegion()) {
                return;
            }
            L2TownPetInstance.this.randomX = L2TownPetInstance.this.spawnX + Rnd.get(100) - 50;
            L2TownPetInstance.this.randomY = L2TownPetInstance.this.spawnY + Rnd.get(100) - 50;
            L2TownPetInstance.this.setRunning();
            if (L2TownPetInstance.this.randomX != L2TownPetInstance.this.getX() && L2TownPetInstance.this.randomY != L2TownPetInstance.this.getY()) {
                L2TownPetInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(L2TownPetInstance.this.randomX, L2TownPetInstance.this.randomY, L2TownPetInstance.this.getZ(), 0));
            }
        }
    }
}

