/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.PlayerEventStatus;
import com.l2jserver.util.Util;
import com.l2jserver.util.ValueSortMap;
import java.io.BufferedReader;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2Event {
    protected static final Logger _log = Logger.getLogger(L2Event.class.getName());
    public static EventState eventState = EventState.OFF;
    public static String _eventName = "";
    public static String _eventCreator = "";
    public static String _eventInfo = "";
    public static int _teamsNumber = 0;
    public static final Map<Integer, String> _teamNames = new FastMap();
    public static final List<L2PcInstance> _registeredPlayers = new FastList();
    public static final Map<Integer, FastList<L2PcInstance>> _teams = new FastMap();
    public static int _npcId = 0;
    private static final Map<L2PcInstance, PlayerEventStatus> _connectionLossData = new FastMap();

    public static int getPlayerTeamId(L2PcInstance player) {
        if (player == null) {
            return -1;
        }
        for (Map.Entry<Integer, FastList<L2PcInstance>> team : _teams.entrySet()) {
            if (!team.getValue().contains((Object)player)) continue;
            return team.getKey();
        }
        return -1;
    }

    public static List<L2PcInstance> getTopNKillers(int n) {
        FastList toReturn;
        FastMap tmp = new FastMap();
        for (FastList<L2PcInstance> teamList : _teams.values()) {
            for (L2PcInstance player : teamList) {
                if (player.getEventStatus() == null) continue;
                tmp.put(player, player.getEventStatus().kills.size());
            }
        }
        ValueSortMap.sortMapByValue((Map)tmp, false);
        if (tmp.size() <= n) {
            toReturn = new FastList();
            toReturn.addAll(tmp.keySet());
            return toReturn;
        }
        toReturn = new FastList();
        toReturn.addAll(tmp.keySet());
        return toReturn.subList(1, n);
    }

    public static void showEventHtml(L2PcInstance player, String objectid) {
        if (eventState == EventState.STANDBY) {
            try {
                NpcHtmlMessage html = new NpcHtmlMessage(5);
                String htmContent = _registeredPlayers.contains(player) ? HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participating.htm") : HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participation.htm");
                if (htmContent != null) {
                    html.setHtml(htmContent);
                }
                html.replace((CharSequence)"%objectId%", objectid);
                html.replace((CharSequence)"%eventName%", _eventName);
                html.replace((CharSequence)"%eventCreator%", _eventCreator);
                html.replace((CharSequence)"%eventInfo%", _eventInfo);
                player.sendPacket(html);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on showEventHtml(): " + e.getMessage(), e);
            }
        }
    }

    public static void spawnEventNpc(L2PcInstance target) {
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(_npcId);
        try {
            L2Spawn spawn = new L2Spawn(template);
            spawn.setLocx(target.getX() + 50);
            spawn.setLocy(target.getY() + 50);
            spawn.setLocz(target.getZ());
            spawn.setAmount(1);
            spawn.setHeading(target.getHeading());
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            spawn.init();
            spawn.getLastSpawn().setCurrentHp(9.99999999E8);
            spawn.getLastSpawn().setTitle(_eventName);
            spawn.getLastSpawn().isEventMob = true;
            spawn.getLastSpawn().broadcastPacket(new MagicSkillUse(spawn.getLastSpawn(), spawn.getLastSpawn(), 1034, 1, 1, 1));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on spawn(): " + e.getMessage(), e);
        }
    }

    public static void unspawnEventNpcs() {
        for (L2Spawn spawn : SpawnTable.getInstance().getSpawnTable()) {
            if (spawn.getLastSpawn() == null || !spawn.getLastSpawn().isEventMob) continue;
            spawn.getLastSpawn().deleteMe();
            spawn.stopRespawn();
            SpawnTable.getInstance().deleteSpawn(spawn, false);
        }
    }

    public static boolean isParticipant(L2PcInstance player) {
        if (player == null || player.getEventStatus() == null) {
            return false;
        }
        switch (eventState) {
            case OFF: {
                return false;
            }
            case STANDBY: {
                return _registeredPlayers.contains(player);
            }
            case ON: {
                for (FastList<L2PcInstance> teamList : _teams.values()) {
                    if (!teamList.contains((Object)player)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static void registerPlayer(L2PcInstance player) {
        if (eventState != EventState.STANDBY) {
            player.sendMessage("The registration period for this event is over.");
            return;
        }
        if (Config.L2JMOD_DUALBOX_CHECK_MAX_L2EVENT_PARTICIPANTS_PER_IP != 0 && !AntiFeedManager.getInstance().tryAddPlayer(3, player, Config.L2JMOD_DUALBOX_CHECK_MAX_L2EVENT_PARTICIPANTS_PER_IP)) {
            player.sendMessage("You have reached the maximum allowed participants per IP.");
            return;
        }
        _registeredPlayers.add(player);
    }

    public static void removeAndResetPlayer(L2PcInstance player) {
        try {
            if (L2Event.isParticipant(player)) {
                if (player.isDead()) {
                    player.restoreExp(100.0);
                    player.doRevive();
                    player.setCurrentHpMp(player.getMaxHp(), player.getMaxMp());
                    player.setCurrentCp(player.getMaxCp());
                }
                player.getPoly().setPolyInfo(null, "1");
                player.decayMe();
                player.spawnMe(player.getX(), player.getY(), player.getZ());
                CharInfo info1 = new CharInfo(player);
                player.broadcastPacket(info1);
                UserInfo info2 = new UserInfo(player);
                player.sendPacket(info2);
                player.broadcastPacket(new ExBrExtraUserInfo(player));
                player.stopTransformation(true);
            }
            if (player.getEventStatus() != null) {
                player.getEventStatus().restoreInits();
            }
            player.setEventStatus(null);
            _registeredPlayers.remove(player);
            int teamId = L2Event.getPlayerTeamId(player);
            if (_teams.containsKey(teamId)) {
                _teams.get(teamId).remove((Object)player);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error at unregisterAndResetPlayer in the event:" + e.getMessage(), e);
        }
    }

    public static void savePlayerEventStatus(L2PcInstance player) {
        _connectionLossData.put(player, player.getEventStatus());
    }

    public static void restorePlayerEventStatus(L2PcInstance player) {
        if (_connectionLossData.containsKey(player)) {
            player.setEventStatus(_connectionLossData.get(player));
            _connectionLossData.remove(player);
        }
    }

    public static String startEventParticipation() {
        try {
            switch (eventState) {
                case ON: {
                    return "Cannot start event, it is already on.";
                }
                case STANDBY: {
                    return "Cannot start event, it is on standby mode.";
                }
                case OFF: {
                    eventState = EventState.STANDBY;
                }
            }
            AntiFeedManager.getInstance().registerEvent(3);
            AntiFeedManager.getInstance().clear(2);
            L2Event.unspawnEventNpcs();
            _registeredPlayers.clear();
            if (NpcTable.getInstance().getTemplate(_npcId) == null) {
                return "Cannot start event, invalid npc id.";
            }
            BufferedReader inbr = Util.utf8BufferedReader("data/events/" + _eventName);
            _eventCreator = inbr.readLine();
            _eventInfo = inbr.readLine();
            FastList temp = new FastList();
            for (L2PcInstance player : L2World.getInstance().getAllPlayersArray()) {
                if (!player.isOnline()) continue;
                if (!temp.contains(player)) {
                    L2Event.spawnEventNpc(player);
                    temp.add(player);
                }
                for (L2PcInstance playertemp : player.getKnownList().getKnownPlayers().values()) {
                    if (Math.abs(playertemp.getX() - player.getX()) >= 1000 || Math.abs(playertemp.getY() - player.getY()) >= 1000 || Math.abs(playertemp.getZ() - player.getZ()) >= 1000) continue;
                    temp.add(playertemp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Cannot start event participation, an error has occured.";
        }
        return "The event participation has been successfully started.";
    }

    public static String startEvent() {
        try {
            int i;
            switch (eventState) {
                case ON: {
                    return "Cannot start event, it is already on.";
                }
                case STANDBY: {
                    eventState = EventState.ON;
                    break;
                }
                case OFF: {
                    return "Cannot start event, it is off. Participation start is required.";
                }
            }
            L2Event.unspawnEventNpcs();
            _teams.clear();
            _connectionLossData.clear();
            for (i = 0; i < _teamsNumber; ++i) {
                _teams.put(i + 1, (FastList<L2PcInstance>)new FastList());
            }
            i = 0;
            while (!_registeredPlayers.isEmpty()) {
                int max = 0;
                L2PcInstance biggestLvlPlayer = null;
                for (L2PcInstance player : _registeredPlayers) {
                    if (player == null || max >= player.getLevel()) continue;
                    max = player.getLevel();
                    biggestLvlPlayer = player;
                }
                if (biggestLvlPlayer == null) continue;
                _registeredPlayers.remove(biggestLvlPlayer);
                _teams.get(i + 1).add((Object)biggestLvlPlayer);
                biggestLvlPlayer.setEventStatus();
                i = (i + 1) % _teamsNumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Cannot start event, an error has occured.";
        }
        return "The event has been successfully started.";
    }

    public static String finishEvent() {
        switch (eventState) {
            case OFF: {
                return "Cannot finish event, it is already off.";
            }
            case STANDBY: {
                for (L2PcInstance player : _registeredPlayers) {
                    L2Event.removeAndResetPlayer(player);
                }
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                eventState = EventState.OFF;
                return "The event has been stopped at STANDBY mode, all players unregistered and all event npcs unspawned.";
            }
            case ON: {
                for (FastList<L2PcInstance> teamList : _teams.values()) {
                    for (L2PcInstance player : teamList) {
                        L2Event.removeAndResetPlayer(player);
                    }
                }
                eventState = EventState.OFF;
                AntiFeedManager.getInstance().clear(2);
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                _npcId = 0;
                _eventCreator = "";
                _eventInfo = "";
                return "The event has been stopped, all players unregistered and all event npcs unspawned.";
            }
        }
        return "The event has been successfully finished.";
    }

    public static enum EventState {
        OFF,
        STANDBY,
        ON;

    }
}

