/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ArmorSetsTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.L2Armor;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.L2Weapon;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.item.type.L2EtcItemType;
import com.l2jserver.gameserver.model.item.type.L2WeaponType;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;

public abstract class Inventory
extends ItemContainer {
    public static final int PAPERDOLL_UNDER = 0;
    public static final int PAPERDOLL_HEAD = 1;
    public static final int PAPERDOLL_HAIR = 2;
    public static final int PAPERDOLL_HAIR2 = 3;
    public static final int PAPERDOLL_NECK = 4;
    public static final int PAPERDOLL_RHAND = 5;
    public static final int PAPERDOLL_CHEST = 6;
    public static final int PAPERDOLL_LHAND = 7;
    public static final int PAPERDOLL_REAR = 8;
    public static final int PAPERDOLL_LEAR = 9;
    public static final int PAPERDOLL_GLOVES = 10;
    public static final int PAPERDOLL_LEGS = 11;
    public static final int PAPERDOLL_FEET = 12;
    public static final int PAPERDOLL_RFINGER = 13;
    public static final int PAPERDOLL_LFINGER = 14;
    public static final int PAPERDOLL_LBRACELET = 15;
    public static final int PAPERDOLL_RBRACELET = 16;
    public static final int PAPERDOLL_DECO1 = 17;
    public static final int PAPERDOLL_DECO2 = 18;
    public static final int PAPERDOLL_DECO3 = 19;
    public static final int PAPERDOLL_DECO4 = 20;
    public static final int PAPERDOLL_DECO5 = 21;
    public static final int PAPERDOLL_DECO6 = 22;
    public static final int PAPERDOLL_CLOAK = 23;
    public static final int PAPERDOLL_BELT = 24;
    public static final int PAPERDOLL_TOTALSLOTS = 25;
    public static final double MAX_ARMOR_WEIGHT = 12000.0;
    private final L2ItemInstance[] _paperdoll = new L2ItemInstance[25];
    private final List<PaperdollListener> _paperdollListeners = new ArrayList<PaperdollListener>();
    protected int _totalWeight;
    private int _wearedMask;

    protected Inventory() {
        if (this instanceof PcInventory) {
            this.addPaperdollListener(ArmorSetListener.getInstance());
            this.addPaperdollListener(BowCrossRodListener.getInstance());
            this.addPaperdollListener(ItemSkillsListener.getInstance());
            this.addPaperdollListener(BraceletListener.getInstance());
        }
        this.addPaperdollListener(StatsListener.getInstance());
    }

    protected abstract L2ItemInstance.ItemLocation getEquipLocation();

    public ChangeRecorder newRecorder() {
        return new ChangeRecorder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            this.removeItem(item);
            item.setOwnerId(process, 0, actor, reference);
            item.setLocation(L2ItemInstance.ItemLocation.VOID);
            item.setLastChange(3);
            item.updateDatabase();
            this.refreshWeight();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            if (item.getCount() > count) {
                item.changeCount(process, -count, actor, reference);
                item.setLastChange(2);
                item.updateDatabase();
                item = ItemTable.getInstance().createItem(process, item.getItemId(), count, actor, reference);
                item.updateDatabase();
                this.refreshWeight();
                return item;
            }
        }
        return this.dropItem(process, item, actor, reference);
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        if (item.isEquipped()) {
            this.equipItem(item);
        }
    }

    @Override
    protected boolean removeItem(L2ItemInstance item) {
        for (int i = 0; i < this._paperdoll.length; ++i) {
            if (this._paperdoll[i] != item) continue;
            this.unEquipItemInSlot(i);
        }
        return super.removeItem(item);
    }

    public L2ItemInstance getPaperdollItem(int slot) {
        return this._paperdoll[slot];
    }

    public static int getPaperdollIndex(int slot) {
        switch (slot) {
            case 1: {
                return 0;
            }
            case 2: {
                return 8;
            }
            case 4: 
            case 6: {
                return 9;
            }
            case 8: {
                return 4;
            }
            case 16: 
            case 48: {
                return 13;
            }
            case 32: {
                return 14;
            }
            case 64: {
                return 1;
            }
            case 128: 
            case 16384: {
                return 5;
            }
            case 256: {
                return 7;
            }
            case 512: {
                return 10;
            }
            case 1024: 
            case 32768: 
            case 131072: {
                return 6;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 23;
            }
            case 65536: 
            case 524288: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 0x100000: {
                return 16;
            }
            case 0x200000: {
                return 15;
            }
            case 0x400000: {
                return 17;
            }
            case 0x10000000: {
                return 24;
            }
        }
        return -1;
    }

    public L2ItemInstance getPaperdollItemByL2ItemId(int slot) {
        int index = Inventory.getPaperdollIndex(slot);
        if (index == -1) {
            return null;
        }
        return this._paperdoll[index];
    }

    public int getPaperdollItemId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getItemId();
        }
        return 0;
    }

    public int getPaperdollAugmentationId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null && item.getAugmentation() != null) {
            return item.getAugmentation().getAugmentationId();
        }
        return 0;
    }

    public int getPaperdollObjectId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getObjectId();
        }
        return 0;
    }

    public synchronized void addPaperdollListener(PaperdollListener listener) {
        assert (!this._paperdollListeners.contains(listener));
        this._paperdollListeners.add(listener);
    }

    public synchronized void removePaperdollListener(PaperdollListener listener) {
        this._paperdollListeners.remove(listener);
    }

    public synchronized L2ItemInstance setPaperdollItem(int slot, L2ItemInstance item) {
        L2ItemInstance old = this._paperdoll[slot];
        if (old != item) {
            if (old != null) {
                this._paperdoll[slot] = null;
                old.setLocation(this.getBaseLocation());
                old.setLastChange(2);
                int mask = 0;
                for (int i = 0; i < 25; ++i) {
                    L2ItemInstance pi = this._paperdoll[i];
                    if (pi == null) continue;
                    mask |= pi.getItem().getItemMask();
                }
                this._wearedMask = mask;
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyUnequiped(slot, old, this);
                }
                old.updateDatabase();
            }
            if (item != null) {
                this._paperdoll[slot] = item;
                item.setLocation(this.getEquipLocation(), slot);
                item.setLastChange(2);
                this._wearedMask |= item.getItem().getItemMask();
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyEquiped(slot, item, this);
                }
                item.updateDatabase();
            }
        }
        return old;
    }

    public int getWearedMask() {
        return this._wearedMask;
    }

    public int getSlotFromItem(L2ItemInstance item) {
        int slot = -1;
        int location = item.getLocationSlot();
        switch (location) {
            case 0: {
                slot = 1;
                break;
            }
            case 9: {
                slot = 4;
                break;
            }
            case 8: {
                slot = 2;
                break;
            }
            case 4: {
                slot = 8;
                break;
            }
            case 13: {
                slot = 16;
                break;
            }
            case 14: {
                slot = 32;
                break;
            }
            case 2: {
                slot = 65536;
                break;
            }
            case 3: {
                slot = 262144;
                break;
            }
            case 1: {
                slot = 64;
                break;
            }
            case 5: {
                slot = 128;
                break;
            }
            case 7: {
                slot = 256;
                break;
            }
            case 10: {
                slot = 512;
                break;
            }
            case 6: {
                slot = item.getItem().getBodyPart();
                break;
            }
            case 11: {
                slot = 2048;
                break;
            }
            case 23: {
                slot = 8192;
                break;
            }
            case 12: {
                slot = 4096;
                break;
            }
            case 15: {
                slot = 0x200000;
                break;
            }
            case 16: {
                slot = 0x100000;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                slot = 0x400000;
                break;
            }
            case 24: {
                slot = 0x10000000;
            }
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInBodySlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInBodySlot(slot);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInSlot(int pdollSlot) {
        return this.setPaperdollItem(pdollSlot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInSlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInSlot(slot);
            if (this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInBodySlot(int slot) {
        if (Config.DEBUG) {
            _log.fine("--- unequip body slot:" + slot);
        }
        int pdollSlot = -1;
        switch (slot) {
            case 4: {
                pdollSlot = 9;
                break;
            }
            case 2: {
                pdollSlot = 8;
                break;
            }
            case 8: {
                pdollSlot = 4;
                break;
            }
            case 16: {
                pdollSlot = 13;
                break;
            }
            case 32: {
                pdollSlot = 14;
                break;
            }
            case 65536: {
                pdollSlot = 2;
                break;
            }
            case 262144: {
                pdollSlot = 3;
                break;
            }
            case 524288: {
                this.setPaperdollItem(2, null);
                pdollSlot = 2;
                break;
            }
            case 64: {
                pdollSlot = 1;
                break;
            }
            case 128: 
            case 16384: {
                pdollSlot = 5;
                break;
            }
            case 256: {
                pdollSlot = 7;
                break;
            }
            case 512: {
                pdollSlot = 10;
                break;
            }
            case 1024: 
            case 32768: 
            case 131072: {
                pdollSlot = 6;
                break;
            }
            case 2048: {
                pdollSlot = 11;
                break;
            }
            case 8192: {
                pdollSlot = 23;
                break;
            }
            case 4096: {
                pdollSlot = 12;
                break;
            }
            case 1: {
                pdollSlot = 0;
                break;
            }
            case 0x200000: {
                pdollSlot = 15;
                break;
            }
            case 0x100000: {
                pdollSlot = 16;
                break;
            }
            case 0x400000: {
                pdollSlot = 17;
                break;
            }
            case 0x10000000: {
                pdollSlot = 24;
                break;
            }
            default: {
                _log.info("Unhandled slot type: " + slot);
                _log.info(StringUtil.getTraceString(Thread.currentThread().getStackTrace()));
            }
        }
        if (pdollSlot >= 0) {
            L2ItemInstance old = this.setPaperdollItem(pdollSlot, null);
            if (old != null && this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
            return old;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] equipItemAndRecord(L2ItemInstance item) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.equipItem(item);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public void equipItem(L2ItemInstance item) {
        L2PcInstance player;
        if (this.getOwner() instanceof L2PcInstance && ((L2PcInstance)this.getOwner()).getPrivateStoreType() != 0) {
            return;
        }
        if (this.getOwner() instanceof L2PcInstance && !(player = (L2PcInstance)this.getOwner()).isGM() && !player.isHero() && item.isHeroItem()) {
            return;
        }
        int targetSlot = item.getItem().getBodyPart();
        L2ItemInstance formal = this.getPaperdollItem(6);
        if (item.getItemId() != 21163 && formal != null && formal.getItem().getBodyPart() == 131072) {
            switch (targetSlot) {
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 2048: 
                case 4096: 
                case 16384: {
                    return;
                }
            }
        }
        switch (targetSlot) {
            case 16384: {
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(5, item);
                break;
            }
            case 256: {
                L2ItemInstance rh = this.getPaperdollItem(5);
                if (!(rh == null || rh.getItem().getBodyPart() != 16384 || rh.getItemType() == L2WeaponType.BOW && item.getItemType() == L2EtcItemType.ARROW || rh.getItemType() == L2WeaponType.CROSSBOW && item.getItemType() == L2EtcItemType.BOLT || rh.getItemType() == L2WeaponType.FISHINGROD && item.getItemType() == L2EtcItemType.LURE)) {
                    this.setPaperdollItem(5, null);
                }
                this.setPaperdollItem(7, item);
                break;
            }
            case 128: {
                this.setPaperdollItem(5, item);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._paperdoll[9] == null) {
                    this.setPaperdollItem(9, item);
                    break;
                }
                if (this._paperdoll[8] == null) {
                    this.setPaperdollItem(8, item);
                    break;
                }
                this.setPaperdollItem(9, item);
                break;
            }
            case 16: 
            case 32: 
            case 48: {
                if (this._paperdoll[14] == null) {
                    this.setPaperdollItem(14, item);
                    break;
                }
                if (this._paperdoll[13] == null) {
                    this.setPaperdollItem(13, item);
                    break;
                }
                this.setPaperdollItem(14, item);
                break;
            }
            case 8: {
                this.setPaperdollItem(4, item);
                break;
            }
            case 32768: {
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(6, item);
                break;
            }
            case 1024: {
                this.setPaperdollItem(6, item);
                break;
            }
            case 2048: {
                L2ItemInstance chest = this.getPaperdollItem(6);
                if (chest != null && chest.getItem().getBodyPart() == 32768) {
                    this.setPaperdollItem(6, null);
                }
                this.setPaperdollItem(11, item);
                break;
            }
            case 4096: {
                this.setPaperdollItem(12, item);
                break;
            }
            case 512: {
                this.setPaperdollItem(10, item);
                break;
            }
            case 64: {
                this.setPaperdollItem(1, item);
                break;
            }
            case 65536: {
                L2ItemInstance hair = this.getPaperdollItem(2);
                if (hair != null && hair.getItem().getBodyPart() == 524288) {
                    this.setPaperdollItem(3, null);
                } else {
                    this.setPaperdollItem(2, null);
                }
                this.setPaperdollItem(2, item);
                break;
            }
            case 262144: {
                L2ItemInstance hair2 = this.getPaperdollItem(2);
                if (hair2 != null && hair2.getItem().getBodyPart() == 524288) {
                    this.setPaperdollItem(2, null);
                } else {
                    this.setPaperdollItem(3, null);
                }
                this.setPaperdollItem(3, item);
                break;
            }
            case 524288: {
                this.setPaperdollItem(3, null);
                this.setPaperdollItem(2, item);
                break;
            }
            case 1: {
                this.setPaperdollItem(0, item);
                break;
            }
            case 8192: {
                this.setPaperdollItem(23, item);
                break;
            }
            case 0x200000: {
                this.setPaperdollItem(15, item);
                break;
            }
            case 0x100000: {
                this.setPaperdollItem(16, item);
                break;
            }
            case 0x400000: {
                this.equipTalisman(item);
                break;
            }
            case 0x10000000: {
                this.setPaperdollItem(24, item);
                break;
            }
            case 131072: {
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(5, null);
                this.setPaperdollItem(5, null);
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(1, null);
                this.setPaperdollItem(12, null);
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(6, item);
                break;
            }
            default: {
                _log.warning("Unknown body slot " + targetSlot + " for Item ID:" + item.getItemId());
            }
        }
    }

    @Override
    protected void refreshWeight() {
        long weight = 0L;
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItem() == null) continue;
            weight += (long)item.getItem().getWeight() * item.getCount();
        }
        this._totalWeight = (int)Math.min(weight, Integer.MAX_VALUE);
    }

    public int getTotalWeight() {
        return this._totalWeight;
    }

    public L2ItemInstance findArrowForBow(L2Item bow) {
        if (bow == null) {
            return null;
        }
        L2ItemInstance arrow = null;
        switch (bow.getItemGradeSPlus()) {
            default: {
                arrow = this.getItemByItemId(17);
                break;
            }
            case 1: {
                arrow = this.getItemByItemId(1341);
                arrow = arrow != null ? arrow : this.getItemByItemId(22067);
                break;
            }
            case 2: {
                arrow = this.getItemByItemId(1342);
                arrow = arrow != null ? arrow : this.getItemByItemId(22068);
                break;
            }
            case 3: {
                arrow = this.getItemByItemId(1343);
                arrow = arrow != null ? arrow : this.getItemByItemId(22069);
                break;
            }
            case 4: {
                arrow = this.getItemByItemId(1344);
                arrow = arrow != null ? arrow : this.getItemByItemId(22070);
                break;
            }
            case 5: {
                arrow = this.getItemByItemId(1345);
                arrow = arrow != null ? arrow : this.getItemByItemId(22071);
            }
        }
        return arrow;
    }

    public L2ItemInstance findBoltForCrossBow(L2Item crossbow) {
        L2ItemInstance bolt = null;
        switch (crossbow.getItemGradeSPlus()) {
            default: {
                bolt = this.getItemByItemId(9632);
                break;
            }
            case 1: {
                bolt = this.getItemByItemId(9633);
                bolt = bolt != null ? bolt : this.getItemByItemId(22144);
                break;
            }
            case 2: {
                bolt = this.getItemByItemId(9634);
                bolt = bolt != null ? bolt : this.getItemByItemId(22145);
                break;
            }
            case 3: {
                bolt = this.getItemByItemId(9635);
                bolt = bolt != null ? bolt : this.getItemByItemId(22146);
                break;
            }
            case 4: {
                bolt = this.getItemByItemId(9636);
                bolt = bolt != null ? bolt : this.getItemByItemId(22147);
                break;
            }
            case 5: {
                bolt = this.getItemByItemId(9637);
                bolt = bolt != null ? bolt : this.getItemByItemId(22148);
            }
        }
        return bolt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time FROM items WHERE owner_id=? AND (loc=? OR loc=?) ORDER BY loc_data");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getBaseLocation().name());
            statement.setString(3, this.getEquipLocation().name());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                L2PcInstance player;
                L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), inv);
                if (item == null) continue;
                if (this.getOwner() instanceof L2PcInstance && !(player = (L2PcInstance)this.getOwner()).isGM() && !player.isHero() && item.isHeroItem()) {
                    item.setLocation(L2ItemInstance.ItemLocation.INVENTORY);
                }
                L2World.getInstance().storeObject(item);
                if (item.isStackable() && this.getItemByItemId(item.getItemId()) != null) {
                    this.addItem("Restore", item, this.getOwner().getActingPlayer(), null);
                    continue;
                }
                this.addItem(item);
            }
            inv.close();
            statement.close();
            this.refreshWeight();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore inventory: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public int getMaxTalismanCount() {
        return (int)this.getOwner().getStat().calcStat(Stats.TALISMAN_SLOTS, 0.0, null, null);
    }

    private void equipTalisman(L2ItemInstance item) {
        int i;
        if (this.getMaxTalismanCount() == 0) {
            return;
        }
        for (i = 17; i < 17 + this.getMaxTalismanCount(); ++i) {
            if (this._paperdoll[i] == null || this.getPaperdollItemId(i) != item.getItemId()) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        for (i = 17; i < 17 + this.getMaxTalismanCount(); ++i) {
            if (this._paperdoll[i] != null) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        this.setPaperdollItem(17, item);
    }

    public int getCloakStatus() {
        return (int)this.getOwner().getStat().calcStat(Stats.CLOAK_SLOT, 0.0, null, null);
    }

    public void reloadEquippedItems() {
        for (L2ItemInstance item : this._paperdoll) {
            if (item == null) continue;
            int slot = item.getLocationSlot();
            for (PaperdollListener listener : this._paperdollListeners) {
                if (listener == null) continue;
                listener.notifyUnequiped(slot, item, this);
                listener.notifyEquiped(slot, item, this);
            }
        }
    }

    private static final class BraceletListener
    implements PaperdollListener {
        private static BraceletListener instance = new BraceletListener();

        private BraceletListener() {
        }

        public static BraceletListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (item.getItem().getBodyPart() == 0x100000) {
                inventory.unEquipItemInSlot(17);
                inventory.unEquipItemInSlot(18);
                inventory.unEquipItemInSlot(19);
                inventory.unEquipItemInSlot(20);
                inventory.unEquipItemInSlot(21);
                inventory.unEquipItemInSlot(22);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
        }
    }

    private static final class ArmorSetListener
    implements PaperdollListener {
        private static ArmorSetListener instance = new ArmorSetListener();

        private ArmorSetListener() {
        }

        public static ArmorSetListener getInstance() {
            return instance;
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            L2ItemInstance chestItem = inventory.getPaperdollItem(6);
            if (chestItem == null) {
                return;
            }
            L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(chestItem.getItemId());
            if (armorSet == null) {
                return;
            }
            boolean update = false;
            boolean updateTimeStamp = false;
            if (armorSet.containItem(slot, item.getItemId())) {
                if (armorSet.containAll(player)) {
                    int skillId6;
                    String[] skills = armorSet.getSkills();
                    if (skills != null) {
                        for (String skillInfo : skills) {
                            int skillId = 0;
                            int skillLvl = 0;
                            String[] skill = skillInfo.split("-");
                            if (skill == null || skill.length != 2) continue;
                            try {
                                skillId = Integer.parseInt(skill[0]);
                                skillLvl = Integer.parseInt(skill[1]);
                            }
                            catch (NumberFormatException e) {
                                ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                            }
                            if (skillId <= 0 || skillLvl <= 0) continue;
                            L2Skill itemSkill = SkillTable.getInstance().getInfo(skillId, skillLvl);
                            if (itemSkill != null) {
                                player.addSkill(itemSkill, false);
                                if (itemSkill.isActive()) {
                                    int equipDelay;
                                    if ((player.getReuseTimeStamp().isEmpty() || !player.getReuseTimeStamp().containsKey(itemSkill.getReuseHashCode())) && (equipDelay = itemSkill.getEquipDelay()) > 0) {
                                        player.addTimeStamp(itemSkill, itemSkill.getEquipDelay());
                                        player.disableSkill(itemSkill, itemSkill.getEquipDelay());
                                    }
                                    updateTimeStamp = true;
                                }
                                update = true;
                                continue;
                            }
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                        }
                    }
                    if (armorSet.containShield(player)) {
                        L2Skill shieldSkill = SkillTable.getInstance().getInfo(armorSet.getShieldSkillId(), 1);
                        if (shieldSkill != null) {
                            player.addSkill(shieldSkill, false);
                            update = true;
                        } else {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getShieldSkillId() + ".");
                        }
                    }
                    if (armorSet.isEnchanted6(player) && (skillId6 = armorSet.getEnchant6skillId()) > 0) {
                        L2Skill skille = SkillTable.getInstance().getInfo(skillId6, 1);
                        if (skille != null) {
                            player.addSkill(skille, false);
                            update = true;
                        } else {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getEnchant6skillId() + ".");
                        }
                    }
                }
            } else if (armorSet.containShield(item.getItemId()) && armorSet.containAll(player)) {
                L2Skill shieldSkill = SkillTable.getInstance().getInfo(armorSet.getShieldSkillId(), 1);
                if (shieldSkill != null) {
                    player.addSkill(shieldSkill, false);
                    update = true;
                } else {
                    ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getShieldSkillId() + ".");
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            boolean remove = false;
            String[] skills = null;
            int shieldSkill = 0;
            int skillId6 = 0;
            if (slot == 6) {
                L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(item.getItemId());
                if (armorSet == null) {
                    return;
                }
                remove = true;
                skills = armorSet.getSkills();
                shieldSkill = armorSet.getShieldSkillId();
                skillId6 = armorSet.getEnchant6skillId();
            } else {
                L2ItemInstance chestItem = inventory.getPaperdollItem(6);
                if (chestItem == null) {
                    return;
                }
                L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(chestItem.getItemId());
                if (armorSet == null) {
                    return;
                }
                if (armorSet.containItem(slot, item.getItemId())) {
                    remove = true;
                    skills = armorSet.getSkills();
                    shieldSkill = armorSet.getShieldSkillId();
                    skillId6 = armorSet.getEnchant6skillId();
                } else if (armorSet.containShield(item.getItemId())) {
                    remove = true;
                    shieldSkill = armorSet.getShieldSkillId();
                }
            }
            if (remove) {
                L2Skill skill;
                if (skills != null) {
                    for (String skillInfo : skills) {
                        int skillId = 0;
                        int skillLvl = 0;
                        String[] skill2 = skillInfo.split("-");
                        if (skill2 == null || skill2.length != 2) continue;
                        try {
                            skillId = Integer.parseInt(skill2[0]);
                            skillLvl = Integer.parseInt(skill2[1]);
                        }
                        catch (NumberFormatException e) {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                        }
                        if (skillId <= 0 || skillLvl <= 0) continue;
                        L2Skill itemSkill = SkillTable.getInstance().getInfo(skillId, skillLvl);
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                    }
                }
                if (shieldSkill != 0) {
                    skill = SkillTable.getInstance().getInfo(shieldSkill, 1);
                    if (skill != null) {
                        player.removeSkill(skill, false, skill.isPassive());
                    } else {
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + shieldSkill + ".");
                    }
                }
                if (skillId6 != 0) {
                    skill = SkillTable.getInstance().getInfo(skillId6, 1);
                    if (skill != null) {
                        player.removeSkill(skill, false, skill.isPassive());
                    } else {
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillId6 + ".");
                    }
                }
                player.checkItemRestriction();
                player.sendSkillList();
            }
        }
    }

    private static final class ItemSkillsListener
    implements PaperdollListener {
        private static ItemSkillsListener instance = new ItemSkillsListener();

        private ItemSkillsListener() {
        }

        public static ItemSkillsListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            SkillHolder[] skills;
            L2Skill enchant4Skill;
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            if (it instanceof L2Weapon) {
                if (item.isAugmented()) {
                    item.getAugmentation().removeBonus(player);
                }
                item.removeElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Weapon)it).getEnchant4Skill()) != null) {
                    player.removeSkill(enchant4Skill, false, enchant4Skill.isPassive());
                    update = true;
                }
            } else if (it instanceof L2Armor) {
                if (item.isAugmented()) {
                    item.getAugmentation().removeBonus(player);
                }
                item.removeElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Armor)it).getEnchant4Skill()) != null) {
                    player.removeSkill(enchant4Skill, false, enchant4Skill.isPassive());
                    update = true;
                }
            }
            if ((skills = it.getSkills()) != null) {
                for (SkillHolder skillInfo : skills) {
                    if (skillInfo == null) continue;
                    L2Skill itemSkill = skillInfo.getSkill();
                    if (itemSkill != null) {
                        player.removeSkill(itemSkill, false, itemSkill.isPassive());
                        update = true;
                        continue;
                    }
                    ItemContainer._log.warning("Inventory.ItemSkillsListener.Weapon: Incorrect skill: " + skillInfo + ".");
                }
            }
            if (update) {
                player.sendSkillList();
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            SkillHolder[] skills;
            L2Skill enchant4Skill;
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            boolean updateTimeStamp = false;
            if (it instanceof L2Weapon) {
                if (item.isAugmented()) {
                    item.getAugmentation().applyBonus(player);
                }
                item.updateElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Weapon)it).getEnchant4Skill()) != null) {
                    player.addSkill(enchant4Skill, false);
                    update = true;
                }
            } else if (it instanceof L2Armor) {
                if (item.isAugmented()) {
                    item.getAugmentation().applyBonus(player);
                }
                item.updateElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Armor)it).getEnchant4Skill()) != null) {
                    player.addSkill(enchant4Skill, false);
                    update = true;
                }
            }
            if ((skills = it.getSkills()) != null) {
                for (SkillHolder skillInfo : skills) {
                    if (skillInfo == null) continue;
                    L2Skill itemSkill = skillInfo.getSkill();
                    if (itemSkill != null) {
                        player.addSkill(itemSkill, false);
                        if (itemSkill.isActive()) {
                            int equipDelay;
                            if ((player.getReuseTimeStamp().isEmpty() || !player.getReuseTimeStamp().containsKey(itemSkill.getReuseHashCode())) && (equipDelay = itemSkill.getEquipDelay()) > 0) {
                                player.addTimeStamp(itemSkill, equipDelay);
                                player.disableSkill(itemSkill, equipDelay);
                            }
                            updateTimeStamp = true;
                        }
                        update = true;
                        continue;
                    }
                    ItemContainer._log.warning("Inventory.ItemSkillsListener.Weapon: Incorrect skill: " + skillInfo + ".");
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }
    }

    private static final class StatsListener
    implements PaperdollListener {
        private static StatsListener instance = new StatsListener();

        private StatsListener() {
        }

        public static StatsListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            inventory.getOwner().removeStatsOwner(item);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            inventory.getOwner().addStatFuncs(item.getStatFuncs(inventory.getOwner()));
        }
    }

    private static final class BowCrossRodListener
    implements PaperdollListener {
        private static BowCrossRodListener instance = new BowCrossRodListener();

        private BowCrossRodListener() {
        }

        public static BowCrossRodListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2ItemInstance lure;
            if (slot != 5) {
                return;
            }
            if (item.getItemType() == L2WeaponType.BOW) {
                L2ItemInstance arrow = inventory.getPaperdollItem(7);
                if (arrow != null) {
                    inventory.setPaperdollItem(7, null);
                }
            } else if (item.getItemType() == L2WeaponType.CROSSBOW) {
                L2ItemInstance bolts = inventory.getPaperdollItem(7);
                if (bolts != null) {
                    inventory.setPaperdollItem(7, null);
                }
            } else if (item.getItemType() == L2WeaponType.FISHINGROD && (lure = inventory.getPaperdollItem(7)) != null) {
                inventory.setPaperdollItem(7, null);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2ItemInstance bolts;
            if (slot != 5) {
                return;
            }
            if (item.getItemType() == L2WeaponType.BOW) {
                L2ItemInstance arrow = inventory.findArrowForBow(item.getItem());
                if (arrow != null) {
                    inventory.setPaperdollItem(7, arrow);
                }
            } else if (item.getItemType() == L2WeaponType.CROSSBOW && (bolts = inventory.findBoltForCrossBow(item.getItem())) != null) {
                inventory.setPaperdollItem(7, bolts);
            }
        }
    }

    private static final class ChangeRecorder
    implements PaperdollListener {
        private final Inventory _inventory;
        private final List<L2ItemInstance> _changed;

        ChangeRecorder(Inventory inventory) {
            this._inventory = inventory;
            this._changed = new FastList();
            this._inventory.addPaperdollListener(this);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        public L2ItemInstance[] getChangedItems() {
            return this._changed.toArray(new L2ItemInstance[this._changed.size()]);
        }
    }

    public static interface PaperdollListener {
        public void notifyEquiped(int var1, L2ItemInstance var2, Inventory var3);

        public void notifyUnequiped(int var1, L2ItemInstance var2, Inventory var3);
    }
}

