/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;

public class Mail
extends ItemContainer {
    private final int _ownerId;
    private int _messageId;

    public Mail(int objectId, int messageId) {
        this._ownerId = objectId;
        this._messageId = messageId;
    }

    @Override
    public String getName() {
        return "Mail";
    }

    @Override
    public L2PcInstance getOwner() {
        return null;
    }

    @Override
    public L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.MAIL;
    }

    public int getMessageId() {
        return this._messageId;
    }

    public void setNewMessageId(int messageId) {
        this._messageId = messageId;
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            item.setLocation(this.getBaseLocation(), messageId);
        }
        this.updateDatabase();
    }

    public void returnToWh(ItemContainer wh) {
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            if (wh == null) {
                item.setLocation(L2ItemInstance.ItemLocation.WAREHOUSE);
                continue;
            }
            this.transferItem("Expire", item.getObjectId(), item.getCount(), wh, null, null);
        }
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        item.setLocation(this.getBaseLocation(), this._messageId);
    }

    @Override
    public void updateDatabase() {
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            item.updateDatabase(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time FROM items WHERE owner_id=? AND loc=? AND loc_data=?");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getBaseLocation().name());
            statement.setInt(3, this.getMessageId());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), inv);
                if (item == null) continue;
                L2World.getInstance().storeObject(item);
                if (item.isStackable() && this.getItemByItemId(item.getItemId()) != null) {
                    this.addItem("Restore", item, null, null);
                    continue;
                }
                this.addItem(item);
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore container:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    @Override
    public int getOwnerId() {
        return this._ownerId;
    }
}

