/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import java.util.logging.Level;

public class PcRefund
extends ItemContainer {
    private final L2PcInstance _owner;

    public PcRefund(L2PcInstance owner) {
        this._owner = owner;
    }

    @Override
    public String getName() {
        return "Refund";
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    public L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.REFUND;
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        try {
            L2ItemInstance removedItem;
            if (this.getSize() > 12 && (removedItem = (L2ItemInstance)this._items.remove(0)) != null) {
                ItemTable.getInstance().destroyItem("ClearRefund", removedItem, this.getOwner(), null);
                removedItem.updateDatabase(true);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "addItem()", e);
        }
    }

    @Override
    public void refreshWeight() {
    }

    @Override
    public void deleteMe() {
        try {
            for (L2ItemInstance item : this._items) {
                if (item == null) continue;
                ItemTable.getInstance().destroyItem("ClearRefund", item, this.getOwner(), null);
                item.updateDatabase(true);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        this._items.clear();
    }

    @Override
    public void restore() {
    }
}

