/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.item.type.L2EtcItemType;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;

public class PetInventory
extends Inventory {
    private final L2PetInstance _owner;

    public PetInventory(L2PetInstance owner) {
        this._owner = owner;
    }

    @Override
    public L2PetInstance getOwner() {
        return this._owner;
    }

    @Override
    public int getOwnerId() {
        int id;
        try {
            id = this._owner.getOwner().getObjectId();
        }
        catch (NullPointerException e) {
            return 0;
        }
        return id;
    }

    @Override
    protected void refreshWeight() {
        super.refreshWeight();
        this.getOwner().updateAndBroadcastStatus(1);
    }

    public boolean validateCapacity(L2ItemInstance item) {
        int slots = 0;
        if (!(item.isStackable() && this.getItemByItemId(item.getItemId()) != null || item.getItemType() == L2EtcItemType.HERB)) {
            ++slots;
        }
        return this.validateCapacity(slots);
    }

    @Override
    public boolean validateCapacity(int slots) {
        return this._items.size() + slots <= this._owner.getInventoryLimit();
    }

    public boolean validateWeight(L2ItemInstance item, long count) {
        int weight = 0;
        L2Item template = ItemTable.getInstance().getTemplate(item.getItemId());
        if (template == null) {
            return false;
        }
        weight = (int)((long)weight + count * (long)template.getWeight());
        return this.validateWeight(weight);
    }

    @Override
    public boolean validateWeight(int weight) {
        return this._totalWeight + weight <= this._owner.getMaxLoad();
    }

    @Override
    protected L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.PET;
    }

    @Override
    protected L2ItemInstance.ItemLocation getEquipLocation() {
        return L2ItemInstance.ItemLocation.PET_EQUIP;
    }

    @Override
    public void restore() {
        super.restore();
        for (L2ItemInstance item : this._items) {
            if (!item.isEquipped() || item.getItem().checkCondition(this.getOwner(), this.getOwner(), false)) continue;
            this.unEquipItemInSlot(item.getLocationSlot());
        }
    }

    public void transferItemsToOwner() {
        for (L2ItemInstance item : this._items) {
            this.getOwner().transferItem("return", item.getObjectId(), item.getCount(), this.getOwner().getOwner().getInventory(), this.getOwner().getOwner(), this.getOwner());
        }
    }
}

