/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameNormal;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.util.Rnd;
import java.util.List;

public class OlympiadGameClassed
extends OlympiadGameNormal {
    private OlympiadGameClassed(int id, Participant[] opponents) {
        super(id, opponents);
    }

    @Override
    public final CompetitionType getType() {
        return CompetitionType.CLASSED;
    }

    @Override
    protected final int getDivider() {
        return Config.ALT_OLY_DIVIDER_CLASSED;
    }

    @Override
    protected final int[][] getReward() {
        return Config.ALT_OLY_CLASSED_REWARD;
    }

    @Override
    protected final String getWeeklyMatchType() {
        return "competitions_done_week_classed";
    }

    protected static final OlympiadGameClassed createGame(int id, List<List<Integer>> classList) {
        if (classList == null || classList.isEmpty()) {
            return null;
        }
        while (!classList.isEmpty()) {
            List<Integer> list = classList.get(Rnd.nextInt(classList.size()));
            if (list == null || list.size() < 2) {
                classList.remove(list);
                continue;
            }
            Participant[] opponents = OlympiadGameNormal.createListOfParticipants(list);
            if (opponents == null) {
                classList.remove(list);
                continue;
            }
            return new OlympiadGameClassed(id, opponents);
        }
        return null;
    }
}

