/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.network.serverpackets.AgitDecoInfo;

public class L2ClanHallZone
extends L2ZoneRespawn {
    private int _clanHallId;

    public L2ClanHallZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("clanHallId")) {
            this._clanHallId = Integer.parseInt(value);
            ClanHall hall = ClanHallManager.getInstance().getClanHallById(this._clanHallId);
            if (hall == null) {
                _log.warning("L2ClanHallZone: Clan hall with id " + this._clanHallId + " does not exist!");
            } else {
                hall.setZone(this);
            }
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)4, true);
            AuctionableHall clanHall = ClanHallManager.getInstance().getAuctionableHallById(this._clanHallId);
            if (clanHall == null) {
                return;
            }
            AgitDecoInfo deco = new AgitDecoInfo(clanHall);
            ((L2PcInstance)character).sendPacket(deco);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)4, false);
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void banishForeigners(int owningClanId) {
        for (L2Character temp : this.getCharactersInsideArray()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClanId() == owningClanId) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionManager.TeleportWhereType.ClanHall_banish);
        }
    }

    public int getClanHallId() {
        return this._clanHallId;
    }
}

