/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;

public class L2NoLandingZone
extends L2ZoneType {
    private int dismountDelay = 5;

    public L2NoLandingZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)6, true);
            if (((L2PcInstance)character).getMountType() == 2) {
                character.sendPacket(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN);
                ((L2PcInstance)character).enteredNoLanding(this.dismountDelay);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)6, false);
            if (((L2PcInstance)character).getMountType() == 2) {
                ((L2PcInstance)character).exitedNoLanding();
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("dismountDelay")) {
            this.dismountDelay = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }
}

